/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.ITspiAddress;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.summary.CountryCode;
import buri.ddmsence.ddms.summary.tspi.GeneralAddressClass;
import buri.ddmsence.ddms.summary.tspi.IntersectionAddress;
import buri.ddmsence.ddms.summary.tspi.LandmarkAddress;
import buri.ddmsence.ddms.summary.tspi.NumberedThoroughfareAddress;
import buri.ddmsence.ddms.summary.tspi.TwoNumberAddressRange;
import buri.ddmsence.ddms.summary.tspi.USPSGeneralDeliveryOffice;
import buri.ddmsence.ddms.summary.tspi.USPSPostalDeliveryBox;
import buri.ddmsence.ddms.summary.tspi.USPSPostalDeliveryRoute;
import buri.ddmsence.ddms.summary.tspi.UnnumberedThoroughfareAddress;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;

public final class PostalAddress
extends AbstractBaseComponent {
    private List<String> _streets = null;
    private String _city = null;
    private String _state = null;
    private String _province = null;
    private String _postalCode = null;
    private CountryCode _countryCode = null;
    private ITspiAddress _tspiAddress = null;
    private static final String STREET_NAME = "street";
    private static final String CITY_NAME = "city";
    private static final String STATE_NAME = "state";
    private static final String PROVINCE_NAME = "province";
    private static final String POSTAL_CODE_NAME = "postalCode";

    public PostalAddress(Element element) throws InvalidDDMSException {
        try {
            this.setXOMElement(element, false);
            if (!this.getDDMSVersion().isAtLeast("5.0")) {
                Element element2;
                Element element3;
                Element element4;
                Element element5;
                this._streets = Util.getDDMSChildValues(element, STREET_NAME);
                Element element6 = element.getFirstChildElement(CITY_NAME, this.getNamespace());
                if (element6 != null) {
                    this._city = element6.getValue();
                }
                if ((element5 = element.getFirstChildElement(STATE_NAME, this.getNamespace())) != null) {
                    this._state = element5.getValue();
                }
                if ((element4 = element.getFirstChildElement(PROVINCE_NAME, this.getNamespace())) != null) {
                    this._province = element4.getValue();
                }
                if ((element3 = element.getFirstChildElement(POSTAL_CODE_NAME, this.getNamespace())) != null) {
                    this._postalCode = element3.getValue();
                }
                if ((element2 = element.getFirstChildElement(CountryCode.getName(this.getDDMSVersion()), this.getNamespace())) != null) {
                    this._countryCode = new CountryCode(element2);
                }
            } else {
                Element element7;
                Element element8;
                Element element9;
                Element element10;
                Element element11;
                Element element12;
                Element element13;
                Element element14;
                String string = this.getDDMSVersion().getTspiNamespace();
                Element element15 = element.getFirstChildElement(GeneralAddressClass.getName(this.getDDMSVersion()), string);
                if (element15 != null) {
                    this._tspiAddress = new GeneralAddressClass(element15);
                }
                if ((element14 = element.getFirstChildElement(IntersectionAddress.getName(this.getDDMSVersion()), string)) != null) {
                    this._tspiAddress = new IntersectionAddress(element14);
                }
                if ((element13 = element.getFirstChildElement(LandmarkAddress.getName(this.getDDMSVersion()), string)) != null) {
                    this._tspiAddress = new LandmarkAddress(element13);
                }
                if ((element12 = element.getFirstChildElement(NumberedThoroughfareAddress.getName(this.getDDMSVersion()), string)) != null) {
                    this._tspiAddress = new NumberedThoroughfareAddress(element12);
                }
                if ((element11 = element.getFirstChildElement(TwoNumberAddressRange.getName(this.getDDMSVersion()), string)) != null) {
                    this._tspiAddress = new TwoNumberAddressRange(element11);
                }
                if ((element10 = element.getFirstChildElement(UnnumberedThoroughfareAddress.getName(this.getDDMSVersion()), string)) != null) {
                    this._tspiAddress = new UnnumberedThoroughfareAddress(element10);
                }
                if ((element9 = element.getFirstChildElement(USPSGeneralDeliveryOffice.getName(this.getDDMSVersion()), string)) != null) {
                    this._tspiAddress = new USPSGeneralDeliveryOffice(element9);
                }
                if ((element8 = element.getFirstChildElement(USPSPostalDeliveryBox.getName(this.getDDMSVersion()), string)) != null) {
                    this._tspiAddress = new USPSPostalDeliveryBox(element8);
                }
                if ((element7 = element.getFirstChildElement(USPSPostalDeliveryRoute.getName(this.getDDMSVersion()), string)) != null) {
                    this._tspiAddress = new USPSPostalDeliveryRoute(element7);
                }
            }
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public PostalAddress(List<String> list, String string, String string2, String string3, CountryCode countryCode, boolean bl) throws InvalidDDMSException {
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            Element element = Util.buildDDMSElement(PostalAddress.getName(DDMSVersion.getCurrentVersion()), null);
            for (String string4 : list) {
                element.appendChild((Node)Util.buildDDMSElement(STREET_NAME, string4));
            }
            Util.addDDMSChildElement(element, CITY_NAME, string);
            if (bl) {
                Util.addDDMSChildElement(element, STATE_NAME, string2);
            } else {
                Util.addDDMSChildElement(element, PROVINCE_NAME, string2);
            }
            Util.addDDMSChildElement(element, POSTAL_CODE_NAME, string3);
            if (countryCode != null) {
                element.appendChild((Node)countryCode.getXOMElementCopy());
            }
            this._streets = list;
            this._city = string;
            this._state = bl ? string2 : "";
            this._province = bl ? "" : string2;
            this._postalCode = string3;
            this._countryCode = countryCode;
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public PostalAddress(ITspiAddress iTspiAddress) throws InvalidDDMSException {
        try {
            Element element = Util.buildDDMSElement(PostalAddress.getName(DDMSVersion.getCurrentVersion()), null);
            if (iTspiAddress != null) {
                element.appendChild((Node)iTspiAddress.getXOMElementCopy());
                if (iTspiAddress instanceof GeneralAddressClass) {
                    this._tspiAddress = (GeneralAddressClass)iTspiAddress;
                }
                if (iTspiAddress instanceof IntersectionAddress) {
                    this._tspiAddress = (IntersectionAddress)iTspiAddress;
                }
                if (iTspiAddress instanceof LandmarkAddress) {
                    this._tspiAddress = (LandmarkAddress)iTspiAddress;
                }
                if (iTspiAddress instanceof NumberedThoroughfareAddress) {
                    this._tspiAddress = (NumberedThoroughfareAddress)iTspiAddress;
                }
                if (iTspiAddress instanceof TwoNumberAddressRange) {
                    this._tspiAddress = (TwoNumberAddressRange)iTspiAddress;
                }
                if (iTspiAddress instanceof UnnumberedThoroughfareAddress) {
                    this._tspiAddress = (UnnumberedThoroughfareAddress)iTspiAddress;
                }
                if (iTspiAddress instanceof USPSGeneralDeliveryOffice) {
                    this._tspiAddress = (USPSGeneralDeliveryOffice)iTspiAddress;
                }
                if (iTspiAddress instanceof USPSPostalDeliveryBox) {
                    this._tspiAddress = (USPSPostalDeliveryBox)iTspiAddress;
                }
                if (iTspiAddress instanceof USPSPostalDeliveryRoute) {
                    this._tspiAddress = (USPSPostalDeliveryRoute)iTspiAddress;
                }
            }
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), PostalAddress.getName(this.getDDMSVersion()));
        if (!this.getDDMSVersion().isAtLeast("5.0")) {
            Util.requireBoundedChildCount(this.getXOMElement(), STREET_NAME, 0, 6);
            if (!Util.isEmpty(this.getState()) && !Util.isEmpty(this.getProvince())) {
                throw new InvalidDDMSException("Only 1 of state or province must be used.");
            }
        } else {
            if (!(this.getStreets().isEmpty() && Util.isEmpty(this.getCity()) && Util.isEmpty(this.getState()) && Util.isEmpty(this.getProvince()) && Util.isEmpty(this.getPostalCode()) && this.getCountryCode() == null)) {
                throw new InvalidDDMSException("postalAddress must be defined with a TSPI address.");
            }
            Util.requireDDMSValue("TSPI address", this.getTspiAddress());
        }
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (!this.getDDMSVersion().isAtLeast("5.0") && this.getStreets().isEmpty() && Util.isEmpty(this.getCity()) && Util.isEmpty(this.getState()) && Util.isEmpty(this.getProvince()) && Util.isEmpty(this.getPostalCode()) && this.getCountryCode() == null) {
            this.addWarning("A completely empty ddms:postalAddress element was found.");
        }
        super.validateWarnings();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.getDDMSVersion().isAtLeast("5.0")) {
            stringBuffer.append(this.buildOutput(bl, string3 + STREET_NAME, this.getStreets()));
            stringBuffer.append(PostalAddress.buildOutput(bl, string3 + CITY_NAME, this.getCity()));
            stringBuffer.append(PostalAddress.buildOutput(bl, string3 + STATE_NAME, this.getState()));
            stringBuffer.append(PostalAddress.buildOutput(bl, string3 + PROVINCE_NAME, this.getProvince()));
            stringBuffer.append(PostalAddress.buildOutput(bl, string3 + POSTAL_CODE_NAME, this.getPostalCode()));
            if (this.getCountryCode() != null) {
                stringBuffer.append(this.getCountryCode().getOutput(bl, string3, ""));
            }
        } else {
            stringBuffer.append(this.getTspiAddress().getOutput(bl, string3, ""));
        }
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.add(this.getCountryCode());
        arrayList.add(this.getTspiAddress());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof PostalAddress)) {
            return false;
        }
        PostalAddress postalAddress = (PostalAddress)object;
        return Util.listEquals(this.getStreets(), postalAddress.getStreets()) && this.getCity().equals(postalAddress.getCity()) && this.getState().equals(postalAddress.getState()) && this.getProvince().equals(postalAddress.getProvince()) && this.getPostalCode().equals(postalAddress.getPostalCode());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getStreets().hashCode();
        n = 7 * n + this.getCity().hashCode();
        n = 7 * n + this.getState().hashCode();
        n = 7 * n + this.getProvince().hashCode();
        n = 7 * n + this.getPostalCode().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "postalAddress";
    }

    public List<String> getStreets() {
        if (this._streets == null) {
            this._streets = Collections.emptyList();
        }
        return Collections.unmodifiableList(this._streets);
    }

    public String getCity() {
        return Util.getNonNullString(this._city);
    }

    public String getState() {
        return Util.getNonNullString(this._state);
    }

    public String getProvince() {
        return Util.getNonNullString(this._province);
    }

    public String getPostalCode() {
        return Util.getNonNullString(this._postalCode);
    }

    public CountryCode getCountryCode() {
        return this._countryCode;
    }

    public ITspiAddress getTspiAddress() {
        return this._tspiAddress;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 6887962646280796652L;
        private List<String> _streets;
        private String _city;
        private String _state;
        private String _province;
        private String _postalCode;
        private CountryCode.Builder _countryCode;
        private String _addressType;
        private GeneralAddressClass.Builder _generalAddressClass;
        private IntersectionAddress.Builder _intersectionAddress;
        private LandmarkAddress.Builder _landmarkAddress;
        private NumberedThoroughfareAddress.Builder _numberedThoroughfareAddress;
        private TwoNumberAddressRange.Builder _twoNumberAddressRange;
        private UnnumberedThoroughfareAddress.Builder _unnumberedThoroughfareAddress;
        private USPSGeneralDeliveryOffice.Builder _uspsGeneralDeliveryOffice;
        private USPSPostalDeliveryBox.Builder _uspsPostalDeliveryBox;
        private USPSPostalDeliveryRoute.Builder _uspsPostalDeliveryRoute;

        public Builder() {
        }

        public Builder(PostalAddress postalAddress) {
            DDMSVersion dDMSVersion = postalAddress.getDDMSVersion();
            this.setStreets(postalAddress.getStreets());
            this.setCity(postalAddress.getCity());
            this.setState(postalAddress.getState());
            this.setProvince(postalAddress.getProvince());
            this.setPostalCode(postalAddress.getPostalCode());
            if (postalAddress.getCountryCode() != null) {
                this.setCountryCode(new CountryCode.Builder(postalAddress.getCountryCode()));
            }
            if (postalAddress.getTspiAddress() != null) {
                this.setAddressType(postalAddress.getTspiAddress().getName());
                if (GeneralAddressClass.getName(dDMSVersion).equals(this.getAddressType())) {
                    this.setGeneralAddressClass(new GeneralAddressClass.Builder((GeneralAddressClass)postalAddress.getTspiAddress()));
                }
                if (IntersectionAddress.getName(dDMSVersion).equals(this.getAddressType())) {
                    this.setIntersectionAddress(new IntersectionAddress.Builder((IntersectionAddress)postalAddress.getTspiAddress()));
                }
                if (LandmarkAddress.getName(dDMSVersion).equals(this.getAddressType())) {
                    this.setLandmarkAddress(new LandmarkAddress.Builder((LandmarkAddress)postalAddress.getTspiAddress()));
                }
                if (NumberedThoroughfareAddress.getName(dDMSVersion).equals(this.getAddressType())) {
                    this.setNumberedThoroughfareAddress(new NumberedThoroughfareAddress.Builder((NumberedThoroughfareAddress)postalAddress.getTspiAddress()));
                }
                if (TwoNumberAddressRange.getName(dDMSVersion).equals(this.getAddressType())) {
                    this.setTwoNumberAddressRange(new TwoNumberAddressRange.Builder((TwoNumberAddressRange)postalAddress.getTspiAddress()));
                }
                if (UnnumberedThoroughfareAddress.getName(dDMSVersion).equals(this.getAddressType())) {
                    this.setUnnumberedThoroughfareAddress(new UnnumberedThoroughfareAddress.Builder((UnnumberedThoroughfareAddress)postalAddress.getTspiAddress()));
                }
                if (USPSGeneralDeliveryOffice.getName(dDMSVersion).equals(this.getAddressType())) {
                    this.setUSPSGeneralDeliveryOffice(new USPSGeneralDeliveryOffice.Builder((USPSGeneralDeliveryOffice)postalAddress.getTspiAddress()));
                }
                if (USPSPostalDeliveryBox.getName(dDMSVersion).equals(this.getAddressType())) {
                    this.setUSPSPostalDeliveryBox(new USPSPostalDeliveryBox.Builder((USPSPostalDeliveryBox)postalAddress.getTspiAddress()));
                }
                if (USPSPostalDeliveryRoute.getName(dDMSVersion).equals(this.getAddressType())) {
                    this.setUSPSPostalDeliveryRoute(new USPSPostalDeliveryRoute.Builder((USPSPostalDeliveryRoute)postalAddress.getTspiAddress()));
                }
            }
        }

        @Override
        public PostalAddress commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            if (!DDMSVersion.getCurrentVersion().isAtLeast("5.0")) {
                boolean bl;
                boolean bl2 = bl = !Util.isEmpty(this.getState()) && !Util.isEmpty(this.getProvince());
                if (bl) {
                    throw new InvalidDDMSException("Only 1 of state or province must be used.");
                }
                boolean bl3 = !Util.isEmpty(this.getState());
                String string = bl3 ? this.getState() : this.getProvince();
                return new PostalAddress(this.getStreets(), this.getCity(), string, this.getPostalCode(), this.getCountryCode().commit(), bl3);
            }
            return new PostalAddress(this.commitSelectedAddress());
        }

        protected ITspiAddress commitSelectedAddress() throws InvalidDDMSException {
            DDMSVersion dDMSVersion = DDMSVersion.getCurrentVersion();
            if (GeneralAddressClass.getName(dDMSVersion).equals(this.getAddressType())) {
                return this.getGeneralAddressClass().commit();
            }
            if (IntersectionAddress.getName(dDMSVersion).equals(this.getAddressType())) {
                return this.getIntersectionAddress().commit();
            }
            if (LandmarkAddress.getName(dDMSVersion).equals(this.getAddressType())) {
                return this.getLandmarkAddress().commit();
            }
            if (NumberedThoroughfareAddress.getName(dDMSVersion).equals(this.getAddressType())) {
                return this.getNumberedThoroughfareAddress().commit();
            }
            if (TwoNumberAddressRange.getName(dDMSVersion).equals(this.getAddressType())) {
                return this.getTwoNumberAddressRange().commit();
            }
            if (UnnumberedThoroughfareAddress.getName(dDMSVersion).equals(this.getAddressType())) {
                return this.getUnnumberedThoroughfareAddress().commit();
            }
            if (USPSGeneralDeliveryOffice.getName(dDMSVersion).equals(this.getAddressType())) {
                return this.getUSPSGeneralDeliveryOffice().commit();
            }
            if (USPSPostalDeliveryBox.getName(dDMSVersion).equals(this.getAddressType())) {
                return this.getUSPSPostalDeliveryBox().commit();
            }
            if (USPSPostalDeliveryRoute.getName(dDMSVersion).equals(this.getAddressType())) {
                return this.getUSPSPostalDeliveryRoute().commit();
            }
            throw new InvalidDDMSException("Unknown address type: " + this.getAddressType());
        }

        @Override
        public boolean isEmpty() {
            return Util.containsOnlyEmptyValues(this.getStreets()) && Util.isEmpty(this.getCity()) && Util.isEmpty(this.getState()) && Util.isEmpty(this.getProvince()) && Util.isEmpty(this.getPostalCode()) && this.getCountryCode().isEmpty() && this.getGeneralAddressClass().isEmpty() && this.getIntersectionAddress().isEmpty() && this.getLandmarkAddress().isEmpty() && this.getNumberedThoroughfareAddress().isEmpty() && this.getTwoNumberAddressRange().isEmpty() && this.getUnnumberedThoroughfareAddress().isEmpty() && this.getUSPSGeneralDeliveryOffice().isEmpty() && this.getUSPSPostalDeliveryBox().isEmpty() && this.getUSPSPostalDeliveryRoute().isEmpty();
        }

        public List<String> getStreets() {
            if (this._streets == null) {
                this._streets = new LazyList(String.class);
            }
            return this._streets;
        }

        public void setStreets(List<String> list) {
            this._streets = new LazyList(list, String.class);
        }

        public String getCity() {
            return this._city;
        }

        public void setCity(String string) {
            this._city = string;
        }

        public String getState() {
            return this._state;
        }

        public void setState(String string) {
            this._state = string;
        }

        public String getProvince() {
            return this._province;
        }

        public void setProvince(String string) {
            this._province = string;
        }

        public String getPostalCode() {
            return this._postalCode;
        }

        public void setPostalCode(String string) {
            this._postalCode = string;
        }

        public CountryCode.Builder getCountryCode() {
            if (this._countryCode == null) {
                this._countryCode = new CountryCode.Builder();
            }
            return this._countryCode;
        }

        public void setCountryCode(CountryCode.Builder builder) {
            this._countryCode = builder;
        }

        public String getAddressType() {
            return this._addressType;
        }

        public void setAddressType(String string) {
            this._addressType = string;
        }

        public GeneralAddressClass.Builder getGeneralAddressClass() {
            if (this._generalAddressClass == null) {
                this._generalAddressClass = new GeneralAddressClass.Builder();
            }
            return this._generalAddressClass;
        }

        public void setGeneralAddressClass(GeneralAddressClass.Builder builder) {
            this._generalAddressClass = builder;
        }

        public IntersectionAddress.Builder getIntersectionAddress() {
            if (this._intersectionAddress == null) {
                this._intersectionAddress = new IntersectionAddress.Builder();
            }
            return this._intersectionAddress;
        }

        public void setIntersectionAddress(IntersectionAddress.Builder builder) {
            this._intersectionAddress = builder;
        }

        public LandmarkAddress.Builder getLandmarkAddress() {
            if (this._landmarkAddress == null) {
                this._landmarkAddress = new LandmarkAddress.Builder();
            }
            return this._landmarkAddress;
        }

        public void setLandmarkAddress(LandmarkAddress.Builder builder) {
            this._landmarkAddress = builder;
        }

        public NumberedThoroughfareAddress.Builder getNumberedThoroughfareAddress() {
            if (this._numberedThoroughfareAddress == null) {
                this._numberedThoroughfareAddress = new NumberedThoroughfareAddress.Builder();
            }
            return this._numberedThoroughfareAddress;
        }

        public void setNumberedThoroughfareAddress(NumberedThoroughfareAddress.Builder builder) {
            this._numberedThoroughfareAddress = builder;
        }

        public TwoNumberAddressRange.Builder getTwoNumberAddressRange() {
            if (this._twoNumberAddressRange == null) {
                this._twoNumberAddressRange = new TwoNumberAddressRange.Builder();
            }
            return this._twoNumberAddressRange;
        }

        public void setTwoNumberAddressRange(TwoNumberAddressRange.Builder builder) {
            this._twoNumberAddressRange = builder;
        }

        public UnnumberedThoroughfareAddress.Builder getUnnumberedThoroughfareAddress() {
            if (this._unnumberedThoroughfareAddress == null) {
                this._unnumberedThoroughfareAddress = new UnnumberedThoroughfareAddress.Builder();
            }
            return this._unnumberedThoroughfareAddress;
        }

        public void setUnnumberedThoroughfareAddress(UnnumberedThoroughfareAddress.Builder builder) {
            this._unnumberedThoroughfareAddress = builder;
        }

        public USPSGeneralDeliveryOffice.Builder getUSPSGeneralDeliveryOffice() {
            if (this._uspsGeneralDeliveryOffice == null) {
                this._uspsGeneralDeliveryOffice = new USPSGeneralDeliveryOffice.Builder();
            }
            return this._uspsGeneralDeliveryOffice;
        }

        public void setUSPSGeneralDeliveryOffice(USPSGeneralDeliveryOffice.Builder builder) {
            this._uspsGeneralDeliveryOffice = builder;
        }

        public USPSPostalDeliveryBox.Builder getUSPSPostalDeliveryBox() {
            if (this._uspsPostalDeliveryBox == null) {
                this._uspsPostalDeliveryBox = new USPSPostalDeliveryBox.Builder();
            }
            return this._uspsPostalDeliveryBox;
        }

        public void setUSPSPostalDeliveryBox(USPSPostalDeliveryBox.Builder builder) {
            this._uspsPostalDeliveryBox = builder;
        }

        public USPSPostalDeliveryRoute.Builder getUSPSPostalDeliveryRoute() {
            if (this._uspsPostalDeliveryRoute == null) {
                this._uspsPostalDeliveryRoute = new USPSPostalDeliveryRoute.Builder();
            }
            return this._uspsPostalDeliveryRoute;
        }

        public void setUSPSPostalDeliveryRoute(USPSPostalDeliveryRoute.Builder builder) {
            this._uspsPostalDeliveryRoute = builder;
        }
    }
}

