/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.security.ntk;

import buri.ddmsence.AbstractNtkString;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import nu.xom.Element;

public final class ProfileValue
extends AbstractNtkString {
    private static final String VOCABULARY_NAME = "vocabulary";

    public ProfileValue(Element element) throws InvalidDDMSException {
        super(false, element);
    }

    public ProfileValue(String string, String string2, String string3, String string4, String string5, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        super(false, ProfileValue.getName(DDMSVersion.getCurrentVersion()), string, string3, string4, string5, securityAttributes, false);
        try {
            Util.addAttribute(this.getXOMElement(), PropertyReader.getPrefix("ntk"), VOCABULARY_NAME, DDMSVersion.getCurrentVersion().getNtkNamespace(), string2);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireQName(this.getXOMElement(), this.getNamespace(), ProfileValue.getName(this.getDDMSVersion()));
        Util.requireValidNMToken(this.getVocabulary());
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (Util.isEmpty(this.getValue())) {
            this.addWarning("A ntk:" + this.getName() + " element was found with no value.");
        }
        super.validateWarnings();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, "profileValue", string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ProfileValue.buildOutput(bl, string3, this.getValue()));
        stringBuffer.append(ProfileValue.buildOutput(bl, string3 + ".vocabulary", this.getVocabulary()));
        stringBuffer.append(ProfileValue.buildOutput(bl, string3 + ".id", this.getID()));
        stringBuffer.append(ProfileValue.buildOutput(bl, string3 + ".idReference", this.getIDReference()));
        stringBuffer.append(ProfileValue.buildOutput(bl, string3 + ".qualifier", this.getQualifier()));
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3 + "."));
        return stringBuffer.toString();
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "AccessProfileValue";
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof ProfileValue)) {
            return false;
        }
        ProfileValue profileValue = (ProfileValue)object;
        return this.getVocabulary().equals(profileValue.getVocabulary());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getVocabulary().hashCode();
        return n;
    }

    public String getVocabulary() {
        return this.getAttributeValue(VOCABULARY_NAME, this.getDDMSVersion().getNtkNamespace());
    }

    public static class Builder
    extends AbstractNtkString.Builder {
        private static final long serialVersionUID = 7750664735441105296L;
        private String _vocabulary;

        public Builder() {
        }

        public Builder(ProfileValue profileValue) {
            super(profileValue);
            this.setVocabulary(profileValue.getVocabulary());
        }

        @Override
        public ProfileValue commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new ProfileValue(this.getValue(), this.getVocabulary(), this.getID(), this.getIDReference(), this.getQualifier(), this.getSecurityAttributes().commit());
        }

        public String getVocabulary() {
            return this._vocabulary;
        }

        public void setVocabulary(String string) {
            this._vocabulary = string;
        }
    }
}

