/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.security.ntk;

import buri.ddmsence.AbstractAccessEntity;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.ddms.security.ntk.ProfileValue;
import buri.ddmsence.ddms.security.ntk.SystemName;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public final class Profile
extends AbstractAccessEntity {
    private List<ProfileValue> _profileValues = null;

    public Profile(Element element) throws InvalidDDMSException {
        super(element);
        try {
            Elements elements = element.getChildElements(ProfileValue.getName(this.getDDMSVersion()), this.getNamespace());
            this._profileValues = new ArrayList<ProfileValue>();
            for (int i = 0; i < elements.size(); ++i) {
                this._profileValues.add(new ProfileValue(elements.get(i)));
            }
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public Profile(SystemName systemName, List<ProfileValue> list, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        super(Profile.getName(DDMSVersion.getCurrentVersion()), systemName, securityAttributes);
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            for (ProfileValue profileValue : list) {
                this.getXOMElement().appendChild((Node)profileValue.getXOMElementCopy());
            }
            this._profileValues = list;
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireQName(this.getXOMElement(), this.getNamespace(), Profile.getName(this.getDDMSVersion()));
        if (this.getProfileValues().isEmpty()) {
            throw new InvalidDDMSException("At least one profile value must exist.");
        }
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, "profile", string2) + ".";
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getSystemName() != null) {
            stringBuffer.append(this.getSystemName().getOutput(bl, string3, ""));
        }
        stringBuffer.append(this.buildOutput(bl, string3, this.getProfileValues()));
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        List<IDDMSComponent> list = super.getNestedComponents();
        list.addAll(this.getProfileValues());
        return list;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof Profile;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "AccessProfile";
    }

    public List<ProfileValue> getProfileValues() {
        return Collections.unmodifiableList(this._profileValues);
    }

    public static class Builder
    extends AbstractAccessEntity.Builder {
        private static final long serialVersionUID = 7851044806424206976L;
        private List<ProfileValue.Builder> _profileValues;

        public Builder() {
        }

        public Builder(Profile profile) {
            super(profile);
            for (ProfileValue profileValue : profile.getProfileValues()) {
                this.getProfileValues().add(new ProfileValue.Builder(profileValue));
            }
        }

        @Override
        public Profile commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<ProfileValue> arrayList = new ArrayList<ProfileValue>();
            for (IBuilder iBuilder : this.getProfileValues()) {
                ProfileValue profileValue = (ProfileValue)iBuilder.commit();
                if (profileValue == null) continue;
                arrayList.add(profileValue);
            }
            return new Profile(this.getSystemName().commit(), arrayList, this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (IBuilder iBuilder : this.getProfileValues()) {
                bl = bl || !iBuilder.isEmpty();
            }
            return !bl && super.isEmpty();
        }

        public List<ProfileValue.Builder> getProfileValues() {
            if (this._profileValues == null) {
                this._profileValues = new LazyList(ProfileValue.Builder.class);
            }
            return this._profileValues;
        }
    }
}

