/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.resource;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.resource.Addressee;
import buri.ddmsence.ddms.resource.RequesterInfo;
import buri.ddmsence.ddms.resource.TaskID;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.ddms.summary.Description;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public final class TaskingInfo
extends AbstractBaseComponent {
    private List<RequesterInfo> _requesterInfos = null;
    private List<Addressee> _addressees = null;
    private Description _description = null;
    private TaskID _taskID = null;
    private SecurityAttributes _securityAttributes = null;

    public TaskingInfo(Element element) throws InvalidDDMSException {
        try {
            Element element2;
            Util.requireDDMSValue("element", element);
            this.setXOMElement(element, false);
            this._requesterInfos = new ArrayList<RequesterInfo>();
            Elements elements = element.getChildElements(RequesterInfo.getName(this.getDDMSVersion()), this.getNamespace());
            for (int i = 0; i < elements.size(); ++i) {
                this._requesterInfos.add(new RequesterInfo(elements.get(i)));
            }
            this._addressees = new ArrayList<Addressee>();
            Elements elements2 = element.getChildElements(Addressee.getName(this.getDDMSVersion()), this.getNamespace());
            for (int i = 0; i < elements2.size(); ++i) {
                this._addressees.add(new Addressee(elements2.get(i)));
            }
            Element element3 = element.getFirstChildElement(Description.getName(this.getDDMSVersion()), this.getNamespace());
            if (element3 != null) {
                this._description = new Description(element3);
            }
            if ((element2 = element.getFirstChildElement(TaskID.getName(this.getDDMSVersion()), this.getNamespace())) != null) {
                this._taskID = new TaskID(element2);
            }
            this._securityAttributes = new SecurityAttributes(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public TaskingInfo(List<RequesterInfo> list, List<Addressee> list2, Description description, TaskID taskID, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            if (list2 == null) {
                list2 = Collections.emptyList();
            }
            Element element = Util.buildDDMSElement(TaskingInfo.getName(DDMSVersion.getCurrentVersion()), null);
            this.setXOMElement(element, false);
            for (RequesterInfo abstractTaskingRole : list) {
                element.appendChild((Node)abstractTaskingRole.getXOMElementCopy());
            }
            for (Addressee addressee : list2) {
                element.appendChild((Node)addressee.getXOMElementCopy());
            }
            if (description != null) {
                element.appendChild((Node)description.getXOMElementCopy());
            }
            if (taskID != null) {
                element.appendChild((Node)taskID.getXOMElementCopy());
            }
            this._requesterInfos = list;
            this._addressees = list2;
            this._description = description;
            this._taskID = taskID;
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        this.requireAtLeastVersion("4.0.1");
        Util.requireDDMSQName(this.getXOMElement(), TaskingInfo.getName(this.getDDMSVersion()));
        Util.requireDDMSValue("taskID", this.getTaskID());
        this.getSecurityAttributes().requireClassification();
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.buildOutput(bl, string3, this.getRequesterInfos()));
        stringBuffer.append(this.buildOutput(bl, string3, this.getAddressees()));
        if (this.getDescription() != null) {
            stringBuffer.append(this.getDescription().getOutput(bl, string3, ""));
        }
        stringBuffer.append(this.getTaskID().getOutput(bl, string3, ""));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.addAll(this.getRequesterInfos());
        arrayList.addAll(this.getAddressees());
        arrayList.add(this.getDescription());
        arrayList.add(this.getTaskID());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof TaskingInfo;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "taskingInfo";
    }

    public List<RequesterInfo> getRequesterInfos() {
        return this._requesterInfos;
    }

    public List<Addressee> getAddressees() {
        return this._addressees;
    }

    public Description getDescription() {
        return this._description;
    }

    public TaskID getTaskID() {
        return this._taskID;
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 7851044806424206976L;
        private List<RequesterInfo.Builder> _requesterInfos;
        private List<Addressee.Builder> _addressees;
        private Description.Builder _description;
        private TaskID.Builder _taskID;
        private SecurityAttributes.Builder _securityAttributes;

        public Builder() {
        }

        public Builder(TaskingInfo taskingInfo) {
            for (RequesterInfo abstractTaskingRole : taskingInfo.getRequesterInfos()) {
                this.getRequesterInfos().add(new RequesterInfo.Builder(abstractTaskingRole));
            }
            for (Addressee addressee : taskingInfo.getAddressees()) {
                this.getAddressees().add(new Addressee.Builder(addressee));
            }
            if (taskingInfo.getDescription() != null) {
                this.setDescription(new Description.Builder(taskingInfo.getDescription()));
            }
            this.setTaskID(new TaskID.Builder(taskingInfo.getTaskID()));
            this.setSecurityAttributes(new SecurityAttributes.Builder(taskingInfo.getSecurityAttributes()));
        }

        @Override
        public TaskingInfo commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<RequesterInfo> arrayList = new ArrayList<RequesterInfo>();
            for (IBuilder object : this.getRequesterInfos()) {
                RequesterInfo requesterInfo = (RequesterInfo)object.commit();
                if (requesterInfo == null) continue;
                arrayList.add(requesterInfo);
            }
            ArrayList arrayList2 = new ArrayList();
            for (IBuilder iBuilder : this.getAddressees()) {
                Addressee addressee = (Addressee)iBuilder.commit();
                if (addressee == null) continue;
                arrayList2.add(addressee);
            }
            return new TaskingInfo(arrayList, arrayList2, this.getDescription().commit(), this.getTaskID().commit(), this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (IBuilder iBuilder : this.getRequesterInfos()) {
                bl = bl || !iBuilder.isEmpty();
            }
            for (IBuilder iBuilder : this.getAddressees()) {
                bl = bl || !iBuilder.isEmpty();
            }
            return !bl && this.getDescription().isEmpty() && this.getTaskID().isEmpty() && this.getSecurityAttributes().isEmpty();
        }

        public List<RequesterInfo.Builder> getRequesterInfos() {
            if (this._requesterInfos == null) {
                this._requesterInfos = new LazyList(RequesterInfo.Builder.class);
            }
            return this._requesterInfos;
        }

        public List<Addressee.Builder> getAddressees() {
            if (this._addressees == null) {
                this._addressees = new LazyList(Addressee.Builder.class);
            }
            return this._addressees;
        }

        public Description.Builder getDescription() {
            if (this._description == null) {
                this._description = new Description.Builder();
            }
            return this._description;
        }

        public void setDescription(Description.Builder builder) {
            this._description = builder;
        }

        public TaskID.Builder getTaskID() {
            if (this._taskID == null) {
                this._taskID = new TaskID.Builder();
            }
            return this._taskID;
        }

        public void setTaskID(TaskID.Builder builder) {
            this._taskID = builder;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

