/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.resource;

import buri.ddmsence.AbstractRoleEntity;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.extensible.ExtensibleAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;

public final class Person
extends AbstractRoleEntity {
    private List<String> _affiliations = null;
    private static final String AFFILIATION_NAME = "affiliation";
    private static final String USERID_NAME = "userID";
    private static final String SURNAME_NAME = "surname";

    public Person(Element element) throws InvalidDDMSException {
        super(element, true);
        this._affiliations = Util.getDDMSChildValues(element, AFFILIATION_NAME);
    }

    public Person(List<String> list, String string, List<String> list2, List<String> list3, String string2, List<String> list4) throws InvalidDDMSException {
        this(list, string, list2, list3, string2, list4, null);
    }

    public Person(List<String> list, String string, List<String> list2, List<String> list3, String string2, List<String> list4, ExtensibleAttributes extensibleAttributes) throws InvalidDDMSException {
        super(Person.getName(DDMSVersion.getCurrentVersion()), list, list2, list3, extensibleAttributes);
        try {
            int n = list == null ? 0 : list.size();
            this.addExtraElements(n, string, string2, list4);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    private void addExtraElements(int n, String string, String string2, List<String> list) throws InvalidDDMSException {
        if (list == null) {
            list = Collections.emptyList();
        }
        Element element = this.getXOMElement();
        if (this.getDDMSVersion().isAtLeast("4.0.1")) {
            element.insertChild((Node)Util.buildDDMSElement(SURNAME_NAME, string), n);
            if (!Util.isEmpty(string2)) {
                element.appendChild((Node)Util.buildDDMSElement(USERID_NAME, string2));
            }
            for (String string3 : list) {
                element.appendChild((Node)Util.buildDDMSElement(AFFILIATION_NAME, string3));
            }
        } else {
            for (String string4 : list) {
                element.insertChild((Node)Util.buildDDMSElement(AFFILIATION_NAME, string4), n);
            }
            if (!Util.isEmpty(string2)) {
                element.insertChild((Node)Util.buildDDMSElement(USERID_NAME, string2), n);
            }
            element.insertChild((Node)Util.buildDDMSElement(SURNAME_NAME, string), n);
        }
        this._affiliations = list;
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), Person.getName(this.getDDMSVersion()));
        Util.requireDDMSValue(SURNAME_NAME, this.getSurname());
        if (!this.getDDMSVersion().isAtLeast("5.0")) {
            Util.requireBoundedChildCount(this.getXOMElement(), AFFILIATION_NAME, 0, 1);
        }
        if (this.getDDMSVersion().isAtLeast("4.0.1") && !this.getExtensibleAttributes().isEmpty()) {
            throw new InvalidDDMSException("ddms:" + this.getName() + " must not have extensible attributes after DDMS 3.1.");
        }
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, "", string2);
        StringBuffer stringBuffer = new StringBuffer(super.getOutput(bl, string3, ""));
        stringBuffer.append(Person.buildOutput(bl, string3 + SURNAME_NAME, this.getSurname()));
        stringBuffer.append(Person.buildOutput(bl, string3 + USERID_NAME, this.getUserID()));
        stringBuffer.append(this.buildOutput(bl, string3 + AFFILIATION_NAME, this.getAffiliations()));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof Person)) {
            return false;
        }
        Person person = (Person)object;
        return this.getSurname().equals(person.getSurname()) && this.getUserID().equals(person.getUserID()) && Util.listEquals(this.getAffiliations(), person.getAffiliations());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getSurname().hashCode();
        n = 7 * n + this.getUserID().hashCode();
        n = 7 * n + this.getAffiliations().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return dDMSVersion.isAtLeast("4.0.1") ? "person" : "Person";
    }

    public String getSurname() {
        return Util.getFirstDDMSChildValue(this.getXOMElement(), SURNAME_NAME);
    }

    public String getUserID() {
        return Util.getFirstDDMSChildValue(this.getXOMElement(), USERID_NAME);
    }

    public List<String> getAffiliations() {
        return Collections.unmodifiableList(this._affiliations);
    }

    public static class Builder
    extends AbstractRoleEntity.Builder {
        private static final long serialVersionUID = -2933889158864177338L;
        private String _surname;
        private String _userID;
        private List<String> _affiliations;

        public Builder() {
        }

        public Builder(Person person) {
            super(person);
            this.setSurname(person.getSurname());
            this.setUserID(person.getUserID());
            this.setAffiliations(person.getAffiliations());
        }

        @Override
        public Person commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new Person(this.getNames(), this.getSurname(), this.getPhones(), this.getEmails(), this.getUserID(), this.getAffiliations(), this.getExtensibleAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && Util.isEmpty(this.getSurname()) && Util.isEmpty(this.getUserID()) && Util.containsOnlyEmptyValues(this.getAffiliations());
        }

        public String getSurname() {
            return this._surname;
        }

        public void setSurname(String string) {
            this._surname = string;
        }

        public String getUserID() {
            return this._userID;
        }

        public void setUserID(String string) {
            this._userID = string;
        }

        public List<String> getAffiliations() {
            if (this._affiliations == null) {
                this._affiliations = new LazyList(String.class);
            }
            return this._affiliations;
        }

        public void setAffiliations(List<String> list) {
            this._affiliations = new LazyList(list, String.class);
        }
    }
}

