/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.resource;

import buri.ddmsence.AbstractRoleEntity;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.extensible.ExtensibleAttributes;
import buri.ddmsence.ddms.resource.SubOrganization;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public final class Organization
extends AbstractRoleEntity {
    private List<SubOrganization> _subOrganizations = null;
    private static final String ACRONYM_NAME = "acronym";

    public Organization(Element element) throws InvalidDDMSException {
        super(element, false);
        try {
            String string = element.getNamespaceURI();
            Elements elements = element.getChildElements(SubOrganization.getName(this.getDDMSVersion()), string);
            this._subOrganizations = new ArrayList<SubOrganization>();
            for (int i = 0; i < elements.size(); ++i) {
                this._subOrganizations.add(new SubOrganization(elements.get(i)));
            }
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public Organization(List<String> list, List<String> list2, List<String> list3, List<SubOrganization> list4, String string) throws InvalidDDMSException {
        this(list, list2, list3, list4, string, null);
    }

    public Organization(List<String> list, List<String> list2, List<String> list3, List<SubOrganization> list4, String string, ExtensibleAttributes extensibleAttributes) throws InvalidDDMSException {
        super(Organization.getName(DDMSVersion.getCurrentVersion()), list, list2, list3, extensibleAttributes);
        try {
            if (list4 == null) {
                list4 = Collections.emptyList();
            }
            Util.addDDMSAttribute(this.getXOMElement(), ACRONYM_NAME, string);
            for (SubOrganization subOrganization : list4) {
                this.getXOMElement().appendChild((Node)subOrganization.getXOMElementCopy());
            }
            this._subOrganizations = list4;
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), Organization.getName(this.getDDMSVersion()));
        if (!this.getDDMSVersion().isAtLeast("4.0.1") && !Util.isEmpty(this.getAcronym())) {
            throw new InvalidDDMSException("An organization must not have an acronym until DDMS 4.0.1 or later.");
        }
        if (this.getDDMSVersion().isAtLeast("5.0") && !this.getExtensibleAttributes().isEmpty()) {
            throw new InvalidDDMSException("ddms:" + this.getName() + " must not have extensible attributes after DDMS 4.1.");
        }
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, "", string2);
        StringBuffer stringBuffer = new StringBuffer(super.getOutput(bl, string3, ""));
        stringBuffer.append(this.buildOutput(bl, string3, this.getSubOrganizations()));
        stringBuffer.append(Organization.buildOutput(bl, string3 + ACRONYM_NAME, this.getAcronym()));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.addAll(this.getSubOrganizations());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof Organization)) {
            return false;
        }
        Organization organization = (Organization)object;
        return this.getAcronym().equals(organization.getAcronym());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getAcronym().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return dDMSVersion.isAtLeast("4.0.1") ? "organization" : "Organization";
    }

    public List<SubOrganization> getSubOrganizations() {
        return Collections.unmodifiableList(this._subOrganizations);
    }

    public String getAcronym() {
        return this.getAttributeValue(ACRONYM_NAME);
    }

    public static class Builder
    extends AbstractRoleEntity.Builder {
        private static final long serialVersionUID = 4565840434345629470L;
        private List<SubOrganization.Builder> _subOrganizations;
        private String _acronym;

        public Builder() {
        }

        public Builder(Organization organization) {
            super(organization);
            for (SubOrganization subOrganization : organization.getSubOrganizations()) {
                this.getSubOrganizations().add(new SubOrganization.Builder(subOrganization));
            }
            this.setAcronym(organization.getAcronym());
        }

        @Override
        public Organization commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<SubOrganization> arrayList = new ArrayList<SubOrganization>();
            for (IBuilder iBuilder : this.getSubOrganizations()) {
                SubOrganization subOrganization = (SubOrganization)iBuilder.commit();
                if (subOrganization == null) continue;
                arrayList.add(subOrganization);
            }
            return new Organization(this.getNames(), this.getPhones(), this.getEmails(), arrayList, this.getAcronym(), this.getExtensibleAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (IBuilder iBuilder : this.getSubOrganizations()) {
                bl = bl || !iBuilder.isEmpty();
            }
            return super.isEmpty() && !bl && Util.isEmpty(this.getAcronym());
        }

        public List<SubOrganization.Builder> getSubOrganizations() {
            if (this._subOrganizations == null) {
                this._subOrganizations = new LazyList(SubOrganization.Builder.class);
            }
            return this._subOrganizations;
        }

        public String getAcronym() {
            return this._acronym;
        }

        public void setAcronym(String string) {
            this._acronym = string;
        }
    }
}

