/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.format;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.format.Extent;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;

public final class Format
extends AbstractBaseComponent {
    private String _mimeType = null;
    private Extent _extent = null;
    private String _medium = null;
    private static final String MEDIA_NAME = "Media";
    private static final String MIME_TYPE_NAME = "mimeType";
    private static final String MEDIUM_NAME = "medium";

    public Format(Element element) throws InvalidDDMSException {
        try {
            this.setXOMElement(element, false);
            Element element2 = this.getMediaElement();
            if (element2 != null) {
                Element element3;
                Element element4;
                Element element5 = element2.getFirstChildElement(MIME_TYPE_NAME, this.getNamespace());
                if (element5 != null) {
                    this._mimeType = element5.getValue();
                }
                if ((element4 = element2.getFirstChildElement(Extent.getName(this.getDDMSVersion()), this.getNamespace())) != null) {
                    this._extent = new Extent(element4);
                }
                if ((element3 = element2.getFirstChildElement(MEDIUM_NAME, this.getNamespace())) != null) {
                    this._medium = element3.getValue();
                }
            }
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public Format(String string, Extent extent, String string2) throws InvalidDDMSException {
        try {
            Element element = Util.buildDDMSElement(Format.getName(DDMSVersion.getCurrentVersion()), null);
            Element element2 = DDMSVersion.getCurrentVersion().isAtLeast("4.0.1") ? element : Util.buildDDMSElement(MEDIA_NAME, null);
            Util.addDDMSChildElement(element2, MIME_TYPE_NAME, string);
            if (extent != null) {
                element2.appendChild((Node)extent.getXOMElementCopy());
            }
            Util.addDDMSChildElement(element2, MEDIUM_NAME, string2);
            if (!DDMSVersion.getCurrentVersion().isAtLeast("4.0.1")) {
                element.appendChild((Node)element2);
            }
            this._mimeType = string;
            this._extent = extent;
            this._medium = string2;
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), Format.getName(this.getDDMSVersion()));
        Element element = this.getMediaElement();
        Util.requireDDMSValue("Media element", element);
        Util.requireDDMSValue(MIME_TYPE_NAME, this.getMimeType());
        super.validate();
    }

    @Override
    protected String getLocatorSuffix() {
        return this.getDDMSVersion().isAtLeast("4.0.1") ? "" : "/" + this.getXOMElement().getNamespacePrefix() + ":" + MEDIA_NAME;
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        if (!this.getDDMSVersion().isAtLeast("4.0.1")) {
            string3 = string3 + "Media.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Format.buildOutput(bl, string3 + MIME_TYPE_NAME, this.getMimeType()));
        if (this.getExtent() != null) {
            stringBuffer.append(this.getExtent().getOutput(bl, string3, ""));
        }
        stringBuffer.append(Format.buildOutput(bl, string3 + MEDIUM_NAME, this.getMedium()));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.add(this.getExtent());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof Format)) {
            return false;
        }
        Format format = (Format)object;
        boolean bl = this.getMimeType().equals(format.getMimeType()) && this.getMedium().equals(format.getMedium());
        return bl;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getMimeType().hashCode();
        n = 7 * n + this.getMedium().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "format";
    }

    private Element getMediaElement() {
        return this.getDDMSVersion().isAtLeast("4.0.1") ? this.getXOMElement() : this.getChild(MEDIA_NAME);
    }

    public String getMimeType() {
        return Util.getNonNullString(this._mimeType);
    }

    public Extent getExtent() {
        return this._extent;
    }

    public String getExtentQualifier() {
        return this.getExtent() == null ? "" : this.getExtent().getQualifier();
    }

    public String getExtentValue() {
        return this.getExtent() == null ? "" : this.getExtent().getValue();
    }

    public String getMedium() {
        return Util.getNonNullString(this._medium);
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 7851044806424206976L;
        private String _mimeType;
        private Extent.Builder _extent;
        private String _medium;

        public Builder() {
        }

        public Builder(Format format) {
            this.setMimeType(format.getMimeType());
            if (format.getExtent() != null) {
                this.setExtent(new Extent.Builder(format.getExtent()));
            }
            this.setMedium(format.getMedium());
        }

        @Override
        public Format commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new Format(this.getMimeType(), this.getExtent().commit(), this.getMedium());
        }

        @Override
        public boolean isEmpty() {
            return Util.isEmpty(this.getMimeType()) && Util.isEmpty(this.getMedium()) && this.getExtent().isEmpty();
        }

        public String getMimeType() {
            return this._mimeType;
        }

        public void setMimeType(String string) {
            this._mimeType = string;
        }

        public Extent.Builder getExtent() {
            if (this._extent == null) {
                this._extent = new Extent.Builder();
            }
            return this._extent;
        }

        public void setExtent(Extent.Builder builder) {
            this._extent = builder;
        }

        public String getMedium() {
            return this._medium;
        }

        public void setMedium(String string) {
            this._medium = string;
        }
    }
}

