/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.extensible;

import buri.ddmsence.AbstractAttributeGroup;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.Resource;
import buri.ddmsence.ddms.security.ism.NoticeAttributes;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.ddms.summary.Category;
import buri.ddmsence.ddms.summary.Keyword;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import nu.xom.Attribute;
import nu.xom.Element;

public final class ExtensibleAttributes
extends AbstractAttributeGroup {
    private List<Attribute> _attributes = null;
    private static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private final Set<QName> RESERVED_RESOURCE_NAMES = new HashSet<QName>();

    public static ExtensibleAttributes getNonNullInstance(ExtensibleAttributes extensibleAttributes) throws InvalidDDMSException {
        return extensibleAttributes == null ? new ExtensibleAttributes((List<Attribute>)null) : extensibleAttributes;
    }

    public ExtensibleAttributes(Element element) throws InvalidDDMSException {
        this.buildReservedNames(element.getNamespaceURI());
        DDMSVersion dDMSVersion = DDMSVersion.getVersionForNamespace(element.getNamespaceURI());
        this._attributes = new ArrayList<Attribute>();
        for (int i = 0; i < element.getAttributeCount(); ++i) {
            QName qName;
            Attribute attribute = element.getAttribute(i);
            if (attribute.getNamespaceURI().equals(XSI_NAMESPACE) || element.getNamespaceURI().equals(attribute.getNamespaceURI()) || (Resource.getName(dDMSVersion).equals(element.getLocalName()) || Category.getName(dDMSVersion).equals(element.getLocalName()) || Keyword.getName(dDMSVersion).equals(element.getLocalName())) && this.RESERVED_RESOURCE_NAMES.contains(qName = new QName(attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getNamespacePrefix()))) continue;
            this._attributes.add(attribute);
        }
        this.validate(dDMSVersion);
    }

    public ExtensibleAttributes(List<Attribute> list) throws InvalidDDMSException {
        if (list == null) {
            list = Collections.emptyList();
        }
        this._attributes = new ArrayList<Attribute>(list);
        this.validate(DDMSVersion.getCurrentVersion());
    }

    private void buildReservedNames(String string) {
        DDMSVersion dDMSVersion = DDMSVersion.getVersionForNamespace(string);
        this.RESERVED_RESOURCE_NAMES.clear();
        String string2 = PropertyReader.getPrefix("ism");
        String string3 = PropertyReader.getPrefix("ntk");
        for (String string4 : Resource.NON_EXTENSIBLE_NAMES) {
            this.RESERVED_RESOURCE_NAMES.add(new QName(dDMSVersion.getIsmNamespace(), string4, string2));
        }
        for (String string4 : SecurityAttributes.NON_EXTENSIBLE_NAMES) {
            this.RESERVED_RESOURCE_NAMES.add(new QName(dDMSVersion.getIsmNamespace(), string4, string2));
        }
        if (dDMSVersion.isAtLeast("4.0.1")) {
            for (String string4 : NoticeAttributes.NON_EXTENSIBLE_NAMES) {
                this.RESERVED_RESOURCE_NAMES.add(new QName(dDMSVersion.getIsmNamespace(), string4, string2));
            }
            this.RESERVED_RESOURCE_NAMES.add(new QName(dDMSVersion.getNtkNamespace(), "DESVersion", string3));
        }
    }

    public void addTo(Element element) throws InvalidDDMSException {
        for (Attribute attribute : this.getAttributes()) {
            if (element.getAttribute(attribute.getLocalName(), attribute.getNamespaceURI()) != null) {
                throw new InvalidDDMSException("The extensible attribute with the name, " + attribute.getQualifiedName() + " conflicts with a pre-existing attribute on the element.");
            }
            element.addAttribute(attribute);
        }
    }

    public boolean isEmpty() {
        return this.getAttributes().isEmpty();
    }

    @Override
    protected void validate(DDMSVersion dDMSVersion) throws InvalidDDMSException {
        super.validate(dDMSVersion);
    }

    @Override
    public String getOutput(boolean bl, String string) {
        String string2 = Util.getNonNullString(string);
        StringBuffer stringBuffer = new StringBuffer();
        for (Attribute attribute : this.getAttributes()) {
            stringBuffer.append(Resource.buildOutput(bl, string2 + attribute.getNamespacePrefix() + "." + attribute.getLocalName(), attribute.getValue()));
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExtensibleAttributes)) {
            return false;
        }
        ExtensibleAttributes extensibleAttributes = (ExtensibleAttributes)object;
        if (this.getAttributes().size() != extensibleAttributes.getAttributes().size()) {
            return false;
        }
        for (int i = 0; i < this.getAttributes().size(); ++i) {
            Attribute attribute = this.getAttributes().get(i);
            Attribute attribute2 = extensibleAttributes.getAttributes().get(i);
            if (attribute.getLocalName().equals(attribute2.getLocalName()) && attribute.getNamespaceURI().equals(attribute2.getNamespaceURI())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (Attribute attribute : this.getAttributes()) {
            n = 7 * n + attribute.getLocalName().hashCode();
            n = 7 * n + attribute.getNamespaceURI().hashCode();
        }
        return n;
    }

    public List<Attribute> getAttributes() {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (Attribute attribute : this._attributes) {
            arrayList.add(new Attribute(attribute));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static class AttributeBuilder
    implements Serializable {
        private static final long serialVersionUID = -5102193614065692204L;
        private String _name;
        private String _uri;
        private String _value;
        private Attribute.Type _type;

        public AttributeBuilder() {
        }

        public AttributeBuilder(Attribute attribute) {
            this.setName(attribute.getQualifiedName());
            this.setUri(attribute.getNamespaceURI());
            this.setValue(attribute.getValue());
            this.setType(attribute.getType());
        }

        public Attribute commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new Attribute(this.getName(), this.getUri(), this.getValue(), this.getType());
        }

        public boolean isEmpty() {
            return Util.isEmpty(this.getName()) && Util.isEmpty(this.getUri()) && Util.isEmpty(this.getValue()) && this.getType() == null;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String string) {
            this._name = string;
        }

        public String getUri() {
            return this._uri;
        }

        public void setUri(String string) {
            this._uri = string;
        }

        public String getValue() {
            return this._value;
        }

        public void setValue(String string) {
            this._value = string;
        }

        public Attribute.Type getType() {
            return this._type;
        }

        public void setType(Attribute.Type type) {
            this._type = type;
        }
    }

    public static class Builder
    implements Serializable {
        private static final long serialVersionUID = 1257270526054778197L;
        private List<AttributeBuilder> _attributes;

        public Builder() {
        }

        public Builder(ExtensibleAttributes extensibleAttributes) {
            for (Attribute attribute : extensibleAttributes.getAttributes()) {
                this.getAttributes().add(new AttributeBuilder(attribute));
            }
        }

        public ExtensibleAttributes commit() throws InvalidDDMSException {
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            for (AttributeBuilder attributeBuilder : this.getAttributes()) {
                Attribute attribute = attributeBuilder.commit();
                if (attribute == null) continue;
                arrayList.add(attribute);
            }
            return new ExtensibleAttributes(arrayList);
        }

        public boolean isEmpty() {
            return this.getAttributes().isEmpty();
        }

        public List<AttributeBuilder> getAttributes() {
            if (this._attributes == null) {
                this._attributes = new LazyList(AttributeBuilder.class);
            }
            return this._attributes;
        }
    }
}

