/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.ITspiShape;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.summary.gml.SRSAttributes;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import nu.xom.Element;

public abstract class AbstractTspiShape
extends AbstractBaseComponent
implements ITspiShape {
    private SRSAttributes _srsAttributes = null;
    private static final String ID_NAME = "id";

    protected AbstractTspiShape(Element element) throws InvalidDDMSException {
        try {
            this.setXOMElement(element, false);
            this._srsAttributes = new SRSAttributes(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        this.requireAtLeastVersion("5.0");
        Util.requireDDMSValue("srsAttributes", this.getSRSAttributes());
        Util.requireDDMSValue("srsName", this.getSRSAttributes().getSrsName());
        Util.requireDDMSValue(ID_NAME, this.getId());
        Util.requireValidNCName(this.getId());
        super.validate();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        AbstractTspiShape abstractTspiShape = (AbstractTspiShape)object;
        return this.toXML().equals(abstractTspiShape.toXML());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.toXML().hashCode();
        return n;
    }

    public String getId() {
        return this.getAttributeValue(ID_NAME, this.getDDMSVersion().getGmlNamespace());
    }

    public SRSAttributes getSRSAttributes() {
        return this._srsAttributes;
    }

    public static abstract class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 7824644958681123708L;
        private String _xml;

        protected Builder() {
        }

        protected Builder(AbstractTspiShape abstractTspiShape) {
            this.setXml(abstractTspiShape.toXML());
        }

        protected Element commitXml() throws InvalidDDMSException {
            return Util.commitXml(this.getXml());
        }

        @Override
        public boolean isEmpty() {
            return Util.isEmpty(this.getXml());
        }

        public String getXml() {
            return this._xml;
        }

        public void setXml(String string) {
            this._xml = string;
        }
    }
}

