/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary.gml;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.summary.gml.SRSAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;

public final class Position
extends AbstractBaseComponent {
    private SRSAttributes _srsAttributes = null;
    private List<Double> _coordinates = null;

    public Position(Element element) throws InvalidDDMSException {
        try {
            this.setXOMElement(element, false);
            List<String> list = Util.getXsListAsList(this.getCoordinatesAsXsList());
            this._coordinates = new ArrayList<Double>();
            for (String string : list) {
                this._coordinates.add(Double.valueOf(string));
            }
            this._srsAttributes = new SRSAttributes(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public Position(List<Double> list, SRSAttributes sRSAttributes) throws InvalidDDMSException {
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            DDMSVersion dDMSVersion = DDMSVersion.getCurrentVersion();
            Element element = Util.buildElement(PropertyReader.getPrefix("gml"), Position.getName(dDMSVersion), dDMSVersion.getGmlNamespace(), Util.getXsList(list));
            this._coordinates = list;
            this._srsAttributes = SRSAttributes.getNonNullInstance(sRSAttributes);
            this._srsAttributes.addTo(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireQName(this.getXOMElement(), this.getNamespace(), Position.getName(this.getDDMSVersion()));
        for (Double d : this.getCoordinates()) {
            Util.requireDDMSValue("coordinate", d);
        }
        if (!Util.isBounded(this.getCoordinates().size(), 2, 3)) {
            throw new InvalidDDMSException("A position must be represented by either 2 or 3 coordinates.");
        }
        Util.requireValidLatitude(this.getCoordinates().get(0));
        Util.requireValidLongitude(this.getCoordinates().get(1));
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        this.addWarnings(this.getSRSAttributes().getValidationWarnings(), true);
        super.validateWarnings();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Position.buildOutput(bl, string3, this.getCoordinatesAsXsList()));
        stringBuffer.append(this.getSRSAttributes().getOutput(bl, string3 + "."));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof Position)) {
            return false;
        }
        Position position = (Position)object;
        return this.getSRSAttributes().equals(position.getSRSAttributes()) && this.getCoordinates().size() == position.getCoordinates().size() && Util.listEquals(this.getCoordinates(), position.getCoordinates());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getSRSAttributes().hashCode();
        n = 7 * n + this.getCoordinatesAsXsList().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "pos";
    }

    public SRSAttributes getSRSAttributes() {
        return this._srsAttributes;
    }

    public List<Double> getCoordinates() {
        return Collections.unmodifiableList(this._coordinates);
    }

    public String getCoordinatesAsXsList() {
        return this.getXOMElement().getValue();
    }

    public static class DoubleBuilder
    implements Serializable {
        private static final long serialVersionUID = -5102193614065692204L;
        private Double _value;

        public DoubleBuilder() {
        }

        public DoubleBuilder(Double d) {
            this.setValue(d);
        }

        public Double commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : this.getValue();
        }

        public boolean isEmpty() {
            return this.getValue() == null;
        }

        public Double getValue() {
            return this._value;
        }

        public void setValue(Double d) {
            this._value = d;
        }
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 33638279863455987L;
        private SRSAttributes.Builder _srsAttributes;
        private List<DoubleBuilder> _coordinates;

        public Builder() {
        }

        public Builder(Position position) {
            this.setSrsAttributes(new SRSAttributes.Builder(position.getSRSAttributes()));
            for (Double d : position.getCoordinates()) {
                this.getCoordinates().add(new DoubleBuilder(d));
            }
        }

        @Override
        public Position commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (DoubleBuilder doubleBuilder : this.getCoordinates()) {
                Double d = doubleBuilder.commit();
                if (d == null) continue;
                arrayList.add(d);
            }
            return new Position(arrayList, this.getSrsAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (DoubleBuilder doubleBuilder : this.getCoordinates()) {
                bl = bl || !doubleBuilder.isEmpty();
            }
            return !bl && this.getSrsAttributes().isEmpty();
        }

        public SRSAttributes.Builder getSrsAttributes() {
            if (this._srsAttributes == null) {
                this._srsAttributes = new SRSAttributes.Builder();
            }
            return this._srsAttributes;
        }

        public void setSrsAttributes(SRSAttributes.Builder builder) {
            this._srsAttributes = builder;
        }

        public List<DoubleBuilder> getCoordinates() {
            if (this._coordinates == null) {
                this._coordinates = new LazyList(DoubleBuilder.class);
            }
            return this._coordinates;
        }
    }
}

