/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.ddms.summary.BoundingBox;
import buri.ddmsence.ddms.summary.BoundingGeometry;
import buri.ddmsence.ddms.summary.GeographicIdentifier;
import buri.ddmsence.ddms.summary.PostalAddress;
import buri.ddmsence.ddms.summary.VerticalExtent;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;

public final class GeospatialCoverage
extends AbstractBaseComponent {
    private GeographicIdentifier _geographicIdentifier = null;
    private BoundingBox _boundingBox = null;
    private BoundingGeometry _boundingGeometry = null;
    private PostalAddress _postalAddress = null;
    private VerticalExtent _verticalExtent = null;
    private SecurityAttributes _securityAttributes = null;
    private static final String GEOSPATIAL_EXTENT_NAME = "GeospatialExtent";
    private static final String PRECEDENCE_NAME = "precedence";
    private static final String ORDER_NAME = "order";
    private static final List<String> VALID_PRECEDENCE_VALUES = new ArrayList<String>();

    public GeospatialCoverage(Element element) throws InvalidDDMSException {
        try {
            Util.requireDDMSValue("geographicIdentifier element", element);
            this.setXOMElement(element, false);
            Element element2 = this.getExtentElement();
            if (element2 != null) {
                Element element3;
                Element element4;
                Element element5;
                Element element6;
                DDMSVersion dDMSVersion = DDMSVersion.getVersionForNamespace(this.getNamespace());
                Element element7 = element2.getFirstChildElement(GeographicIdentifier.getName(dDMSVersion), this.getNamespace());
                if (element7 != null) {
                    this._geographicIdentifier = new GeographicIdentifier(element7);
                }
                if ((element6 = element2.getFirstChildElement(BoundingBox.getName(dDMSVersion), this.getNamespace())) != null) {
                    this._boundingBox = new BoundingBox(element6);
                }
                if ((element5 = element2.getFirstChildElement(BoundingGeometry.getName(dDMSVersion), this.getNamespace())) != null) {
                    this._boundingGeometry = new BoundingGeometry(element5);
                }
                if ((element4 = element2.getFirstChildElement(PostalAddress.getName(dDMSVersion), this.getNamespace())) != null) {
                    this._postalAddress = new PostalAddress(element4);
                }
                if ((element3 = element2.getFirstChildElement(VerticalExtent.getName(dDMSVersion), this.getNamespace())) != null) {
                    this._verticalExtent = new VerticalExtent(element3);
                }
            }
            this._securityAttributes = new SecurityAttributes(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public GeospatialCoverage(GeographicIdentifier geographicIdentifier, BoundingBox boundingBox, BoundingGeometry boundingGeometry, PostalAddress postalAddress, VerticalExtent verticalExtent, String string, Integer n, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        try {
            Element element;
            Element element2 = Util.buildDDMSElement(GeospatialCoverage.getName(DDMSVersion.getCurrentVersion()), null);
            Element element3 = element = DDMSVersion.getCurrentVersion().isAtLeast("4.0.1") ? element2 : Util.buildDDMSElement(GEOSPATIAL_EXTENT_NAME, null);
            if (geographicIdentifier != null) {
                element.appendChild((Node)geographicIdentifier.getXOMElementCopy());
            }
            if (boundingBox != null) {
                element.appendChild((Node)boundingBox.getXOMElementCopy());
            }
            if (boundingGeometry != null) {
                element.appendChild((Node)boundingGeometry.getXOMElementCopy());
            }
            if (postalAddress != null) {
                element.appendChild((Node)postalAddress.getXOMElementCopy());
            }
            if (verticalExtent != null) {
                element.appendChild((Node)verticalExtent.getXOMElementCopy());
            }
            Util.addDDMSAttribute(element2, PRECEDENCE_NAME, string);
            if (n != null) {
                Util.addDDMSAttribute(element2, ORDER_NAME, n.toString());
            }
            if (!DDMSVersion.getCurrentVersion().isAtLeast("4.0.1")) {
                element2.appendChild((Node)element);
            }
            this._geographicIdentifier = geographicIdentifier;
            this._boundingBox = boundingBox;
            this._boundingGeometry = boundingGeometry;
            this._postalAddress = postalAddress;
            this._verticalExtent = verticalExtent;
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element2);
            this.setXOMElement(element2, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), GeospatialCoverage.getName(this.getDDMSVersion()));
        Element element = this.getExtentElement();
        Util.requireDDMSValue("GeospatialExtent element", element);
        int n = 0;
        if (this.getGeographicIdentifier() != null) {
            ++n;
        }
        if (this.getBoundingBox() != null) {
            ++n;
        }
        if (this.getBoundingGeometry() != null) {
            ++n;
        }
        if (this.getPostalAddress() != null) {
            ++n;
        }
        if (this.getVerticalExtent() != null) {
            ++n;
        }
        if (n == 0) {
            throw new InvalidDDMSException("At least 1 of geographicIdentifier, boundingBox, boundingGeometry, postalAddress, or verticalExtent must be used.");
        }
        Util.requireBoundedChildCount(element, GeographicIdentifier.getName(this.getDDMSVersion()), 0, 1);
        Util.requireBoundedChildCount(element, BoundingBox.getName(this.getDDMSVersion()), 0, 1);
        Util.requireBoundedChildCount(element, BoundingGeometry.getName(this.getDDMSVersion()), 0, 1);
        Util.requireBoundedChildCount(element, PostalAddress.getName(this.getDDMSVersion()), 0, 1);
        Util.requireBoundedChildCount(element, VerticalExtent.getName(this.getDDMSVersion()), 0, 1);
        if (this.hasFacilityIdentifier() && n > 1) {
            throw new InvalidDDMSException("A geographicIdentifier containing a facilityIdentifier must not be used in tandem with any other coverage elements.");
        }
        if (!this.getDDMSVersion().isAtLeast("4.0.1")) {
            if (this.getOrder() != null) {
                throw new InvalidDDMSException("The ddms:order attribute must not be used until DDMS 4.0.1 or later.");
            }
            if (!Util.isEmpty(this.getPrecedence())) {
                throw new InvalidDDMSException("The ddms:precedence attribute must not be used until DDMS 4.0.1 or later.");
            }
        }
        if (!Util.isEmpty(this.getPrecedence())) {
            if (!VALID_PRECEDENCE_VALUES.contains(this.getPrecedence())) {
                throw new InvalidDDMSException("The ddms:precedence attribute must have a value from: " + VALID_PRECEDENCE_VALUES);
            }
            if (this.getGeographicIdentifier() == null || this.getGeographicIdentifier().getCountryCode() == null) {
                throw new InvalidDDMSException("The ddms:precedence attribute must only be applied to a geospatialCoverage containing a country code.");
            }
        }
        if (!this.getDDMSVersion().isAtLeast("3.0") && !this.getSecurityAttributes().isEmpty()) {
            throw new InvalidDDMSException("Security attributes must not be applied to this component until DDMS 3.0 or later.");
        }
        super.validate();
    }

    @Override
    protected String getLocatorSuffix() {
        return this.getDDMSVersion().isAtLeast("4.0.1") ? "" : "/" + this.getXOMElement().getNamespacePrefix() + ":" + GEOSPATIAL_EXTENT_NAME;
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        if (!this.getDDMSVersion().isAtLeast("4.0.1")) {
            string3 = string3 + "GeospatialExtent.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getGeographicIdentifier() != null) {
            stringBuffer.append(this.getGeographicIdentifier().getOutput(bl, string3, ""));
        }
        if (this.getBoundingBox() != null) {
            stringBuffer.append(this.getBoundingBox().getOutput(bl, string3, ""));
        }
        if (this.getBoundingGeometry() != null) {
            stringBuffer.append(this.getBoundingGeometry().getOutput(bl, string3, ""));
        }
        if (this.getPostalAddress() != null) {
            stringBuffer.append(this.getPostalAddress().getOutput(bl, string3, ""));
        }
        if (this.getVerticalExtent() != null) {
            stringBuffer.append(this.getVerticalExtent().getOutput(bl, string3, ""));
        }
        stringBuffer.append(GeospatialCoverage.buildOutput(bl, string3 + PRECEDENCE_NAME, this.getPrecedence()));
        if (this.getOrder() != null) {
            stringBuffer.append(GeospatialCoverage.buildOutput(bl, string3 + ORDER_NAME, String.valueOf(this.getOrder())));
        }
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.add(this.getBoundingBox());
        arrayList.add(this.getBoundingGeometry());
        arrayList.add(this.getGeographicIdentifier());
        arrayList.add(this.getPostalAddress());
        arrayList.add(this.getVerticalExtent());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof GeospatialCoverage)) {
            return false;
        }
        GeospatialCoverage geospatialCoverage = (GeospatialCoverage)object;
        return this.getPrecedence().equals(geospatialCoverage.getPrecedence()) && Util.nullEquals(this.getOrder(), geospatialCoverage.getOrder());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getPrecedence().hashCode();
        if (this.getOrder() != null) {
            n = 7 * n + this.getOrder().hashCode();
        }
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "geospatialCoverage";
    }

    private Element getExtentElement() {
        return this.getDDMSVersion().isAtLeast("4.0.1") ? this.getXOMElement() : this.getChild(GEOSPATIAL_EXTENT_NAME);
    }

    public String getPrecedence() {
        return this.getAttributeValue(PRECEDENCE_NAME);
    }

    public Integer getOrder() {
        String string = this.getAttributeValue(ORDER_NAME);
        return Util.isEmpty(string) ? null : Integer.valueOf(string);
    }

    public boolean hasFacilityIdentifier() {
        return this.getGeographicIdentifier() != null && this.getGeographicIdentifier().hasFacilityIdentifier();
    }

    public GeographicIdentifier getGeographicIdentifier() {
        return this._geographicIdentifier;
    }

    public BoundingBox getBoundingBox() {
        return this._boundingBox;
    }

    public BoundingGeometry getBoundingGeometry() {
        return this._boundingGeometry;
    }

    public PostalAddress getPostalAddress() {
        return this._postalAddress;
    }

    public VerticalExtent getVerticalExtent() {
        return this._verticalExtent;
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    static {
        VALID_PRECEDENCE_VALUES.add("Primary");
        VALID_PRECEDENCE_VALUES.add("Secondary");
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 2895705456552847432L;
        private BoundingBox.Builder _boundingBox;
        private BoundingGeometry.Builder _boundingGeometry;
        private GeographicIdentifier.Builder _geographicIdentifier;
        private PostalAddress.Builder _postalAddress;
        private VerticalExtent.Builder _verticalExtent;
        private String _precedence;
        private Integer _order;
        private SecurityAttributes.Builder _securityAttributes;

        public Builder() {
        }

        public Builder(GeospatialCoverage geospatialCoverage) {
            if (geospatialCoverage.getBoundingBox() != null) {
                this.setBoundingBox(new BoundingBox.Builder(geospatialCoverage.getBoundingBox()));
            }
            if (geospatialCoverage.getBoundingGeometry() != null) {
                this.setBoundingGeometry(new BoundingGeometry.Builder(geospatialCoverage.getBoundingGeometry()));
            }
            if (geospatialCoverage.getGeographicIdentifier() != null) {
                this.setGeographicIdentifier(new GeographicIdentifier.Builder(geospatialCoverage.getGeographicIdentifier()));
            }
            if (geospatialCoverage.getPostalAddress() != null) {
                this.setPostalAddress(new PostalAddress.Builder(geospatialCoverage.getPostalAddress()));
            }
            if (geospatialCoverage.getVerticalExtent() != null) {
                this.setVerticalExtent(new VerticalExtent.Builder(geospatialCoverage.getVerticalExtent()));
            }
            this.setPrecedence(geospatialCoverage.getPrecedence());
            this.setOrder(geospatialCoverage.getOrder());
            this.setSecurityAttributes(new SecurityAttributes.Builder(geospatialCoverage.getSecurityAttributes()));
        }

        @Override
        public GeospatialCoverage commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new GeospatialCoverage(this.getGeographicIdentifier().commit(), this.getBoundingBox().commit(), this.getBoundingGeometry().commit(), this.getPostalAddress().commit(), this.getVerticalExtent().commit(), this.getPrecedence(), this.getOrder(), this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            return this.getGeographicIdentifier().isEmpty() && this.getBoundingBox().isEmpty() && this.getBoundingGeometry().isEmpty() && this.getPostalAddress().isEmpty() && this.getVerticalExtent().isEmpty() && Util.isEmpty(this.getPrecedence()) && this.getOrder() == null && this.getSecurityAttributes().isEmpty();
        }

        public BoundingBox.Builder getBoundingBox() {
            if (this._boundingBox == null) {
                this._boundingBox = new BoundingBox.Builder();
            }
            return this._boundingBox;
        }

        public void setBoundingBox(BoundingBox.Builder builder) {
            this._boundingBox = builder;
        }

        public BoundingGeometry.Builder getBoundingGeometry() {
            if (this._boundingGeometry == null) {
                this._boundingGeometry = new BoundingGeometry.Builder();
            }
            return this._boundingGeometry;
        }

        public void setBoundingGeometry(BoundingGeometry.Builder builder) {
            this._boundingGeometry = builder;
        }

        public GeographicIdentifier.Builder getGeographicIdentifier() {
            if (this._geographicIdentifier == null) {
                this._geographicIdentifier = new GeographicIdentifier.Builder();
            }
            return this._geographicIdentifier;
        }

        public void setGeographicIdentifier(GeographicIdentifier.Builder builder) {
            this._geographicIdentifier = builder;
        }

        public PostalAddress.Builder getPostalAddress() {
            if (this._postalAddress == null) {
                this._postalAddress = new PostalAddress.Builder();
            }
            return this._postalAddress;
        }

        public void setPostalAddress(PostalAddress.Builder builder) {
            this._postalAddress = builder;
        }

        public VerticalExtent.Builder getVerticalExtent() {
            if (this._verticalExtent == null) {
                this._verticalExtent = new VerticalExtent.Builder();
            }
            return this._verticalExtent;
        }

        public void setVerticalExtent(VerticalExtent.Builder builder) {
            this._verticalExtent = builder;
        }

        public String getPrecedence() {
            return this._precedence;
        }

        public void setPrecedence(String string) {
            this._precedence = string;
        }

        public Integer getOrder() {
            return this._order;
        }

        public void setOrder(Integer n) {
            this._order = n;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

