/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import nu.xom.Element;

public final class FacilityIdentifier
extends AbstractBaseComponent {
    private static final String BE_NUMBER_NAME = "beNumber";
    private static final String OSUFFIX_NAME = "osuffix";

    public FacilityIdentifier(Element element) throws InvalidDDMSException {
        super(element);
    }

    public FacilityIdentifier(String string, String string2) throws InvalidDDMSException {
        try {
            Element element = Util.buildDDMSElement(FacilityIdentifier.getName(DDMSVersion.getCurrentVersion()), null);
            Util.addDDMSAttribute(element, BE_NUMBER_NAME, string);
            Util.addDDMSAttribute(element, OSUFFIX_NAME, string2);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), FacilityIdentifier.getName(this.getDDMSVersion()));
        Util.requireDDMSValue(BE_NUMBER_NAME, this.getBeNumber());
        Util.requireDDMSValue(OSUFFIX_NAME, this.getOsuffix());
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FacilityIdentifier.buildOutput(bl, string3 + BE_NUMBER_NAME, this.getBeNumber()));
        stringBuffer.append(FacilityIdentifier.buildOutput(bl, string3 + OSUFFIX_NAME, this.getOsuffix()));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof FacilityIdentifier)) {
            return false;
        }
        FacilityIdentifier facilityIdentifier = (FacilityIdentifier)object;
        return this.getBeNumber().equals(facilityIdentifier.getBeNumber()) && this.getOsuffix().equals(facilityIdentifier.getOsuffix());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getBeNumber().hashCode();
        n = 7 * n + this.getOsuffix().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "facilityIdentifier";
    }

    public String getBeNumber() {
        return this.getAttributeValue(BE_NUMBER_NAME);
    }

    public String getOsuffix() {
        return this.getAttributeValue(OSUFFIX_NAME);
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 4781523669271343048L;
        private String _beNumber;
        private String _osuffix;

        public Builder() {
        }

        public Builder(FacilityIdentifier facilityIdentifier) {
            this.setBeNumber(facilityIdentifier.getBeNumber());
            this.setOsuffix(facilityIdentifier.getOsuffix());
        }

        @Override
        public FacilityIdentifier commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new FacilityIdentifier(this.getBeNumber(), this.getOsuffix());
        }

        @Override
        public boolean isEmpty() {
            return Util.isEmpty(this.getBeNumber()) && Util.isEmpty(this.getOsuffix());
        }

        public String getBeNumber() {
            return this._beNumber;
        }

        public void setBeNumber(String string) {
            this._beNumber = string;
        }

        public String getOsuffix() {
            return this._osuffix;
        }

        public void setOsuffix(String string) {
            this._osuffix = string;
        }
    }
}

