/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.security.ntk;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.ddms.security.ntk.Profile;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public final class ProfileList
extends AbstractBaseComponent {
    private List<Profile> _profiles = null;
    private SecurityAttributes _securityAttributes = null;

    public ProfileList(Element element) throws InvalidDDMSException {
        try {
            this.setXOMElement(element, false);
            Elements elements = element.getChildElements(Profile.getName(this.getDDMSVersion()), this.getNamespace());
            this._profiles = new ArrayList<Profile>();
            for (int i = 0; i < elements.size(); ++i) {
                this._profiles.add(new Profile(elements.get(i)));
            }
            this._securityAttributes = new SecurityAttributes(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public ProfileList(List<Profile> list, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        try {
            DDMSVersion dDMSVersion = DDMSVersion.getCurrentVersion();
            Element element = Util.buildElement(PropertyReader.getPrefix("ntk"), ProfileList.getName(dDMSVersion), dDMSVersion.getNtkNamespace(), null);
            this.setXOMElement(element, false);
            if (list == null) {
                list = Collections.emptyList();
            }
            for (Profile profile : list) {
                this.getXOMElement().appendChild((Node)profile.getXOMElementCopy());
            }
            this._profiles = list;
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireQName(this.getXOMElement(), this.getNamespace(), ProfileList.getName(this.getDDMSVersion()));
        if (this.getProfiles().isEmpty()) {
            throw new InvalidDDMSException("At least one profile must exist.");
        }
        this.getSecurityAttributes().requireClassification();
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, "profileList", string2) + ".";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.buildOutput(bl, string3, this.getProfiles()));
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.addAll(this.getProfiles());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof ProfileList;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "AccessProfileList";
    }

    public List<Profile> getProfiles() {
        return Collections.unmodifiableList(this._profiles);
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 7851044806424206976L;
        private List<Profile.Builder> _profiles;
        private SecurityAttributes.Builder _securityAttributes;

        public Builder() {
        }

        public Builder(ProfileList profileList) {
            for (Profile profile : profileList.getProfiles()) {
                this.getProfiles().add(new Profile.Builder(profile));
            }
            this.setSecurityAttributes(new SecurityAttributes.Builder(profileList.getSecurityAttributes()));
        }

        @Override
        public ProfileList commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<Profile> arrayList = new ArrayList<Profile>();
            for (IBuilder iBuilder : this.getProfiles()) {
                Profile profile = (Profile)iBuilder.commit();
                if (profile == null) continue;
                arrayList.add(profile);
            }
            return new ProfileList(arrayList, this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (IBuilder iBuilder : this.getProfiles()) {
                bl = bl || !iBuilder.isEmpty();
            }
            return !bl && this.getSecurityAttributes().isEmpty();
        }

        public List<Profile.Builder> getProfiles() {
            if (this._profiles == null) {
                this._profiles = new LazyList(Profile.Builder.class);
            }
            return this._profiles;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

