/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.security;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.NoticeList;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.ddms.security.ntk.Access;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;

public final class Security
extends AbstractBaseComponent {
    private NoticeList _noticeList = null;
    private Access _access = null;
    private SecurityAttributes _securityAttributes = null;
    private static final String FIXED_ROLLUP = "true";
    public static final String EXCLUDE_FROM_ROLLUP_NAME = "excludeFromRollup";

    public Security(Element element) throws InvalidDDMSException {
        try {
            Element element2;
            this.setXOMElement(element, false);
            Element element3 = element.getFirstChildElement(NoticeList.getName(this.getDDMSVersion()), this.getNamespace());
            if (element3 != null) {
                this._noticeList = new NoticeList(element3);
            }
            if ((element2 = element.getFirstChildElement(Access.getName(this.getDDMSVersion()), this.getDDMSVersion().getNtkNamespace())) != null) {
                this._access = new Access(element2);
            }
            this._securityAttributes = new SecurityAttributes(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public Security(NoticeList noticeList, Access access, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        try {
            DDMSVersion dDMSVersion = DDMSVersion.getCurrentVersion();
            Element element = Util.buildDDMSElement(Security.getName(dDMSVersion), null);
            if (noticeList != null) {
                element.appendChild((Node)noticeList.getXOMElementCopy());
            }
            if (access != null) {
                element.appendChild((Node)access.getXOMElementCopy());
            }
            if (DDMSVersion.getCurrentVersion().isAtLeast("3.0")) {
                Util.addAttribute(element, PropertyReader.getPrefix("ism"), EXCLUDE_FROM_ROLLUP_NAME, DDMSVersion.getCurrentVersion().getIsmNamespace(), FIXED_ROLLUP);
            }
            this._noticeList = noticeList;
            this._access = access;
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            if (securityAttributes != null) {
                securityAttributes.addTo(element);
            }
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        this.requireAtMostVersion("4.1");
        Util.requireDDMSQName(this.getXOMElement(), Security.getName(this.getDDMSVersion()));
        if (this.getDDMSVersion().isAtLeast("3.0")) {
            if (this.getExcludeFromRollup() == null || !FIXED_ROLLUP.equals(String.valueOf(this.getExcludeFromRollup()))) {
                throw new InvalidDDMSException("The excludeFromRollup attribute must have a fixed value of \"true\".");
            }
        } else if (this.getExcludeFromRollup() != null) {
            throw new InvalidDDMSException("The excludeFromRollup attribute must not be used until DDMS 3.0 or later.");
        }
        this.getSecurityAttributes().requireClassification();
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getExcludeFromRollup() != null) {
            stringBuffer.append(Security.buildOutput(bl, string3 + EXCLUDE_FROM_ROLLUP_NAME, String.valueOf(this.getExcludeFromRollup())));
        }
        if (this.getNoticeList() != null) {
            stringBuffer.append(this.getNoticeList().getOutput(bl, string3, ""));
        }
        if (this.getAccess() != null) {
            stringBuffer.append(this.getAccess().getOutput(bl, string3, ""));
        }
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.add(this.getNoticeList());
        arrayList.add(this.getAccess());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof Security;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "security";
    }

    public Boolean getExcludeFromRollup() {
        String string = this.getAttributeValue(EXCLUDE_FROM_ROLLUP_NAME, DDMSVersion.getCurrentVersion().getIsmNamespace());
        if (FIXED_ROLLUP.equals(string)) {
            return Boolean.TRUE;
        }
        if ("false".equals(string)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public NoticeList getNoticeList() {
        return this._noticeList;
    }

    public Access getAccess() {
        return this._access;
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = -7744353774641616270L;
        private NoticeList.Builder _noticeList;
        private Access.Builder _access;
        private SecurityAttributes.Builder _securityAttributes;

        public Builder() {
        }

        public Builder(Security security) {
            if (security.getNoticeList() != null) {
                this.setNoticeList(new NoticeList.Builder(security.getNoticeList()));
            }
            if (security.getAccess() != null) {
                this.setAccess(new Access.Builder(security.getAccess()));
            }
            this.setSecurityAttributes(new SecurityAttributes.Builder(security.getSecurityAttributes()));
        }

        @Override
        public Security commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new Security(this.getNoticeList().commit(), this.getAccess().commit(), this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            return this.getNoticeList().isEmpty() && this.getAccess().isEmpty() && this.getSecurityAttributes().isEmpty();
        }

        public NoticeList.Builder getNoticeList() {
            if (this._noticeList == null) {
                this._noticeList = new NoticeList.Builder();
            }
            return this._noticeList;
        }

        public void setNoticeList(NoticeList.Builder builder) {
            this._noticeList = builder;
        }

        public Access.Builder getAccess() {
            if (this._access == null) {
                this._access = new Access.Builder();
            }
            return this._access;
        }

        public void setAccess(Access.Builder builder) {
            this._access = builder;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

