/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.security;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.Notice;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public final class NoticeList
extends AbstractBaseComponent {
    private List<Notice> _notices = null;
    private SecurityAttributes _securityAttributes = null;

    public NoticeList(Element element) throws InvalidDDMSException {
        try {
            this.setXOMElement(element, false);
            this._notices = new ArrayList<Notice>();
            Elements elements = element.getChildElements(Notice.getName(this.getDDMSVersion()), this.getDDMSVersion().getIsmNamespace());
            for (int i = 0; i < elements.size(); ++i) {
                this._notices.add(new Notice(elements.get(i)));
            }
            this._securityAttributes = new SecurityAttributes(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public NoticeList(List<Notice> list, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            DDMSVersion dDMSVersion = DDMSVersion.getCurrentVersion();
            Element element = Util.buildDDMSElement(NoticeList.getName(dDMSVersion), null);
            for (Notice notice : list) {
                element.appendChild((Node)notice.getXOMElementCopy());
            }
            this._notices = list;
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        this.requireAtLeastVersion("4.0.1");
        this.requireAtMostVersion("4.1");
        Util.requireDDMSQName(this.getXOMElement(), NoticeList.getName(this.getDDMSVersion()));
        if (this.getNotices().isEmpty()) {
            throw new InvalidDDMSException("At least one ism:Notice must exist within a ddms:noticeList element.");
        }
        this.getSecurityAttributes().requireClassification();
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.buildOutput(bl, string3, this.getNotices()));
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.addAll(this.getNotices());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof NoticeList;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "noticeList";
    }

    public List<Notice> getNotices() {
        return Collections.unmodifiableList(this._notices);
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 7750664735441105296L;
        private List<Notice.Builder> _notices;
        private SecurityAttributes.Builder _securityAttributes = null;

        public Builder() {
        }

        public Builder(NoticeList noticeList) {
            for (Notice notice : noticeList.getNotices()) {
                this.getNotices().add(new Notice.Builder(notice));
            }
            this.setSecurityAttributes(new SecurityAttributes.Builder(noticeList.getSecurityAttributes()));
        }

        @Override
        public NoticeList commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<Notice> arrayList = new ArrayList<Notice>();
            for (IBuilder iBuilder : this.getNotices()) {
                Notice notice = (Notice)iBuilder.commit();
                if (notice == null) continue;
                arrayList.add(notice);
            }
            return new NoticeList(arrayList, this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (IBuilder iBuilder : this.getNotices()) {
                bl = bl || !iBuilder.isEmpty();
            }
            return !bl && this.getSecurityAttributes().isEmpty();
        }

        public List<Notice.Builder> getNotices() {
            if (this._notices == null) {
                this._notices = new LazyList(Notice.Builder.class);
            }
            return this._notices;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

