/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.resource;

import buri.ddmsence.AbstractRoleEntity;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.extensible.ExtensibleAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;

public final class Unknown
extends AbstractRoleEntity {
    private List<String> _affiliations = null;
    private static final String AFFILIATION_NAME = "affiliation";

    public Unknown(Element element) throws InvalidDDMSException {
        super(element, true);
        this._affiliations = Util.getDDMSChildValues(element, AFFILIATION_NAME);
    }

    public Unknown(List<String> list, List<String> list2, List<String> list3) throws InvalidDDMSException {
        this(list, list2, list3, null, null);
    }

    public Unknown(List<String> list, List<String> list2, List<String> list3, List<String> list4, ExtensibleAttributes extensibleAttributes) throws InvalidDDMSException {
        super(Unknown.getName(DDMSVersion.getCurrentVersion()), list, list2, list3, extensibleAttributes);
        try {
            if (list4 == null) {
                list4 = Collections.emptyList();
            }
            Element element = this.getXOMElement();
            for (String string : list4) {
                element.appendChild((Node)Util.buildDDMSElement(AFFILIATION_NAME, string));
            }
            this._affiliations = list4;
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        this.requireAtLeastVersion("3.0");
        Util.requireDDMSQName(this.getXOMElement(), Unknown.getName(this.getDDMSVersion()));
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, "", string2);
        StringBuffer stringBuffer = new StringBuffer(super.getOutput(bl, string3, ""));
        stringBuffer.append(this.buildOutput(bl, string3 + AFFILIATION_NAME, this.getAffiliations()));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof Unknown)) {
            return false;
        }
        Unknown unknown = (Unknown)object;
        return Util.listEquals(this.getAffiliations(), unknown.getAffiliations());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getAffiliations().hashCode();
        return n;
    }

    public List<String> getAffiliations() {
        return Collections.unmodifiableList(this._affiliations);
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return dDMSVersion.isAtLeast("4.0.1") ? "unknown" : "Unknown";
    }

    public static class Builder
    extends AbstractRoleEntity.Builder {
        private static final long serialVersionUID = -2278534009019179572L;
        private List<String> _affiliations;

        public Builder() {
        }

        public Builder(Unknown unknown) {
            super(unknown);
            this.setAffiliations(unknown.getAffiliations());
        }

        @Override
        public Unknown commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new Unknown(this.getNames(), this.getPhones(), this.getEmails(), this.getAffiliations(), this.getExtensibleAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && Util.containsOnlyEmptyValues(this.getAffiliations());
        }

        public List<String> getAffiliations() {
            if (this._affiliations == null) {
                this._affiliations = new LazyList(String.class);
            }
            return this._affiliations;
        }

        public void setAffiliations(List<String> list) {
            this._affiliations = new LazyList(list, String.class);
        }
    }
}

