/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.resource;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.ApproximableDate;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public final class Dates
extends AbstractBaseComponent {
    private List<ApproximableDate> _acquiredOns = null;
    private static final String CREATED_NAME = "created";
    private static final String POSTED_NAME = "posted";
    private static final String VALID_TIL_NAME = "validTil";
    private static final String INFO_CUT_OFF_NAME = "infoCutOff";
    private static final String APPROVED_ON_NAME = "approvedOn";
    private static final String RECEIVED_ON_NAME = "receivedOn";
    private static final String ACQUIRED_ON_NAME = "acquiredOn";

    public Dates(Element element) throws InvalidDDMSException {
        try {
            this.setXOMElement(element, false);
            this._acquiredOns = new ArrayList<ApproximableDate>();
            Elements elements = element.getChildElements(ACQUIRED_ON_NAME, this.getNamespace());
            for (int i = 0; i < elements.size(); ++i) {
                this._acquiredOns.add(new ApproximableDate(elements.get(i)));
            }
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public Dates(String string, String string2, String string3, String string4, String string5, String string6) throws InvalidDDMSException {
        this(null, string, string2, string3, string4, string5, string6);
    }

    public Dates(List<ApproximableDate> list, String string, String string2, String string3, String string4, String string5, String string6) throws InvalidDDMSException {
        try {
            Element element = Util.buildDDMSElement(Dates.getName(DDMSVersion.getCurrentVersion()), null);
            if (list == null) {
                list = Collections.emptyList();
            }
            this._acquiredOns = list;
            for (ApproximableDate approximableDate : list) {
                element.appendChild((Node)approximableDate.getXOMElementCopy());
            }
            Util.addDDMSAttribute(element, CREATED_NAME, string);
            Util.addDDMSAttribute(element, POSTED_NAME, string2);
            Util.addDDMSAttribute(element, VALID_TIL_NAME, string3);
            Util.addDDMSAttribute(element, INFO_CUT_OFF_NAME, string4);
            Util.addDDMSAttribute(element, APPROVED_ON_NAME, string5);
            Util.addDDMSAttribute(element, RECEIVED_ON_NAME, string6);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), Dates.getName(this.getDDMSVersion()));
        if (!this.getDDMSVersion().isAtLeast("3.1") && !Util.isEmpty(this.getApprovedOnString())) {
            throw new InvalidDDMSException("This component must not have an approvedOn date until DDMS 3.1 or later.");
        }
        if (!this.getDDMSVersion().isAtLeast("4.0.1") && !Util.isEmpty(this.getReceivedOnString())) {
            throw new InvalidDDMSException("This component must not have a receivedOn date until DDMS 4.0.1 or later.");
        }
        if (!Util.isEmpty(this.getCreatedString())) {
            Util.requireDDMSDateFormat(this.getCreatedString(), this.getNamespace());
        }
        if (!Util.isEmpty(this.getPostedString())) {
            Util.requireDDMSDateFormat(this.getPostedString(), this.getNamespace());
        }
        if (!Util.isEmpty(this.getValidTilString())) {
            Util.requireDDMSDateFormat(this.getValidTilString(), this.getNamespace());
        }
        if (!Util.isEmpty(this.getInfoCutOffString())) {
            Util.requireDDMSDateFormat(this.getInfoCutOffString(), this.getNamespace());
        }
        if (!Util.isEmpty(this.getApprovedOnString())) {
            Util.requireDDMSDateFormat(this.getApprovedOnString(), this.getNamespace());
        }
        if (!Util.isEmpty(this.getReceivedOnString())) {
            Util.requireDDMSDateFormat(this.getReceivedOnString(), this.getNamespace());
        }
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (Util.isEmpty(this.getCreatedString()) && Util.isEmpty(this.getPostedString()) && Util.isEmpty(this.getValidTilString()) && Util.isEmpty(this.getInfoCutOffString()) && Util.isEmpty(this.getApprovedOnString()) && Util.isEmpty(this.getReceivedOnString()) && this.getAcquiredOns().isEmpty()) {
            this.addWarning("A completely empty ddms:dates element was found.");
        }
        if ("4.1".equals(this.getDDMSVersion().getVersion()) && !this.getAcquiredOns().isEmpty()) {
            this.addDdms40Warning("ddms:acquiredOn element");
        }
        super.validateWarnings();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.buildOutput(bl, string3, this.getAcquiredOns()));
        stringBuffer.append(Dates.buildOutput(bl, string3 + CREATED_NAME, this.getCreatedString()));
        stringBuffer.append(Dates.buildOutput(bl, string3 + POSTED_NAME, this.getPostedString()));
        stringBuffer.append(Dates.buildOutput(bl, string3 + VALID_TIL_NAME, this.getValidTilString()));
        stringBuffer.append(Dates.buildOutput(bl, string3 + INFO_CUT_OFF_NAME, this.getInfoCutOffString()));
        stringBuffer.append(Dates.buildOutput(bl, string3 + APPROVED_ON_NAME, this.getApprovedOnString()));
        stringBuffer.append(Dates.buildOutput(bl, string3 + RECEIVED_ON_NAME, this.getReceivedOnString()));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.addAll(this.getAcquiredOns());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof Dates)) {
            return false;
        }
        Dates dates = (Dates)object;
        return this.getCreatedString().equals(dates.getCreatedString()) && this.getPostedString().equals(dates.getPostedString()) && this.getValidTilString().equals(dates.getValidTilString()) && this.getInfoCutOffString().equals(dates.getInfoCutOffString()) && this.getApprovedOnString().equals(dates.getApprovedOnString()) && this.getReceivedOnString().equals(dates.getReceivedOnString());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getCreatedString().hashCode();
        n = 7 * n + this.getPostedString().hashCode();
        n = 7 * n + this.getValidTilString().hashCode();
        n = 7 * n + this.getInfoCutOffString().hashCode();
        n = 7 * n + this.getApprovedOnString().hashCode();
        n = 7 * n + this.getReceivedOnString().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "dates";
    }

    public XMLGregorianCalendar getCreated() {
        try {
            return Dates.getFactory().newXMLGregorianCalendar(this.getCreatedString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String getCreatedString() {
        return this.getAttributeValue(CREATED_NAME);
    }

    public XMLGregorianCalendar getPosted() {
        try {
            return Dates.getFactory().newXMLGregorianCalendar(this.getPostedString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String getPostedString() {
        return this.getAttributeValue(POSTED_NAME);
    }

    public XMLGregorianCalendar getValidTil() {
        try {
            return Dates.getFactory().newXMLGregorianCalendar(this.getValidTilString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String getValidTilString() {
        return this.getAttributeValue(VALID_TIL_NAME);
    }

    public XMLGregorianCalendar getInfoCutOff() {
        try {
            return Dates.getFactory().newXMLGregorianCalendar(this.getInfoCutOffString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String getInfoCutOffString() {
        return this.getAttributeValue(INFO_CUT_OFF_NAME);
    }

    public XMLGregorianCalendar getApprovedOn() {
        try {
            return Dates.getFactory().newXMLGregorianCalendar(this.getApprovedOnString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String getApprovedOnString() {
        return this.getAttributeValue(APPROVED_ON_NAME);
    }

    public XMLGregorianCalendar getReceivedOn() {
        try {
            return Dates.getFactory().newXMLGregorianCalendar(this.getReceivedOnString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String getReceivedOnString() {
        return this.getAttributeValue(RECEIVED_ON_NAME);
    }

    public List<ApproximableDate> getAcquiredOns() {
        return Collections.unmodifiableList(this._acquiredOns);
    }

    private static DatatypeFactory getFactory() {
        return Util.getDataTypeFactory();
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = -2857638896738260719L;
        private List<ApproximableDate.Builder> _acquiredOns;
        private String _created;
        private String _posted;
        private String _validTil;
        private String _infoCutOff;
        private String _approvedOn;
        private String _receivedOn;

        public Builder() {
        }

        public Builder(Dates dates) {
            for (ApproximableDate approximableDate : dates.getAcquiredOns()) {
                this.getAcquiredOns().add(new ApproximableDate.Builder(approximableDate));
            }
            this.setCreated(dates.getCreatedString());
            this.setPosted(dates.getPostedString());
            this.setValidTil(dates.getValidTilString());
            this.setInfoCutOff(dates.getInfoCutOffString());
            this.setApprovedOn(dates.getApprovedOnString());
            this.setReceivedOn(dates.getReceivedOnString());
        }

        @Override
        public Dates commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<ApproximableDate> arrayList = new ArrayList<ApproximableDate>();
            for (IBuilder iBuilder : this.getAcquiredOns()) {
                ApproximableDate approximableDate = (ApproximableDate)iBuilder.commit();
                if (approximableDate == null) continue;
                arrayList.add(approximableDate);
            }
            return new Dates(arrayList, this.getCreated(), this.getPosted(), this.getValidTil(), this.getInfoCutOff(), this.getApprovedOn(), this.getReceivedOn());
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (IBuilder iBuilder : this.getAcquiredOns()) {
                bl = bl || !iBuilder.isEmpty();
            }
            return !bl && Util.isEmpty(this.getCreated()) && Util.isEmpty(this.getPosted()) && Util.isEmpty(this.getValidTil()) && Util.isEmpty(this.getInfoCutOff()) && Util.isEmpty(this.getApprovedOn()) && Util.isEmpty(this.getReceivedOn());
        }

        public List<ApproximableDate.Builder> getAcquiredOns() {
            if (this._acquiredOns == null) {
                this._acquiredOns = new LazyList(ApproximableDate.Builder.class);
            }
            return this._acquiredOns;
        }

        public String getCreated() {
            return this._created;
        }

        public void setCreated(String string) {
            this._created = string;
        }

        public String getPosted() {
            return this._posted;
        }

        public void setPosted(String string) {
            this._posted = string;
        }

        public String getValidTil() {
            return this._validTil;
        }

        public void setValidTil(String string) {
            this._validTil = string;
        }

        public String getInfoCutOff() {
            return this._infoCutOff;
        }

        public void setInfoCutOff(String string) {
            this._infoCutOff = string;
        }

        public String getApprovedOn() {
            return this._approvedOn;
        }

        public void setApprovedOn(String string) {
            this._approvedOn = string;
        }

        public String getReceivedOn() {
            return this._receivedOn;
        }

        public void setReceivedOn(String string) {
            this._receivedOn = string;
        }
    }
}

