/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.metacard;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.resource.Contributor;
import buri.ddmsence.ddms.resource.Creator;
import buri.ddmsence.ddms.resource.Dates;
import buri.ddmsence.ddms.resource.Identifier;
import buri.ddmsence.ddms.resource.PointOfContact;
import buri.ddmsence.ddms.resource.ProcessingInfo;
import buri.ddmsence.ddms.resource.Publisher;
import buri.ddmsence.ddms.resource.RecordsManagementInfo;
import buri.ddmsence.ddms.resource.RevisionRecall;
import buri.ddmsence.ddms.security.NoticeList;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.ddms.security.ntk.Access;
import buri.ddmsence.ddms.summary.Description;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public final class MetacardInfo
extends AbstractBaseComponent {
    private List<Identifier> _identifiers = new ArrayList<Identifier>();
    private Dates _dates = null;
    private List<Contributor> _contributors = new ArrayList<Contributor>();
    private List<Creator> _creators = new ArrayList<Creator>();
    private List<PointOfContact> _pointOfContacts = new ArrayList<PointOfContact>();
    private List<Publisher> _publishers = new ArrayList<Publisher>();
    private Description _description = null;
    private List<ProcessingInfo> _processingInfos = new ArrayList<ProcessingInfo>();
    private RevisionRecall _revisionRecall = null;
    private RecordsManagementInfo _recordsManagementInfo = null;
    private NoticeList _noticeList = null;
    private Access _access = null;
    private SecurityAttributes _securityAttributes = null;
    private List<IDDMSComponent> _orderedList = new ArrayList<IDDMSComponent>();

    public MetacardInfo(Element element) throws InvalidDDMSException {
        try {
            int n;
            this.setXOMElement(element, false);
            DDMSVersion dDMSVersion = this.getDDMSVersion();
            this._identifiers = new ArrayList<Identifier>();
            Elements elements = element.getChildElements(Identifier.getName(dDMSVersion), this.getNamespace());
            for (int i = 0; i < elements.size(); ++i) {
                this._identifiers.add(new Identifier(elements.get(i)));
            }
            Element element2 = element.getFirstChildElement(Dates.getName(dDMSVersion), this.getNamespace());
            if (element2 != null) {
                this._dates = new Dates(element2);
            }
            elements = element.getChildElements(Creator.getName(dDMSVersion), this.getNamespace());
            for (n = 0; n < elements.size(); ++n) {
                this._creators.add(new Creator(elements.get(n)));
            }
            elements = element.getChildElements(Publisher.getName(dDMSVersion), this.getNamespace());
            for (n = 0; n < elements.size(); ++n) {
                this._publishers.add(new Publisher(elements.get(n)));
            }
            elements = element.getChildElements(Contributor.getName(dDMSVersion), this.getNamespace());
            for (n = 0; n < elements.size(); ++n) {
                this._contributors.add(new Contributor(elements.get(n)));
            }
            elements = element.getChildElements(PointOfContact.getName(dDMSVersion), this.getNamespace());
            for (n = 0; n < elements.size(); ++n) {
                this._pointOfContacts.add(new PointOfContact(elements.get(n)));
            }
            element2 = element.getFirstChildElement(Description.getName(dDMSVersion), this.getNamespace());
            if (element2 != null) {
                this._description = new Description(element2);
            }
            elements = element.getChildElements(ProcessingInfo.getName(dDMSVersion), this.getNamespace());
            for (n = 0; n < elements.size(); ++n) {
                this._processingInfos.add(new ProcessingInfo(elements.get(n)));
            }
            element2 = element.getFirstChildElement(RevisionRecall.getName(this.getDDMSVersion()), this.getNamespace());
            if (element2 != null) {
                this._revisionRecall = new RevisionRecall(element2);
            }
            if ((element2 = element.getFirstChildElement(RecordsManagementInfo.getName(this.getDDMSVersion()), this.getNamespace())) != null) {
                this._recordsManagementInfo = new RecordsManagementInfo(element2);
            }
            if ((element2 = element.getFirstChildElement(NoticeList.getName(this.getDDMSVersion()), this.getNamespace())) != null) {
                this._noticeList = new NoticeList(element2);
            }
            if ((element2 = element.getFirstChildElement(Access.getName(this.getDDMSVersion()), this.getDDMSVersion().getNtkNamespace())) != null) {
                this._access = new Access(element2);
            }
            this._securityAttributes = new SecurityAttributes(element);
            this.populatedOrderedList();
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public MetacardInfo(List<IDDMSComponent> list, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            Element element = Util.buildDDMSElement(MetacardInfo.getName(DDMSVersion.getCurrentVersion()), null);
            this.setXOMElement(element, false);
            for (IDDMSComponent iDDMSComponent : list) {
                if (iDDMSComponent == null) continue;
                if (iDDMSComponent instanceof Identifier) {
                    this._identifiers.add((Identifier)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof Dates) {
                    this._dates = (Dates)iDDMSComponent;
                    continue;
                }
                if (iDDMSComponent instanceof Contributor) {
                    this._contributors.add((Contributor)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof Creator) {
                    this._creators.add((Creator)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof PointOfContact) {
                    this._pointOfContacts.add((PointOfContact)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof Publisher) {
                    this._publishers.add((Publisher)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof Description) {
                    this._description = (Description)iDDMSComponent;
                    continue;
                }
                if (iDDMSComponent instanceof ProcessingInfo) {
                    this._processingInfos.add((ProcessingInfo)iDDMSComponent);
                    continue;
                }
                if (iDDMSComponent instanceof RevisionRecall) {
                    this._revisionRecall = (RevisionRecall)iDDMSComponent;
                    continue;
                }
                if (iDDMSComponent instanceof RecordsManagementInfo) {
                    this._recordsManagementInfo = (RecordsManagementInfo)iDDMSComponent;
                    continue;
                }
                if (iDDMSComponent instanceof NoticeList) {
                    this._noticeList = (NoticeList)iDDMSComponent;
                    continue;
                }
                if (iDDMSComponent instanceof Access) {
                    this._access = (Access)iDDMSComponent;
                    continue;
                }
                throw new InvalidDDMSException(iDDMSComponent.getName() + " is not a valid child component in a metacardInfo element.");
            }
            this.populatedOrderedList();
            for (IDDMSComponent iDDMSComponent : this.getNestedComponents()) {
                element.appendChild((Node)iDDMSComponent.getXOMElementCopy());
            }
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    private void populatedOrderedList() {
        this._orderedList.addAll(this.getIdentifiers());
        if (this.getDates() != null) {
            this._orderedList.add(this.getDates());
        }
        this._orderedList.addAll(this.getPublishers());
        this._orderedList.addAll(this.getContributors());
        this._orderedList.addAll(this.getCreators());
        this._orderedList.addAll(this.getPointOfContacts());
        if (this.getDescription() != null) {
            this._orderedList.add(this.getDescription());
        }
        this._orderedList.addAll(this.getProcessingInfos());
        if (this.getRevisionRecall() != null) {
            this._orderedList.add(this.getRevisionRecall());
        }
        if (this.getRecordsManagementInfo() != null) {
            this._orderedList.add(this.getRecordsManagementInfo());
        }
        if (this.getNoticeList() != null) {
            this._orderedList.add(this.getNoticeList());
        }
        if (this.getAccess() != null) {
            this._orderedList.add(this.getAccess());
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        this.requireAtLeastVersion("4.0.1");
        Util.requireDDMSQName(this.getXOMElement(), MetacardInfo.getName(this.getDDMSVersion()));
        if (this.getIdentifiers().isEmpty()) {
            throw new InvalidDDMSException("At least one ddms:identifier must exist within a ddms:metacardInfo element.");
        }
        Util.requireBoundedChildCount(this.getXOMElement(), Dates.getName(this.getDDMSVersion()), 1, 1);
        if (!this.getDDMSVersion().isAtLeast("5.0")) {
            if (this.getPublishers().isEmpty()) {
                throw new InvalidDDMSException("At least one ddms:publisher must exist within a ddms:metacardInfo element.");
            }
        } else {
            if (this.getContributors().isEmpty() && this.getCreators().isEmpty() && this.getPointOfContacts().isEmpty() && this.getPublishers().isEmpty()) {
                throw new InvalidDDMSException("At least one producer must exist within a ddms:metacardInfo element.");
            }
            if (this.getAccess() != null) {
                throw new InvalidDDMSException("The ntk:Access element must not be used after DDMS 4.1.");
            }
        }
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (!this.getDDMSVersion().isAtLeast("5.0") && this.getAccess() != null) {
            this.addDdms40Warning("ntk:Access element");
        }
        super.validateWarnings();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.buildOutput(bl, string3, this.getIdentifiers()));
        if (this.getDates() != null) {
            stringBuffer.append(this.getDates().getOutput(bl, string3, ""));
        }
        stringBuffer.append(this.buildOutput(bl, string3, this.getPublishers()));
        stringBuffer.append(this.buildOutput(bl, string3, this.getContributors()));
        stringBuffer.append(this.buildOutput(bl, string3, this.getCreators()));
        stringBuffer.append(this.buildOutput(bl, string3, this.getPointOfContacts()));
        if (this.getDescription() != null) {
            stringBuffer.append(this.getDescription().getOutput(bl, string3, ""));
        }
        stringBuffer.append(this.buildOutput(bl, string3, this.getProcessingInfos()));
        if (this.getRevisionRecall() != null) {
            stringBuffer.append(this.getRevisionRecall().getOutput(bl, string3, ""));
        }
        if (this.getRecordsManagementInfo() != null) {
            stringBuffer.append(this.getRecordsManagementInfo().getOutput(bl, string3, ""));
        }
        if (this.getNoticeList() != null) {
            stringBuffer.append(this.getNoticeList().getOutput(bl, string3, ""));
        }
        if (this.getAccess() != null) {
            stringBuffer.append(this.getAccess().getOutput(bl, string3, ""));
        }
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        return this.getChildComponents();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof MetacardInfo;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "metacardInfo";
    }

    public List<IDDMSComponent> getChildComponents() {
        return Collections.unmodifiableList(this._orderedList);
    }

    public List<Identifier> getIdentifiers() {
        return Collections.unmodifiableList(this._identifiers);
    }

    public Dates getDates() {
        return this._dates;
    }

    public List<Contributor> getContributors() {
        return Collections.unmodifiableList(this._contributors);
    }

    public List<Creator> getCreators() {
        return Collections.unmodifiableList(this._creators);
    }

    public List<PointOfContact> getPointOfContacts() {
        return Collections.unmodifiableList(this._pointOfContacts);
    }

    public List<Publisher> getPublishers() {
        return Collections.unmodifiableList(this._publishers);
    }

    public Description getDescription() {
        return this._description;
    }

    public List<ProcessingInfo> getProcessingInfos() {
        return Collections.unmodifiableList(this._processingInfos);
    }

    public RevisionRecall getRevisionRecall() {
        return this._revisionRecall;
    }

    public RecordsManagementInfo getRecordsManagementInfo() {
        return this._recordsManagementInfo;
    }

    public NoticeList getNoticeList() {
        return this._noticeList;
    }

    public Access getAccess() {
        return this._access;
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 7851044806424206976L;
        private List<Identifier.Builder> _identifiers;
        private Dates.Builder _dates;
        private List<Contributor.Builder> _contributors;
        private List<Creator.Builder> _creators;
        private List<PointOfContact.Builder> _pointOfContacts;
        private List<Publisher.Builder> _publishers;
        private Description.Builder _description;
        private List<ProcessingInfo.Builder> _processingInfos;
        private RevisionRecall.Builder _revisionRecall;
        private RecordsManagementInfo.Builder _recordsManagementInfo;
        private NoticeList.Builder _noticeList;
        private Access.Builder _access;
        private SecurityAttributes.Builder _securityAttributes;

        public Builder() {
        }

        public Builder(MetacardInfo metacardInfo) {
            for (IDDMSComponent iDDMSComponent : metacardInfo.getChildComponents()) {
                if (iDDMSComponent instanceof Identifier) {
                    this.getIdentifiers().add(new Identifier.Builder((Identifier)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof Dates) {
                    this.setDates(new Dates.Builder((Dates)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof Creator) {
                    this.getCreators().add(new Creator.Builder((Creator)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof Contributor) {
                    this.getContributors().add(new Contributor.Builder((Contributor)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof Publisher) {
                    this.getPublishers().add(new Publisher.Builder((Publisher)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof PointOfContact) {
                    this.getPointOfContacts().add(new PointOfContact.Builder((PointOfContact)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof Description) {
                    this.setDescription(new Description.Builder((Description)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof ProcessingInfo) {
                    this.getProcessingInfos().add(new ProcessingInfo.Builder((ProcessingInfo)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof RevisionRecall) {
                    this.setRevisionRecall(new RevisionRecall.Builder((RevisionRecall)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof RecordsManagementInfo) {
                    this.setRecordsManagementInfo(new RecordsManagementInfo.Builder((RecordsManagementInfo)iDDMSComponent));
                    continue;
                }
                if (iDDMSComponent instanceof NoticeList) {
                    this.setNoticeList(new NoticeList.Builder((NoticeList)iDDMSComponent));
                    continue;
                }
                if (!(iDDMSComponent instanceof Access)) continue;
                this.setAccess(new Access.Builder((Access)iDDMSComponent));
            }
            this.setSecurityAttributes(new SecurityAttributes.Builder(metacardInfo.getSecurityAttributes()));
        }

        @Override
        public MetacardInfo commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
            for (IBuilder iBuilder : this.getChildBuilders()) {
                IDDMSComponent iDDMSComponent = iBuilder.commit();
                if (iDDMSComponent == null) continue;
                arrayList.add(iDDMSComponent);
            }
            return new MetacardInfo(arrayList, this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (IBuilder iBuilder : this.getChildBuilders()) {
                bl = bl || !iBuilder.isEmpty();
            }
            return !bl && this.getSecurityAttributes().isEmpty();
        }

        private List<IBuilder> getChildBuilders() {
            ArrayList<IBuilder> arrayList = new ArrayList<IBuilder>();
            arrayList.addAll(this.getIdentifiers());
            arrayList.addAll(this.getPublishers());
            arrayList.addAll(this.getContributors());
            arrayList.addAll(this.getCreators());
            arrayList.addAll(this.getPointOfContacts());
            arrayList.addAll(this.getProcessingInfos());
            arrayList.add(this.getDates());
            arrayList.add(this.getDescription());
            arrayList.add(this.getRevisionRecall());
            arrayList.add(this.getRecordsManagementInfo());
            arrayList.add(this.getNoticeList());
            arrayList.add(this.getAccess());
            return arrayList;
        }

        public List<Identifier.Builder> getIdentifiers() {
            if (this._identifiers == null) {
                this._identifiers = new LazyList(Identifier.Builder.class);
            }
            return this._identifiers;
        }

        public Dates.Builder getDates() {
            if (this._dates == null) {
                this._dates = new Dates.Builder();
            }
            return this._dates;
        }

        public void setDates(Dates.Builder builder) {
            this._dates = builder;
        }

        public List<Creator.Builder> getCreators() {
            if (this._creators == null) {
                this._creators = new LazyList(Creator.Builder.class);
            }
            return this._creators;
        }

        public List<Contributor.Builder> getContributors() {
            if (this._contributors == null) {
                this._contributors = new LazyList(Contributor.Builder.class);
            }
            return this._contributors;
        }

        public List<Publisher.Builder> getPublishers() {
            if (this._publishers == null) {
                this._publishers = new LazyList(Publisher.Builder.class);
            }
            return this._publishers;
        }

        public List<PointOfContact.Builder> getPointOfContacts() {
            if (this._pointOfContacts == null) {
                this._pointOfContacts = new LazyList(PointOfContact.Builder.class);
            }
            return this._pointOfContacts;
        }

        public Description.Builder getDescription() {
            if (this._description == null) {
                this._description = new Description.Builder();
            }
            return this._description;
        }

        public void setDescription(Description.Builder builder) {
            this._description = builder;
        }

        public List<ProcessingInfo.Builder> getProcessingInfos() {
            if (this._processingInfos == null) {
                this._processingInfos = new LazyList(ProcessingInfo.Builder.class);
            }
            return this._processingInfos;
        }

        public RevisionRecall.Builder getRevisionRecall() {
            if (this._revisionRecall == null) {
                this._revisionRecall = new RevisionRecall.Builder();
            }
            return this._revisionRecall;
        }

        public void setRevisionRecall(RevisionRecall.Builder builder) {
            this._revisionRecall = builder;
        }

        public RecordsManagementInfo.Builder getRecordsManagementInfo() {
            if (this._recordsManagementInfo == null) {
                this._recordsManagementInfo = new RecordsManagementInfo.Builder();
            }
            return this._recordsManagementInfo;
        }

        public void setRecordsManagementInfo(RecordsManagementInfo.Builder builder) {
            this._recordsManagementInfo = builder;
        }

        public NoticeList.Builder getNoticeList() {
            if (this._noticeList == null) {
                this._noticeList = new NoticeList.Builder();
            }
            return this._noticeList;
        }

        public void setNoticeList(NoticeList.Builder builder) {
            this._noticeList = builder;
        }

        public Access.Builder getAccess() {
            if (this._access == null) {
                this._access = new Access.Builder();
            }
            return this._access;
        }

        public void setAccess(Access.Builder builder) {
            this._access = builder;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

