/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.extensible;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import nu.xom.Element;

public final class ExtensibleElement
extends AbstractBaseComponent {
    public ExtensibleElement(Element element) throws InvalidDDMSException {
        super(element);
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        if (DDMSVersion.isSupportedDDMSNamespace(this.getNamespace())) {
            throw new InvalidDDMSException("Extensible elements must not be defined in the DDMS namespace.");
        }
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        return "";
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof ExtensibleElement)) {
            return false;
        }
        ExtensibleElement extensibleElement = (ExtensibleElement)object;
        return this.getXOMElement().toXML().equals(extensibleElement.getXOMElement().toXML());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getXOMElement().toXML().hashCode();
        return n;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 7276942157278555643L;
        private String _xml;

        public Builder() {
        }

        public Builder(ExtensibleElement extensibleElement) {
            this.setXml(extensibleElement.toXML());
        }

        @Override
        public ExtensibleElement commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            return new ExtensibleElement(Util.commitXml(this.getXml()));
        }

        @Override
        public boolean isEmpty() {
            return Util.isEmpty(this.getXml());
        }

        public String getXml() {
            return this._xml;
        }

        public void setXml(String string) {
            this._xml = string;
        }
    }
}

