/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import nu.xom.Element;

public abstract class AbstractNtkString
extends AbstractBaseComponent {
    private boolean _tokenBased = false;
    private SecurityAttributes _securityAttributes = null;
    private static final String ID_NAME = "id";
    private static final String ID_REFERENCE_NAME = "IDReference";
    private static final String QUALIFIER_NAME = "qualifier";

    protected AbstractNtkString(boolean bl, Element element) throws InvalidDDMSException {
        try {
            this.setXOMElement(element, false);
            this._tokenBased = bl;
            this._securityAttributes = new SecurityAttributes(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    protected AbstractNtkString(boolean bl, String string, String string2, String string3, String string4, String string5, SecurityAttributes securityAttributes, boolean bl2) throws InvalidDDMSException {
        try {
            String string6 = PropertyReader.getPrefix("ntk");
            String string7 = DDMSVersion.getCurrentVersion().getNtkNamespace();
            Element element = Util.buildElement(string6, string, string7, string2);
            Util.addAttribute(element, string6, ID_NAME, string7, string3);
            Util.addAttribute(element, string6, ID_REFERENCE_NAME, string7, string4);
            Util.addAttribute(element, string6, QUALIFIER_NAME, string7, string5);
            this._tokenBased = bl;
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this.setXOMElement(element, bl2);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        this.requireAtLeastVersion("4.0.1");
        if (this.isTokenBased()) {
            Util.requireValidNMToken(this.getValue());
        }
        this.getSecurityAttributes().requireClassification();
        super.validate();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        AbstractNtkString abstractNtkString = (AbstractNtkString)object;
        return this.getValue().equals(abstractNtkString.getValue()) && this.getID().equals(abstractNtkString.getID()) && this.getIDReference().equals(abstractNtkString.getIDReference()) && this.getQualifier().equals(abstractNtkString.getQualifier());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getValue().hashCode();
        n = 7 * n + this.getID().hashCode();
        n = 7 * n + this.getIDReference().hashCode();
        n = 7 * n + this.getQualifier().hashCode();
        return n;
    }

    public String getValue() {
        return this.getXOMElement().getValue();
    }

    public String getID() {
        return this.getAttributeValue(ID_NAME, this.getDDMSVersion().getNtkNamespace());
    }

    public String getIDReference() {
        return this.getAttributeValue(ID_REFERENCE_NAME, this.getDDMSVersion().getNtkNamespace());
    }

    public String getQualifier() {
        return this.getAttributeValue(QUALIFIER_NAME, this.getDDMSVersion().getNtkNamespace());
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    private boolean isTokenBased() {
        return this._tokenBased;
    }

    public static abstract class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 7824644958681123708L;
        private String _value;
        private String _id;
        private String _idReference;
        private String _qualifier;
        private SecurityAttributes.Builder _securityAttributes;

        protected Builder() {
        }

        protected Builder(AbstractNtkString abstractNtkString) {
            this.setValue(abstractNtkString.getValue());
            this.setID(abstractNtkString.getID());
            this.setIDReference(abstractNtkString.getIDReference());
            this.setQualifier(abstractNtkString.getQualifier());
            this.setSecurityAttributes(new SecurityAttributes.Builder(abstractNtkString.getSecurityAttributes()));
        }

        @Override
        public boolean isEmpty() {
            return Util.isEmpty(this.getValue()) && Util.isEmpty(this.getID()) && Util.isEmpty(this.getIDReference()) && Util.isEmpty(this.getQualifier()) && this.getSecurityAttributes().isEmpty();
        }

        public String getValue() {
            return this._value;
        }

        public void setValue(String string) {
            this._value = string;
        }

        public String getID() {
            return this._id;
        }

        public void setID(String string) {
            this._id = string;
        }

        public String getIDReference() {
            return this._idReference;
        }

        public void setIDReference(String string) {
            this._idReference = string;
        }

        public String getQualifier() {
            return this._qualifier;
        }

        public void setQualifier(String string) {
            this._qualifier = string;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

