/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.util;

import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.Resource;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DDMSReader {
    private XMLReader _reader = XMLReaderFactory.createXMLReader(PropertyReader.getProperty("xml.reader.class"));
    private static final String PROP_XERCES_VALIDATION = "http://xml.org/sax/features/validation";
    private static final String PROP_XERCES_SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    private static final String PROP_XERCES_EXTERNAL_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";

    public DDMSReader() throws SAXException {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>(DDMSVersion.getSupportedVersions());
        Collections.reverse(arrayList);
        HashSet hashSet = new HashSet();
        for (String string : arrayList) {
            DDMSVersion dDMSVersion = DDMSVersion.getVersionFor(string);
            this.loadSchema(dDMSVersion.getNamespace(), dDMSVersion.getSchema(), stringBuffer, hashSet);
            this.loadSchema(dDMSVersion.getGmlNamespace(), dDMSVersion.getGmlSchema(), stringBuffer, hashSet);
            this.loadSchema(dDMSVersion.getNtkNamespace(), dDMSVersion.getNtkSchema(), stringBuffer, hashSet);
        }
        this.getReader().setFeature(PROP_XERCES_VALIDATION, true);
        this.getReader().setFeature(PROP_XERCES_SCHEMA_VALIDATION, true);
        this.getReader().setProperty(PROP_XERCES_EXTERNAL_LOCATION, stringBuffer.toString().trim());
    }

    private void loadSchema(String string, String string2, StringBuffer stringBuffer, Set set) {
        if (!set.contains(string)) {
            if (!Util.isEmpty(string2)) {
                String string3 = this.getLocalSchemaLocation(string2);
                stringBuffer.append(string).append(" ").append(string3).append(" ");
            }
            set.add(string);
        }
    }

    private String getLocalSchemaLocation(String string) {
        URL uRL = this.getClass().getResource(string);
        if (uRL == null) {
            throw new IllegalArgumentException("Unable to load a local copy of the schema for validation.");
        }
        String string2 = uRL.toExternalForm().replaceAll(" ", "%20");
        return string2;
    }

    public static void validateWithSchema(String string) throws InvalidDDMSException {
        try {
            new DDMSReader().getElement(string);
        }
        catch (SAXException sAXException) {
            throw new InvalidDDMSException(sAXException);
        }
        catch (IOException iOException) {
            throw new InvalidDDMSException(iOException);
        }
    }

    public Element getElement(File file) throws IOException, InvalidDDMSException {
        Util.requireValue("file", file);
        return this.getElement(new FileReader(file));
    }

    public Element getElement(String string) throws IOException, InvalidDDMSException {
        Util.requireValue("XML string", string);
        return this.getElement(new StringReader(string));
    }

    public Element getElement(InputStream inputStream) throws IOException, InvalidDDMSException {
        Util.requireValue("input stream", inputStream);
        return this.getElement(new InputStreamReader(inputStream));
    }

    public Element getElement(Reader reader) throws IOException, InvalidDDMSException {
        Util.requireValue("reader", reader);
        try {
            Builder builder = new Builder(this.getReader(), true);
            Document document = builder.build(reader);
            return document.getRootElement();
        }
        catch (ParsingException parsingException) {
            throw new InvalidDDMSException(parsingException);
        }
    }

    public Resource getDDMSResource(File file) throws IOException, InvalidDDMSException {
        return this.buildResource(this.getElement(file));
    }

    public Resource getDDMSResource(String string) throws IOException, InvalidDDMSException {
        return this.buildResource(this.getElement(string));
    }

    public Resource getDDMSResource(InputStream inputStream) throws IOException, InvalidDDMSException {
        return this.buildResource(this.getElement(inputStream));
    }

    public Resource getDDMSResource(Reader reader) throws IOException, InvalidDDMSException {
        return this.buildResource(this.getElement(reader));
    }

    protected Resource buildResource(Element element) throws InvalidDDMSException {
        DDMSVersion.setCurrentVersion(DDMSVersion.getVersionForNamespace(element.getNamespaceURI()).getVersion());
        return new Resource(element);
    }

    public String getExternalSchemaLocations() {
        try {
            return (String)this.getReader().getProperty(PROP_XERCES_EXTERNAL_LOCATION);
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException("http://apache.org/xml/properties/schema/external-schemaLocation is not supported or recognized for this XMLReader.");
        }
    }

    private XMLReader getReader() {
        return this._reader;
    }
}

