/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary.xlink;

import buri.ddmsence.AbstractAttributeGroup;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.Resource;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import nu.xom.Element;

public final class XLinkAttributes
extends AbstractAttributeGroup {
    private String _type = null;
    private String _href = null;
    private String _role = null;
    private String _title = null;
    private String _label = null;
    private String _arcrole = null;
    private String _show = null;
    private String _actuate = null;
    private static final String TYPE_NAME = "type";
    private static final String HREF_NAME = "href";
    private static final String ROLE_NAME = "role";
    private static final String TITLE_NAME = "title";
    private static final String LABEL_NAME = "label";
    private static final String ARC_ROLE_NAME = "arcrole";
    private static final String SHOW_NAME = "show";
    private static final String ACTUATE_NAME = "actuate";
    private static final String TYPE_LOCATOR = "locator";
    private static final String TYPE_SIMPLE = "simple";
    private static final String TYPE_RESOURCE = "resource";
    private static Set<String> TYPE_TYPES = new HashSet<String>();
    private static Set<String> SHOW_TYPES;
    private static Set<String> ACTUATE_TYPES;

    public static XLinkAttributes getNonNullInstance(XLinkAttributes xLinkAttributes) throws InvalidDDMSException {
        return xLinkAttributes == null ? new XLinkAttributes() : xLinkAttributes;
    }

    public XLinkAttributes(Element element) throws InvalidDDMSException {
        super(element.getNamespaceURI());
        String string = this.getDDMSVersion().getXlinkNamespace();
        this._type = element.getAttributeValue(TYPE_NAME, string);
        this._href = element.getAttributeValue(HREF_NAME, string);
        this._role = element.getAttributeValue(ROLE_NAME, string);
        this._title = element.getAttributeValue(TITLE_NAME, string);
        this._label = element.getAttributeValue(LABEL_NAME, string);
        this._arcrole = element.getAttributeValue(ARC_ROLE_NAME, string);
        this._show = element.getAttributeValue(SHOW_NAME, string);
        this._actuate = element.getAttributeValue(ACTUATE_NAME, string);
        this.validate();
    }

    public XLinkAttributes() throws InvalidDDMSException {
        super(DDMSVersion.getCurrentVersion().getNamespace());
        this.validate();
    }

    public XLinkAttributes(String string, String string2, String string3) throws InvalidDDMSException {
        super(DDMSVersion.getCurrentVersion().getNamespace());
        this._type = TYPE_RESOURCE;
        this._role = string;
        this._title = string2;
        this._label = string3;
        this.validate();
    }

    public XLinkAttributes(String string, String string2, String string3, String string4) throws InvalidDDMSException {
        super(DDMSVersion.getCurrentVersion().getNamespace());
        this._type = TYPE_LOCATOR;
        this._href = string;
        this._role = string2;
        this._title = string3;
        this._label = string4;
        this.validate();
    }

    public XLinkAttributes(String string, String string2, String string3, String string4, String string5, String string6) throws InvalidDDMSException {
        super(DDMSVersion.getCurrentVersion().getNamespace());
        this._type = TYPE_SIMPLE;
        this._href = string;
        this._role = string2;
        this._title = string3;
        this._arcrole = string4;
        this._show = string5;
        this._actuate = string6;
        this.validate();
    }

    public void addTo(Element element) throws InvalidDDMSException {
        DDMSVersion dDMSVersion = DDMSVersion.getVersionForNamespace(element.getNamespaceURI());
        this.validateSameVersion(dDMSVersion);
        String string = dDMSVersion.getXlinkNamespace();
        String string2 = PropertyReader.getPrefix("xlink");
        Util.addAttribute(element, string2, TYPE_NAME, string, this.getType());
        Util.addAttribute(element, string2, HREF_NAME, string, this.getHref());
        Util.addAttribute(element, string2, ROLE_NAME, string, this.getRole());
        Util.addAttribute(element, string2, TITLE_NAME, string, this.getTitle());
        Util.addAttribute(element, string2, LABEL_NAME, string, this.getLabel());
        Util.addAttribute(element, string2, ARC_ROLE_NAME, string, this.getArcrole());
        Util.addAttribute(element, string2, SHOW_NAME, string, this.getShow());
        Util.addAttribute(element, string2, ACTUATE_NAME, string, this.getActuate());
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        if (!Util.isEmpty(this.getHref())) {
            Util.requireDDMSValidURI(this.getHref());
        }
        if (this.getDDMSVersion().isAtLeast("4.0.1")) {
            if (!Util.isEmpty(this.getRole())) {
                Util.requireDDMSValidURI(this.getRole());
            }
            if (!Util.isEmpty(this.getLabel())) {
                Util.requireValidNCName(this.getLabel());
            }
        }
        if (!Util.isEmpty(this.getArcrole())) {
            Util.requireDDMSValidURI(this.getArcrole());
        }
        if (!Util.isEmpty(this.getShow()) && !SHOW_TYPES.contains(this.getShow())) {
            throw new InvalidDDMSException("The show attribute must be one of " + SHOW_TYPES);
        }
        if (!Util.isEmpty(this.getActuate()) && !ACTUATE_TYPES.contains(this.getActuate())) {
            throw new InvalidDDMSException("The actuate attribute must be one of " + ACTUATE_TYPES);
        }
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string) {
        String string2 = Util.getNonNullString(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Resource.buildOutput(bl, string2 + TYPE_NAME, this.getType()));
        stringBuffer.append(Resource.buildOutput(bl, string2 + HREF_NAME, this.getHref()));
        stringBuffer.append(Resource.buildOutput(bl, string2 + ROLE_NAME, this.getRole()));
        stringBuffer.append(Resource.buildOutput(bl, string2 + TITLE_NAME, this.getTitle()));
        stringBuffer.append(Resource.buildOutput(bl, string2 + LABEL_NAME, this.getLabel()));
        stringBuffer.append(Resource.buildOutput(bl, string2 + ARC_ROLE_NAME, this.getArcrole()));
        stringBuffer.append(Resource.buildOutput(bl, string2 + SHOW_NAME, this.getShow()));
        stringBuffer.append(Resource.buildOutput(bl, string2 + ACTUATE_NAME, this.getActuate()));
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof XLinkAttributes)) {
            return false;
        }
        XLinkAttributes xLinkAttributes = (XLinkAttributes)object;
        return this.getType().equals(xLinkAttributes.getType()) && this.getHref().equals(xLinkAttributes.getHref()) && this.getRole().equals(xLinkAttributes.getRole()) && this.getTitle().equals(xLinkAttributes.getTitle()) && this.getLabel().equals(xLinkAttributes.getLabel()) && this.getArcrole().equals(xLinkAttributes.getArcrole()) && this.getShow().equals(xLinkAttributes.getShow()) && this.getActuate().equals(xLinkAttributes.getActuate());
    }

    public int hashCode() {
        int n = 0;
        n = 7 * n + this.getType().hashCode();
        n = 7 * n + this.getHref().hashCode();
        n = 7 * n + this.getRole().hashCode();
        n = 7 * n + this.getTitle().hashCode();
        n = 7 * n + this.getLabel().hashCode();
        n = 7 * n + this.getArcrole().hashCode();
        n = 7 * n + this.getShow().hashCode();
        n = 7 * n + this.getActuate().hashCode();
        return n;
    }

    public String getType() {
        return Util.getNonNullString(this._type);
    }

    public String getHref() {
        return Util.getNonNullString(this._href);
    }

    public String getRole() {
        return Util.getNonNullString(this._role);
    }

    public String getTitle() {
        return Util.getNonNullString(this._title);
    }

    public String getLabel() {
        return Util.getNonNullString(this._label);
    }

    public String getArcrole() {
        return Util.getNonNullString(this._arcrole);
    }

    public String getShow() {
        return Util.getNonNullString(this._show);
    }

    public String getActuate() {
        return Util.getNonNullString(this._actuate);
    }

    static {
        TYPE_TYPES.add(TYPE_LOCATOR);
        TYPE_TYPES.add(TYPE_SIMPLE);
        TYPE_TYPES.add(TYPE_RESOURCE);
        SHOW_TYPES = new HashSet<String>();
        SHOW_TYPES.add("new");
        SHOW_TYPES.add("replace");
        SHOW_TYPES.add("embed");
        SHOW_TYPES.add("other");
        SHOW_TYPES.add("none");
        ACTUATE_TYPES = new HashSet<String>();
        ACTUATE_TYPES.add("onLoad");
        ACTUATE_TYPES.add("onRequest");
        ACTUATE_TYPES.add("other");
        ACTUATE_TYPES.add("none");
    }

    public static class Builder
    implements Serializable {
        private static final long serialVersionUID = 6071979027185230870L;
        private String _type;
        private String _href;
        private String _role;
        private String _title;
        private String _label;
        private String _arcrole;
        private String _show;
        private String _actuate;

        public Builder() {
        }

        public Builder(XLinkAttributes xLinkAttributes) {
            this.setType(xLinkAttributes.getType());
            this.setHref(xLinkAttributes.getHref());
            this.setRole(xLinkAttributes.getRole());
            this.setTitle(xLinkAttributes.getTitle());
            this.setLabel(xLinkAttributes.getLabel());
            this.setArcrole(xLinkAttributes.getArcrole());
            this.setShow(xLinkAttributes.getShow());
            this.setActuate(xLinkAttributes.getActuate());
        }

        public XLinkAttributes commit() throws InvalidDDMSException {
            if (XLinkAttributes.TYPE_LOCATOR.equals(this.getType())) {
                return new XLinkAttributes(this.getHref(), this.getRole(), this.getTitle(), this.getLabel());
            }
            if (XLinkAttributes.TYPE_SIMPLE.equals(this.getType())) {
                return new XLinkAttributes(this.getHref(), this.getRole(), this.getTitle(), this.getArcrole(), this.getShow(), this.getActuate());
            }
            if (XLinkAttributes.TYPE_RESOURCE.equals(this.getType())) {
                return new XLinkAttributes(this.getRole(), this.getTitle(), this.getLabel());
            }
            return new XLinkAttributes();
        }

        public boolean isEmpty() {
            return Util.isEmpty(this.getType()) && Util.isEmpty(this.getHref()) && Util.isEmpty(this.getRole()) && Util.isEmpty(this.getTitle()) && Util.isEmpty(this.getLabel()) && Util.isEmpty(this.getArcrole()) && Util.isEmpty(this.getShow()) && Util.isEmpty(this.getActuate());
        }

        public String getType() {
            return this._type;
        }

        public void setType(String string) {
            this._type = string;
        }

        public String getHref() {
            return this._href;
        }

        public void setHref(String string) {
            this._href = string;
        }

        public String getRole() {
            return this._role;
        }

        public void setRole(String string) {
            this._role = string;
        }

        public String getTitle() {
            return this._title;
        }

        public void setTitle(String string) {
            this._title = string;
        }

        public String getLabel() {
            return this._label;
        }

        public void setLabel(String string) {
            this._label = string;
        }

        public String getArcrole() {
            return this._arcrole;
        }

        public void setArcrole(String string) {
            this._arcrole = string;
        }

        public String getShow() {
            return this._show;
        }

        public void setShow(String string) {
            this._show = string;
        }

        public String getActuate() {
            return this._actuate;
        }

        public void setActuate(String string) {
            this._actuate = string;
        }
    }
}

