/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary.gml;

import buri.ddmsence.AbstractAttributeGroup;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.Resource;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;

public final class SRSAttributes
extends AbstractAttributeGroup {
    private String _srsName = null;
    private Integer _srsDimension = null;
    private List<String> _axisLabels = null;
    private List<String> _uomLabels = null;
    public static final String NO_PREFIX = "";
    public static final String NO_NAMESPACE = "";
    private static final String SRS_NAME_NAME = "srsName";
    private static final String SRS_DIMENSION_NAME = "srsDimension";
    private static final String AXIS_LABELS_NAME = "axisLabels";
    private static final String UOM_LABELS_NAME = "uomLabels";

    public static SRSAttributes getNonNullInstance(SRSAttributes sRSAttributes) throws InvalidDDMSException {
        return sRSAttributes == null ? new SRSAttributes(null, null, null, null) : sRSAttributes;
    }

    public SRSAttributes(Element element) throws InvalidDDMSException {
        super(element.getNamespaceURI());
        this._srsName = element.getAttributeValue(SRS_NAME_NAME, "");
        String string = element.getAttributeValue(SRS_DIMENSION_NAME, "");
        if (!Util.isEmpty(string)) {
            this._srsDimension = Integer.valueOf(string);
        }
        String string2 = element.getAttributeValue(AXIS_LABELS_NAME, "");
        this._axisLabels = new ArrayList<String>();
        if (!Util.isEmpty(string2)) {
            this._axisLabels.addAll(Util.getXsListAsList(string2));
        }
        String string3 = element.getAttributeValue(UOM_LABELS_NAME, "");
        this._uomLabels = new ArrayList<String>();
        if (!Util.isEmpty(string3)) {
            this._uomLabels.addAll(Util.getXsListAsList(string3));
        }
        this.validate();
    }

    public SRSAttributes(String string, Integer n, List<String> list, List<String> list2) throws InvalidDDMSException {
        super(DDMSVersion.getCurrentVersion().getGmlNamespace());
        if (list == null) {
            list = Collections.emptyList();
        }
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        this._srsName = string;
        this._srsDimension = n;
        this._axisLabels = list;
        this._uomLabels = list2;
        this.validate();
    }

    protected void addTo(Element element) throws InvalidDDMSException {
        DDMSVersion dDMSVersion = DDMSVersion.getVersionForNamespace(element.getNamespaceURI());
        this.validateSameVersion(dDMSVersion);
        Util.addAttribute(element, "", SRS_NAME_NAME, "", this.getSrsName());
        if (this.getSrsDimension() != null) {
            Util.addAttribute(element, "", SRS_DIMENSION_NAME, "", String.valueOf(this.getSrsDimension()));
        }
        Util.addAttribute(element, "", AXIS_LABELS_NAME, "", this.getAxisLabelsAsXsList());
        Util.addAttribute(element, "", UOM_LABELS_NAME, "", this.getUomLabelsAsXsList());
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        if (!Util.isEmpty(this.getSrsName())) {
            Util.requireDDMSValidURI(this.getSrsName());
        }
        if (this.getSrsDimension() != null && this.getSrsDimension() < 0) {
            throw new InvalidDDMSException("The srsDimension must be a positive integer.");
        }
        if (Util.isEmpty(this.getSrsName()) && !this.getAxisLabels().isEmpty()) {
            throw new InvalidDDMSException("The axisLabels attribute can only be used in tandem with an srsName.");
        }
        if (this.getAxisLabels().isEmpty() && !this.getUomLabels().isEmpty()) {
            throw new InvalidDDMSException("The uomLabels attribute can only be used in tandem with axisLabels.");
        }
        Util.requireValidNCNames(this.getAxisLabels());
        Util.requireValidNCNames(this.getUomLabels());
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string) {
        String string2 = Util.getNonNullString(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Resource.buildOutput(bl, string2 + SRS_NAME_NAME, this.getSrsName()));
        if (this.getSrsDimension() != null) {
            stringBuffer.append(Resource.buildOutput(bl, string2 + SRS_DIMENSION_NAME, String.valueOf(this.getSrsDimension())));
        }
        stringBuffer.append(Resource.buildOutput(bl, string2 + AXIS_LABELS_NAME, this.getAxisLabelsAsXsList()));
        stringBuffer.append(Resource.buildOutput(bl, string2 + UOM_LABELS_NAME, this.getUomLabelsAsXsList()));
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SRSAttributes)) {
            return false;
        }
        SRSAttributes sRSAttributes = (SRSAttributes)object;
        return this.getSrsName().equals(sRSAttributes.getSrsName()) && Util.nullEquals(this.getSrsDimension(), sRSAttributes.getSrsDimension()) && Util.listEquals(this.getAxisLabels(), sRSAttributes.getAxisLabels()) && Util.listEquals(this.getUomLabels(), sRSAttributes.getUomLabels());
    }

    public int hashCode() {
        int n = 0;
        n = 7 * n + this.getSrsName().hashCode();
        if (this.getSrsDimension() != null) {
            n = 7 * n + this.getSrsDimension().hashCode();
        }
        n = 7 * n + this.getAxisLabels().hashCode();
        n = 7 * n + this.getUomLabels().hashCode();
        return n;
    }

    public String getSrsName() {
        return Util.getNonNullString(this._srsName);
    }

    public Integer getSrsDimension() {
        return this._srsDimension;
    }

    public List<String> getAxisLabels() {
        return Collections.unmodifiableList(this._axisLabels);
    }

    public String getAxisLabelsAsXsList() {
        return Util.getXsList(this.getAxisLabels());
    }

    public List<String> getUomLabels() {
        return Collections.unmodifiableList(this._uomLabels);
    }

    public String getUomLabelsAsXsList() {
        return Util.getXsList(this.getUomLabels());
    }

    public static class Builder
    implements Serializable {
        private static final long serialVersionUID = 6071979027185230870L;
        private String _srsName;
        private Integer _srsDimension;
        private List<String> _axisLabels;
        private List<String> _uomLabels;

        public Builder() {
        }

        public Builder(SRSAttributes sRSAttributes) {
            this.setSrsName(sRSAttributes.getSrsName());
            this.setSrsDimension(sRSAttributes.getSrsDimension());
            this.setAxisLabels(sRSAttributes.getAxisLabels());
            this.setUomLabels(sRSAttributes.getUomLabels());
        }

        public SRSAttributes commit() throws InvalidDDMSException {
            return new SRSAttributes(this.getSrsName(), this.getSrsDimension(), this.getAxisLabels(), this.getUomLabels());
        }

        public boolean isEmpty() {
            return Util.isEmpty(this.getSrsName()) && this.getSrsDimension() == null && Util.containsOnlyEmptyValues(this.getAxisLabels()) && Util.containsOnlyEmptyValues(this.getUomLabels());
        }

        public String getSrsName() {
            return this._srsName;
        }

        public void setSrsName(String string) {
            this._srsName = string;
        }

        public Integer getSrsDimension() {
            return this._srsDimension;
        }

        public void setSrsDimension(Integer n) {
            this._srsDimension = n;
        }

        public List<String> getAxisLabels() {
            if (this._axisLabels == null) {
                this._axisLabels = new LazyList(String.class);
            }
            return this._axisLabels;
        }

        public void setAxisLabels(List<String> list) {
            this._axisLabels = new LazyList(list, String.class);
        }

        public List<String> getUomLabels() {
            if (this._uomLabels == null) {
                this._uomLabels = new LazyList(String.class);
            }
            return this._uomLabels;
        }

        public void setUomLabels(List<String> list) {
            this._uomLabels = new LazyList(list, String.class);
        }
    }
}

