/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import nu.xom.Element;

public final class VirtualCoverage
extends AbstractBaseComponent {
    private SecurityAttributes _securityAttributes = null;
    private static final String ADDRESS_NAME = "address";
    private static final String PROTOCOL_NAME = "protocol";

    public VirtualCoverage(Element element) throws InvalidDDMSException {
        try {
            this._securityAttributes = new SecurityAttributes(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public VirtualCoverage(String string, String string2, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        try {
            Element element = Util.buildDDMSElement(VirtualCoverage.getName(DDMSVersion.getCurrentVersion()), null);
            Util.addDDMSAttribute(element, ADDRESS_NAME, string);
            Util.addDDMSAttribute(element, PROTOCOL_NAME, string2);
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), VirtualCoverage.getName(this.getDDMSVersion()));
        if (!Util.isEmpty(this.getAddress())) {
            Util.requireDDMSValue(PROTOCOL_NAME, this.getProtocol());
        }
        if (!this.getDDMSVersion().isAtLeast("3.0") && !this.getSecurityAttributes().isEmpty()) {
            throw new InvalidDDMSException("Security attributes cannot be applied to this component until DDMS 3.0 or later.");
        }
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (Util.isEmpty(this.getAddress()) && Util.isEmpty(this.getProtocol())) {
            this.addWarning("A completely empty ddms:virtualCoverage element was found.");
        }
        super.validateWarnings();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(VirtualCoverage.buildOutput(bl, string3 + ADDRESS_NAME, this.getAddress()));
        stringBuffer.append(VirtualCoverage.buildOutput(bl, string3 + PROTOCOL_NAME, this.getProtocol()));
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof VirtualCoverage)) {
            return false;
        }
        VirtualCoverage virtualCoverage = (VirtualCoverage)object;
        return this.getAddress().equals(virtualCoverage.getAddress()) && this.getProtocol().equals(virtualCoverage.getProtocol());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getAddress().hashCode();
        n = 7 * n + this.getProtocol().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "virtualCoverage";
    }

    public String getAddress() {
        return this.getAttributeValue(ADDRESS_NAME);
    }

    public String getProtocol() {
        return this.getAttributeValue(PROTOCOL_NAME);
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 2986952678400201045L;
        private String _address;
        private String _protocol;
        private SecurityAttributes.Builder _securityAttributes;

        public Builder() {
        }

        public Builder(VirtualCoverage virtualCoverage) {
            this.setAddress(virtualCoverage.getAddress());
            this.setProtocol(virtualCoverage.getProtocol());
            this.setSecurityAttributes(new SecurityAttributes.Builder(virtualCoverage.getSecurityAttributes()));
        }

        @Override
        public VirtualCoverage commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new VirtualCoverage(this.getAddress(), this.getProtocol(), this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            return Util.isEmpty(this.getAddress()) && Util.isEmpty(this.getProtocol()) && this.getSecurityAttributes().isEmpty();
        }

        public String getAddress() {
            return this._address;
        }

        public void setAddress(String string) {
            this._address = string;
        }

        public String getProtocol() {
            return this._protocol;
        }

        public void setProtocol(String string) {
            this._protocol = string;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

