/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.ApproximableDate;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import nu.xom.Element;
import nu.xom.Node;

public final class TemporalCoverage
extends AbstractBaseComponent {
    private String _name = "Unknown";
    private ApproximableDate _approximableStart = null;
    private ApproximableDate _approximableEnd = null;
    private SecurityAttributes _securityAttributes = null;
    private static final String DEFAULT_VALUE = "Unknown";
    private static Set<String> EXTENDED_DATE_TYPES = new HashSet<String>();
    private static final String TIME_PERIOD_NAME = "TimePeriod";
    private static final String TIME_PERIOD_NAME_NAME = "name";
    private static final String START_NAME = "start";
    private static final String END_NAME = "end";
    private static final String APPROXIMABLE_START_NAME = "approximableStart";
    private static final String APPROXIMABLE_END_NAME = "approximableEnd";

    public TemporalCoverage(Element element) throws InvalidDDMSException {
        try {
            this.setXOMElement(element, false);
            Element element2 = this.getTimePeriodElement();
            if (element2 != null) {
                Element element3;
                Element element4;
                Element element5 = element2.getFirstChildElement(TIME_PERIOD_NAME_NAME, this.getNamespace());
                if (element5 != null && !Util.isEmpty(element5.getValue())) {
                    this._name = element5.getValue();
                }
                if ((element4 = element.getFirstChildElement(APPROXIMABLE_START_NAME, this.getNamespace())) != null) {
                    this._approximableStart = new ApproximableDate(element4);
                }
                if ((element3 = element.getFirstChildElement(APPROXIMABLE_END_NAME, this.getNamespace())) != null) {
                    this._approximableEnd = new ApproximableDate(element3);
                }
            }
            this._securityAttributes = new SecurityAttributes(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public TemporalCoverage(String string, String string2, String string3, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        this(string, string2, null, string3, null, securityAttributes);
    }

    public TemporalCoverage(String string, String string2, ApproximableDate approximableDate, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        this(string, string2, null, null, approximableDate, securityAttributes);
    }

    public TemporalCoverage(String string, ApproximableDate approximableDate, String string2, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        this(string, null, approximableDate, string2, null, securityAttributes);
    }

    public TemporalCoverage(String string, ApproximableDate approximableDate, ApproximableDate approximableDate2, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        this(string, null, approximableDate, null, approximableDate2, securityAttributes);
    }

    private TemporalCoverage(String string, String string2, ApproximableDate approximableDate, String string3, ApproximableDate approximableDate2, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        try {
            Element element;
            Element element2 = Util.buildDDMSElement(TemporalCoverage.getName(DDMSVersion.getCurrentVersion()), null);
            Element element3 = element = DDMSVersion.getCurrentVersion().isAtLeast("4.0.1") ? element2 : Util.buildDDMSElement(TIME_PERIOD_NAME, null);
            if (!DDMSVersion.getCurrentVersion().isAtLeast("4.0.1")) {
                element2.appendChild((Node)element);
            }
            if (!Util.isEmpty(string)) {
                this._name = string;
            }
            Util.addDDMSChildElement(element, TIME_PERIOD_NAME_NAME, string);
            if (approximableDate != null) {
                element2.appendChild((Node)approximableDate.getXOMElementCopy());
                this._approximableStart = approximableDate;
            } else {
                string2 = Util.isEmpty(string2) ? DEFAULT_VALUE : string2;
                element.appendChild((Node)Util.buildDDMSElement(START_NAME, string2));
            }
            if (approximableDate2 != null) {
                element2.appendChild((Node)approximableDate2.getXOMElementCopy());
                this._approximableEnd = approximableDate2;
            } else {
                string3 = Util.isEmpty(string3) ? DEFAULT_VALUE : string3;
                element.appendChild((Node)Util.buildDDMSElement(END_NAME, string3));
            }
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element2);
            this.setXOMElement(element2, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), TemporalCoverage.getName(this.getDDMSVersion()));
        Element element = this.getTimePeriodElement();
        Util.requireDDMSValue("TimePeriod element", element);
        Util.requireBoundedChildCount(element, TIME_PERIOD_NAME_NAME, 0, 1);
        Util.requireBoundedChildCount(element, START_NAME, 0, 1);
        Util.requireBoundedChildCount(element, END_NAME, 0, 1);
        Util.requireBoundedChildCount(element, APPROXIMABLE_START_NAME, 0, 1);
        Util.requireBoundedChildCount(element, APPROXIMABLE_END_NAME, 0, 1);
        if (this.getApproximableStart() == null) {
            Util.requireDDMSValue(START_NAME, this.getStartString());
            if (!EXTENDED_DATE_TYPES.contains(this.getStartString())) {
                Util.requireDDMSDateFormat(this.getStartString(), this.getNamespace());
            }
        }
        if (this.getApproximableEnd() == null) {
            Util.requireDDMSValue(END_NAME, this.getEndString());
            if (!EXTENDED_DATE_TYPES.contains(this.getEndString())) {
                Util.requireDDMSDateFormat(this.getEndString(), this.getNamespace());
            }
        }
        if (!this.getDDMSVersion().isAtLeast("3.0") && !this.getSecurityAttributes().isEmpty()) {
            throw new InvalidDDMSException("Security attributes cannot be applied to this component until DDMS 3.0 or later.");
        }
        if (!(this.getDDMSVersion().isAtLeast("4.1") || this.getApproximableStart() == null && this.getApproximableEnd() == null)) {
            throw new InvalidDDMSException("Approximable dates cannot be used until DDMS 4.1 or later.");
        }
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        Element element = this.getTimePeriodElement();
        Element element2 = element.getFirstChildElement(TIME_PERIOD_NAME_NAME, element.getNamespaceURI());
        if (element2 != null && Util.isEmpty(element2.getValue())) {
            this.addWarning("A ddms:name element was found with no value. Defaulting to \"Unknown\".");
        }
        if (this.getApproximableStart() != null || this.getApproximableEnd() != null) {
            this.addDdms40Warning("ddms:approximableStart or ddms:approximableEnd element");
        }
        super.validateWarnings();
    }

    @Override
    protected String getLocatorSuffix() {
        return this.getDDMSVersion().isAtLeast("4.0.1") ? "" : "/" + this.getXOMElement().getNamespacePrefix() + ":" + TIME_PERIOD_NAME;
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        if (!this.getDDMSVersion().isAtLeast("4.0.1")) {
            string3 = string3 + "TimePeriod.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TemporalCoverage.buildOutput(bl, string3 + TIME_PERIOD_NAME_NAME, this.getTimePeriodName()));
        stringBuffer.append(TemporalCoverage.buildOutput(bl, string3 + START_NAME, this.getStartString()));
        stringBuffer.append(TemporalCoverage.buildOutput(bl, string3 + END_NAME, this.getEndString()));
        if (this.getApproximableStart() != null) {
            stringBuffer.append(this.getApproximableStart().getOutput(bl, string3, ""));
        }
        if (this.getApproximableEnd() != null) {
            stringBuffer.append(this.getApproximableEnd().getOutput(bl, string3, ""));
        }
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.add(this.getApproximableStart());
        arrayList.add(this.getApproximableEnd());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof TemporalCoverage)) {
            return false;
        }
        TemporalCoverage temporalCoverage = (TemporalCoverage)object;
        return this.getTimePeriodName().equals(temporalCoverage.getTimePeriodName()) && this.getStartString().equals(temporalCoverage.getStartString()) && this.getEndString().equals(temporalCoverage.getEndString());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getTimePeriodName().hashCode();
        n = 7 * n + this.getStartString().hashCode();
        n = 7 * n + this.getEndString().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "temporalCoverage";
    }

    private Element getTimePeriodElement() {
        return this.getDDMSVersion().isAtLeast("4.0.1") ? this.getXOMElement() : this.getChild(TIME_PERIOD_NAME);
    }

    public String getTimePeriodName() {
        return this._name;
    }

    public XMLGregorianCalendar getStart() {
        try {
            return TemporalCoverage.getFactory().newXMLGregorianCalendar(this.getStartString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String getStartString() {
        Element element = this.getTimePeriodElement().getFirstChildElement(START_NAME, this.getNamespace());
        if (element == null) {
            return "";
        }
        String string = element.getValue();
        if (Util.isEmpty(string)) {
            return DEFAULT_VALUE;
        }
        return string;
    }

    public XMLGregorianCalendar getEnd() {
        try {
            return TemporalCoverage.getFactory().newXMLGregorianCalendar(this.getEndString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String getEndString() {
        Element element = this.getTimePeriodElement().getFirstChildElement(END_NAME, this.getNamespace());
        if (element == null) {
            return "";
        }
        String string = element.getValue();
        return Util.isEmpty(string) ? DEFAULT_VALUE : string;
    }

    public ApproximableDate getApproximableStart() {
        return this._approximableStart;
    }

    public ApproximableDate getApproximableEnd() {
        return this._approximableEnd;
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    private static DatatypeFactory getFactory() {
        return Util.getDataTypeFactory();
    }

    static {
        EXTENDED_DATE_TYPES.add("Not Applicable");
        EXTENDED_DATE_TYPES.add(DEFAULT_VALUE);
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = -3187482277963663663L;
        private String _timePeriodName;
        private String _startString;
        private String _endString;
        private ApproximableDate.Builder _approximableStart;
        private ApproximableDate.Builder _approximableEnd;
        private SecurityAttributes.Builder _securityAttributes;

        public Builder() {
        }

        public Builder(TemporalCoverage temporalCoverage) {
            this.setTimePeriodName(temporalCoverage.getTimePeriodName());
            this.setStartString(temporalCoverage.getStartString());
            this.setEndString(temporalCoverage.getEndString());
            if (temporalCoverage.getApproximableStart() != null) {
                this.setApproximableStart(new ApproximableDate.Builder(temporalCoverage.getApproximableStart()));
            }
            if (temporalCoverage.getApproximableEnd() != null) {
                this.setApproximableEnd(new ApproximableDate.Builder(temporalCoverage.getApproximableEnd()));
            }
            this.setSecurityAttributes(new SecurityAttributes.Builder(temporalCoverage.getSecurityAttributes()));
        }

        @Override
        public TemporalCoverage commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            if (!this.getApproximableStart().isEmpty() && !Util.isEmpty(this.getStartString())) {
                throw new InvalidDDMSException("Only 1 of start or approximableStart can be used.");
            }
            if (!this.getApproximableEnd().isEmpty() && !Util.isEmpty(this.getEndString())) {
                throw new InvalidDDMSException("Only 1 of end or approximableEnd can be used.");
            }
            return new TemporalCoverage(this.getTimePeriodName(), this.getStartString(), this.getApproximableStart().commit(), this.getEndString(), this.getApproximableEnd().commit(), this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            return Util.isEmpty(this.getTimePeriodName()) && Util.isEmpty(this.getStartString()) && Util.isEmpty(this.getEndString()) && this.getApproximableStart().isEmpty() && this.getApproximableEnd().isEmpty() && this.getSecurityAttributes().isEmpty();
        }

        public String getTimePeriodName() {
            return this._timePeriodName;
        }

        public void setTimePeriodName(String string) {
            this._timePeriodName = string;
        }

        public String getStartString() {
            return this._startString;
        }

        public void setStartString(String string) {
            this._startString = string;
        }

        public String getEndString() {
            return this._endString;
        }

        public void setEndString(String string) {
            this._endString = string;
        }

        public ApproximableDate.Builder getApproximableStart() {
            if (this._approximableStart == null) {
                this._approximableStart = new ApproximableDate.Builder();
                this._approximableStart.setName(TemporalCoverage.APPROXIMABLE_START_NAME);
            }
            return this._approximableStart;
        }

        public void setApproximableStart(ApproximableDate.Builder builder) {
            this._approximableStart = builder;
        }

        public ApproximableDate.Builder getApproximableEnd() {
            if (this._approximableEnd == null) {
                this._approximableEnd = new ApproximableDate.Builder();
                this._approximableEnd.setName(TemporalCoverage.APPROXIMABLE_END_NAME);
            }
            return this._approximableEnd;
        }

        public void setApproximableEnd(ApproximableDate.Builder builder) {
            this._approximableEnd = builder;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

