/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.ddms.summary.Category;
import buri.ddmsence.ddms.summary.Keyword;
import buri.ddmsence.ddms.summary.NonStateActor;
import buri.ddmsence.ddms.summary.ProductionMetric;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public final class SubjectCoverage
extends AbstractBaseComponent {
    private List<Keyword> _keywords = null;
    private List<Category> _categories = null;
    private List<ProductionMetric> _productionMetrics = null;
    private List<NonStateActor> _nonStateActors = null;
    private SecurityAttributes _securityAttributes = null;
    private static final String SUBJECT_NAME = "Subject";

    public SubjectCoverage(Element element) throws InvalidDDMSException {
        try {
            Util.requireDDMSValue("subjectCoverage element", element);
            this.setXOMElement(element, false);
            Element element2 = this.getSubjectElement();
            this._keywords = new ArrayList<Keyword>();
            this._categories = new ArrayList<Category>();
            this._productionMetrics = new ArrayList<ProductionMetric>();
            this._nonStateActors = new ArrayList<NonStateActor>();
            if (element2 != null) {
                Elements elements = element2.getChildElements(Keyword.getName(this.getDDMSVersion()), this.getNamespace());
                for (int i = 0; i < elements.size(); ++i) {
                    this._keywords.add(new Keyword(elements.get(i)));
                }
                Elements elements2 = element2.getChildElements(Category.getName(this.getDDMSVersion()), this.getNamespace());
                for (int i = 0; i < elements2.size(); ++i) {
                    this._categories.add(new Category(elements2.get(i)));
                }
                Elements elements3 = element2.getChildElements(ProductionMetric.getName(this.getDDMSVersion()), this.getNamespace());
                for (int i = 0; i < elements3.size(); ++i) {
                    this._productionMetrics.add(new ProductionMetric(elements3.get(i)));
                }
                Elements elements4 = element2.getChildElements(NonStateActor.getName(this.getDDMSVersion()), this.getNamespace());
                for (int i = 0; i < elements4.size(); ++i) {
                    this._nonStateActors.add(new NonStateActor(elements4.get(i)));
                }
            }
            this._securityAttributes = new SecurityAttributes(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public SubjectCoverage(List<Keyword> list, List<Category> list2, List<ProductionMetric> list3, List<NonStateActor> list4, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            if (list2 == null) {
                list2 = Collections.emptyList();
            }
            if (list3 == null) {
                list3 = Collections.emptyList();
            }
            if (list4 == null) {
                list4 = Collections.emptyList();
            }
            Element element = Util.buildDDMSElement(SubjectCoverage.getName(DDMSVersion.getCurrentVersion()), null);
            Element element2 = DDMSVersion.getCurrentVersion().isAtLeast("4.0.1") ? element : Util.buildDDMSElement(SUBJECT_NAME, null);
            for (Keyword abstractBaseComponent : list) {
                element2.appendChild((Node)abstractBaseComponent.getXOMElementCopy());
            }
            for (Category category : list2) {
                element2.appendChild((Node)category.getXOMElementCopy());
            }
            for (ProductionMetric productionMetric : list3) {
                element2.appendChild((Node)productionMetric.getXOMElementCopy());
            }
            for (NonStateActor nonStateActor : list4) {
                element2.appendChild((Node)nonStateActor.getXOMElementCopy());
            }
            if (!DDMSVersion.getCurrentVersion().isAtLeast("4.0.1")) {
                element.appendChild((Node)element2);
            }
            this._keywords = list;
            this._categories = list2;
            this._productionMetrics = list3;
            this._nonStateActors = list4;
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), SubjectCoverage.getName(this.getDDMSVersion()));
        Element element = this.getSubjectElement();
        Util.requireDDMSValue("Subject element", element);
        String string = element.getNamespaceURI();
        int n = element.getChildElements(Keyword.getName(this.getDDMSVersion()), string).size() + element.getChildElements(Category.getName(this.getDDMSVersion()), string).size();
        if (n < 1) {
            throw new InvalidDDMSException("At least 1 keyword or category must exist.");
        }
        if (!this.getDDMSVersion().isAtLeast("3.0") && !this.getSecurityAttributes().isEmpty()) {
            throw new InvalidDDMSException("Security attributes cannot be applied to this component until DDMS 3.0 or later.");
        }
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        HashSet<ProductionMetric> hashSet;
        HashSet<Category> hashSet2;
        HashSet<Keyword> hashSet3 = new HashSet<Keyword>(this.getKeywords());
        if (hashSet3.size() != this.getKeywords().size()) {
            this.addWarning("1 or more keywords have the same value.");
        }
        if ((hashSet2 = new HashSet<Category>(this.getCategories())).size() != this.getCategories().size()) {
            this.addWarning("1 or more categories have the same value.");
        }
        if ((hashSet = new HashSet<ProductionMetric>(this.getProductionMetrics())).size() != this.getProductionMetrics().size()) {
            this.addWarning("1 or more productionMetrics have the same value.");
        }
        super.validateWarnings();
    }

    @Override
    protected String getLocatorSuffix() {
        return this.getDDMSVersion().isAtLeast("4.0.1") ? "" : "/" + this.getXOMElement().getNamespacePrefix() + ":" + SUBJECT_NAME;
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        if (!this.getDDMSVersion().isAtLeast("4.0.1")) {
            string3 = string3 + "Subject.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.buildOutput(bl, string3, this.getKeywords()));
        stringBuffer.append(this.buildOutput(bl, string3, this.getCategories()));
        stringBuffer.append(this.buildOutput(bl, string3, this.getProductionMetrics()));
        stringBuffer.append(this.buildOutput(bl, string3, this.getNonStateActors()));
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.addAll(this.getKeywords());
        arrayList.addAll(this.getCategories());
        arrayList.addAll(this.getProductionMetrics());
        arrayList.addAll(this.getNonStateActors());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof SubjectCoverage;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "subjectCoverage";
    }

    private Element getSubjectElement() {
        return this.getDDMSVersion().isAtLeast("4.0.1") ? this.getXOMElement() : this.getChild(SUBJECT_NAME);
    }

    public List<Keyword> getKeywords() {
        return Collections.unmodifiableList(this._keywords);
    }

    public List<Category> getCategories() {
        return Collections.unmodifiableList(this._categories);
    }

    public List<ProductionMetric> getProductionMetrics() {
        return Collections.unmodifiableList(this._productionMetrics);
    }

    public List<NonStateActor> getNonStateActors() {
        return Collections.unmodifiableList(this._nonStateActors);
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = -1550204187042536412L;
        private List<Keyword.Builder> _keywords;
        private List<Category.Builder> _categories;
        private List<ProductionMetric.Builder> _productionMetrics;
        private List<NonStateActor.Builder> _nonStateActors;
        private SecurityAttributes.Builder _securityAttributes;

        public Builder() {
        }

        public Builder(SubjectCoverage subjectCoverage) {
            for (Keyword abstractBaseComponent : subjectCoverage.getKeywords()) {
                this.getKeywords().add(new Keyword.Builder(abstractBaseComponent));
            }
            for (Category category : subjectCoverage.getCategories()) {
                this.getCategories().add(new Category.Builder(category));
            }
            for (ProductionMetric productionMetric : subjectCoverage.getProductionMetrics()) {
                this.getProductionMetrics().add(new ProductionMetric.Builder(productionMetric));
            }
            for (NonStateActor nonStateActor : subjectCoverage.getNonStateActors()) {
                this.getNonStateActors().add(new NonStateActor.Builder(nonStateActor));
            }
            this.setSecurityAttributes(new SecurityAttributes.Builder(subjectCoverage.getSecurityAttributes()));
        }

        @Override
        public SubjectCoverage commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<Category> arrayList = new ArrayList<Category>();
            for (Category.Builder serializable2 : this.getCategories()) {
                Category category = serializable2.commit();
                if (category == null) continue;
                arrayList.add(category);
            }
            ArrayList arrayList2 = new ArrayList();
            for (Keyword.Builder builder : this.getKeywords()) {
                Keyword keyword = builder.commit();
                if (keyword == null) continue;
                arrayList2.add(keyword);
            }
            ArrayList<ProductionMetric> arrayList3 = new ArrayList<ProductionMetric>();
            for (ProductionMetric.Builder builder : this.getProductionMetrics()) {
                ProductionMetric productionMetric = builder.commit();
                if (productionMetric == null) continue;
                arrayList3.add(productionMetric);
            }
            ArrayList<NonStateActor> arrayList4 = new ArrayList<NonStateActor>();
            for (NonStateActor.Builder builder : this.getNonStateActors()) {
                NonStateActor nonStateActor = builder.commit();
                if (nonStateActor == null) continue;
                arrayList4.add(nonStateActor);
            }
            return new SubjectCoverage(arrayList2, arrayList, arrayList3, arrayList4, this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (IBuilder iBuilder : this.getChildBuilders()) {
                bl = bl || !iBuilder.isEmpty();
            }
            return !bl && this.getSecurityAttributes().isEmpty();
        }

        private List<IBuilder> getChildBuilders() {
            ArrayList<IBuilder> arrayList = new ArrayList<IBuilder>();
            arrayList.addAll(this.getKeywords());
            arrayList.addAll(this.getCategories());
            arrayList.addAll(this.getProductionMetrics());
            arrayList.addAll(this.getNonStateActors());
            return arrayList;
        }

        public List<Keyword.Builder> getKeywords() {
            if (this._keywords == null) {
                this._keywords = new LazyList(Keyword.Builder.class);
            }
            return this._keywords;
        }

        public List<Category.Builder> getCategories() {
            if (this._categories == null) {
                this._categories = new LazyList(Category.Builder.class);
            }
            return this._categories;
        }

        public List<ProductionMetric.Builder> getProductionMetrics() {
            if (this._productionMetrics == null) {
                this._productionMetrics = new LazyList(ProductionMetric.Builder.class);
            }
            return this._productionMetrics;
        }

        public List<NonStateActor.Builder> getNonStateActors() {
            if (this._nonStateActors == null) {
                this._nonStateActors = new LazyList(NonStateActor.Builder.class);
            }
            return this._nonStateActors;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

