/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractQualifierValue;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.ddms.summary.Link;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public final class RelatedResource
extends AbstractQualifierValue {
    private List<Link> _links = null;
    private SecurityAttributes _securityAttributes = null;
    public static final String INBOUND_DIRECTION = "inbound";
    public static final String OUTBOUND_DIRECTION = "outbound";
    public static final String BIDRECTIONAL_DIRECTION = "bidirectional";
    public static final String OLD_INNER_NAME = "RelatedResource";
    private static Set<String> RELATIONSHIP_DIRECTIONS = new HashSet<String>();
    private static final String RELATIONSHIP_NAME = "relationship";
    private static final String DIRECTION_NAME = "direction";

    public RelatedResource(Element element) throws InvalidDDMSException {
        try {
            Util.requireDDMSValue("element", element);
            this.setXOMElement(element, false);
            Element element2 = this.getInnerElement();
            if (element2 != null) {
                this._links = new ArrayList<Link>();
                Elements elements = element2.getChildElements(Link.getName(this.getDDMSVersion()), this.getNamespace());
                for (int i = 0; i < elements.size(); ++i) {
                    this._links.add(new Link(elements.get(i)));
                }
            }
            this._securityAttributes = new SecurityAttributes(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public RelatedResource(List<Link> list, String string, String string2, String string3, String string4, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            DDMSVersion dDMSVersion = DDMSVersion.getCurrentVersion();
            Element element = Util.buildDDMSElement(RelatedResource.getName(dDMSVersion), null);
            Util.addDDMSAttribute(element, RELATIONSHIP_NAME, string);
            Util.addDDMSAttribute(element, DIRECTION_NAME, string2);
            Element element2 = dDMSVersion.isAtLeast("4.0.1") ? element : Util.buildDDMSElement(OLD_INNER_NAME, null);
            Util.addDDMSAttribute(element2, "qualifier", string3);
            Util.addDDMSAttribute(element2, "value", string4);
            for (Link link : list) {
                element2.appendChild((Node)link.getXOMElementCopy());
            }
            if (!dDMSVersion.isAtLeast("4.0.1")) {
                element.appendChild((Node)element2);
            }
            this._links = list;
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public static void validateRelationshipDirection(String string) throws InvalidDDMSException {
        Util.requireDDMSValue("relationship direction", string);
        if (!RELATIONSHIP_DIRECTIONS.contains(string)) {
            throw new InvalidDDMSException("The direction attribute must be one of " + RELATIONSHIP_DIRECTIONS);
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), RelatedResource.getName(this.getDDMSVersion()));
        Util.requireDDMSValue("relationship attribute", this.getRelationship());
        Util.requireDDMSValidURI(this.getRelationship());
        if (!Util.isEmpty(this.getDirection())) {
            RelatedResource.validateRelationshipDirection(this.getDirection());
        }
        Util.requireDDMSValue("qualifier attribute", this.getQualifier());
        Util.requireDDMSValue("value attribute", this.getValue());
        Util.requireDDMSValidURI(this.getQualifier());
        if (this.getLinks().isEmpty()) {
            throw new InvalidDDMSException("At least 1 link must exist.");
        }
        for (Link link : this.getLinks()) {
            if (link.getSecurityAttributes().isEmpty()) continue;
            throw new InvalidDDMSException("Security attributes cannot be applied to links in a related resource.");
        }
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        Elements elements;
        if (!this.getDDMSVersion().isAtLeast("4.0.1") && (elements = this.getXOMElement().getChildElements(OLD_INNER_NAME, this.getNamespace())).size() > 1) {
            this.addWarning("A ddms:RelatedResources element contains more than 1 ddms:relatedResource. To ensure consistency between versions of DDMS, each ddms:RelatedResources element should contain only 1 ddms:RelatedResource. DDMSence will only process the first child.");
        }
        super.validateWarnings();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        if (!DDMSVersion.getCurrentVersion().isAtLeast("4.0.1")) {
            string3 = string3 + "RelatedResource.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(RelatedResource.buildOutput(bl, string3 + RELATIONSHIP_NAME, this.getRelationship()));
        stringBuffer.append(RelatedResource.buildOutput(bl, string3 + DIRECTION_NAME, this.getDirection()));
        stringBuffer.append(RelatedResource.buildOutput(bl, string3 + "qualifier", this.getQualifier()));
        stringBuffer.append(RelatedResource.buildOutput(bl, string3 + "value", this.getValue()));
        stringBuffer.append(this.buildOutput(bl, string3, this.getLinks()));
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.addAll(this.getLinks());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof RelatedResource)) {
            return false;
        }
        RelatedResource relatedResource = (RelatedResource)object;
        return this.getRelationship().equals(relatedResource.getRelationship()) && this.getDirection().equals(relatedResource.getDirection());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getRelationship().hashCode();
        n = 7 * n + this.getDirection().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return dDMSVersion.isAtLeast("4.0.1") ? "relatedResource" : "relatedResources";
    }

    private Element getInnerElement() {
        return this.getDDMSVersion().isAtLeast("4.0.1") ? this.getXOMElement() : this.getChild(OLD_INNER_NAME);
    }

    public List<Link> getLinks() {
        return Collections.unmodifiableList(this._links);
    }

    public String getRelationship() {
        return this.getAttributeValue(RELATIONSHIP_NAME);
    }

    public String getDirection() {
        return this.getAttributeValue(DIRECTION_NAME);
    }

    @Override
    public String getQualifier() {
        Element element = this.getInnerElement();
        String string = element.getAttributeValue("qualifier", this.getNamespace());
        return Util.getNonNullString(string);
    }

    @Override
    public String getValue() {
        Element element = this.getInnerElement();
        String string = element.getAttributeValue("value", this.getNamespace());
        return Util.getNonNullString(string);
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    static {
        RELATIONSHIP_DIRECTIONS.add(INBOUND_DIRECTION);
        RELATIONSHIP_DIRECTIONS.add(OUTBOUND_DIRECTION);
        RELATIONSHIP_DIRECTIONS.add(BIDRECTIONAL_DIRECTION);
    }

    public static class Builder
    extends AbstractQualifierValue.Builder {
        private static final long serialVersionUID = 5430464017408842022L;
        private String _relationship;
        private String _direction;
        private List<Link.Builder> _links;
        private SecurityAttributes.Builder _securityAttributes;

        public Builder() {
        }

        public Builder(RelatedResource relatedResource) {
            super(relatedResource);
            this.setRelationship(relatedResource.getRelationship());
            this.setDirection(relatedResource.getDirection());
            for (Link link : relatedResource.getLinks()) {
                this.getLinks().add(new Link.Builder(link));
            }
            this.setSecurityAttributes(new SecurityAttributes.Builder(relatedResource.getSecurityAttributes()));
        }

        @Override
        public RelatedResource commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<Link> arrayList = new ArrayList<Link>();
            for (Link.Builder builder : this.getLinks()) {
                Link link = builder.commit();
                if (link == null) continue;
                arrayList.add(link);
            }
            return new RelatedResource(arrayList, this.getRelationship(), this.getDirection(), this.getQualifier(), this.getValue(), this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (IBuilder iBuilder : this.getLinks()) {
                bl = bl || !iBuilder.isEmpty();
            }
            return super.isEmpty() && !bl && Util.isEmpty(this.getRelationship()) && Util.isEmpty(this.getDirection()) && this.getSecurityAttributes().isEmpty();
        }

        public List<Link.Builder> getLinks() {
            if (this._links == null) {
                this._links = new LazyList(Link.Builder.class);
            }
            return this._links;
        }

        public String getRelationship() {
            return this._relationship;
        }

        public void setRelationship(String string) {
            this._relationship = string;
        }

        public String getDirection() {
            return this._direction;
        }

        public void setDirection(String string) {
            this._direction = string;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

