/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import nu.xom.Element;

public final class ProductionMetric
extends AbstractBaseComponent {
    private SecurityAttributes _securityAttributes = null;
    private static final String SUBJECT_NAME = "subject";
    private static final String COVERAGE_NAME = "coverage";

    public ProductionMetric(Element element) throws InvalidDDMSException {
        try {
            this._securityAttributes = new SecurityAttributes(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public ProductionMetric(String string, String string2, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        try {
            Element element = Util.buildDDMSElement(ProductionMetric.getName(DDMSVersion.getCurrentVersion()), null);
            Util.addDDMSAttribute(element, SUBJECT_NAME, string);
            Util.addDDMSAttribute(element, COVERAGE_NAME, string2);
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), ProductionMetric.getName(this.getDDMSVersion()));
        Util.requireDDMSValue("subject attribute", this.getSubject());
        Util.requireDDMSValue("coverage attribute", this.getCoverage());
        this.requireVersion("4.0.1");
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ProductionMetric.buildOutput(bl, string3 + SUBJECT_NAME, this.getSubject()));
        stringBuffer.append(ProductionMetric.buildOutput(bl, string3 + COVERAGE_NAME, this.getCoverage()));
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof ProductionMetric)) {
            return false;
        }
        ProductionMetric productionMetric = (ProductionMetric)object;
        return this.getSubject().equals(productionMetric.getSubject()) && this.getCoverage().equals(productionMetric.getCoverage());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getSubject().hashCode();
        n = 7 * n + this.getCoverage().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "productionMetric";
    }

    public String getSubject() {
        return this.getAttributeValue(SUBJECT_NAME);
    }

    public String getCoverage() {
        return this.getAttributeValue(COVERAGE_NAME);
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = -9012648230977148516L;
        private String _subject;
        private String _coverage;
        private SecurityAttributes.Builder _securityAttributes;

        public Builder() {
        }

        public Builder(ProductionMetric productionMetric) {
            this.setSubject(productionMetric.getSubject());
            this.setCoverage(productionMetric.getCoverage());
            this.setSecurityAttributes(new SecurityAttributes.Builder(productionMetric.getSecurityAttributes()));
        }

        @Override
        public ProductionMetric commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new ProductionMetric(this.getSubject(), this.getCoverage(), this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            return Util.isEmpty(this.getSubject()) && Util.isEmpty(this.getCoverage()) && this.getSecurityAttributes().isEmpty();
        }

        public String getSubject() {
            return this._subject;
        }

        public void setSubject(String string) {
            this._subject = string;
        }

        public String getCoverage() {
            return this._coverage;
        }

        public void setCoverage(String string) {
            this._coverage = string;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

