/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.summary.CountryCode;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;

public final class PostalAddress
extends AbstractBaseComponent {
    private List<String> _streets = null;
    private String _city = null;
    private String _state = null;
    private String _province = null;
    private String _postalCode = null;
    private CountryCode _countryCode = null;
    private static final String STREET_NAME = "street";
    private static final String CITY_NAME = "city";
    private static final String STATE_NAME = "state";
    private static final String PROVINCE_NAME = "province";
    private static final String POSTAL_CODE_NAME = "postalCode";

    public PostalAddress(Element element) throws InvalidDDMSException {
        try {
            Element element2;
            Element element3;
            Element element4;
            Element element5;
            this.setXOMElement(element, false);
            this._streets = Util.getDDMSChildValues(element, STREET_NAME);
            Element element6 = element.getFirstChildElement(CITY_NAME, this.getNamespace());
            if (element6 != null) {
                this._city = element6.getValue();
            }
            if ((element5 = element.getFirstChildElement(STATE_NAME, this.getNamespace())) != null) {
                this._state = element5.getValue();
            }
            if ((element4 = element.getFirstChildElement(PROVINCE_NAME, this.getNamespace())) != null) {
                this._province = element4.getValue();
            }
            if ((element3 = element.getFirstChildElement(POSTAL_CODE_NAME, this.getNamespace())) != null) {
                this._postalCode = element3.getValue();
            }
            if ((element2 = element.getFirstChildElement(CountryCode.getName(this.getDDMSVersion()), this.getNamespace())) != null) {
                this._countryCode = new CountryCode(element2);
            }
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public PostalAddress(List<String> list, String string, String string2, String string3, CountryCode countryCode, boolean bl) throws InvalidDDMSException {
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            Element element = Util.buildDDMSElement(PostalAddress.getName(DDMSVersion.getCurrentVersion()), null);
            for (String string4 : list) {
                element.appendChild((Node)Util.buildDDMSElement(STREET_NAME, string4));
            }
            Util.addDDMSChildElement(element, CITY_NAME, string);
            if (bl) {
                Util.addDDMSChildElement(element, STATE_NAME, string2);
            } else {
                Util.addDDMSChildElement(element, PROVINCE_NAME, string2);
            }
            Util.addDDMSChildElement(element, POSTAL_CODE_NAME, string3);
            if (countryCode != null) {
                element.appendChild((Node)countryCode.getXOMElementCopy());
            }
            this._streets = list;
            this._city = string;
            this._state = bl ? string2 : "";
            this._province = bl ? "" : string2;
            this._postalCode = string3;
            this._countryCode = countryCode;
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), PostalAddress.getName(this.getDDMSVersion()));
        if (!Util.isEmpty(this.getState()) && !Util.isEmpty(this.getProvince())) {
            throw new InvalidDDMSException("Only 1 of state or province can be used.");
        }
        Util.requireBoundedChildCount(this.getXOMElement(), STREET_NAME, 0, 6);
        Util.requireBoundedChildCount(this.getXOMElement(), CITY_NAME, 0, 1);
        Util.requireBoundedChildCount(this.getXOMElement(), STATE_NAME, 0, 1);
        Util.requireBoundedChildCount(this.getXOMElement(), PROVINCE_NAME, 0, 1);
        Util.requireBoundedChildCount(this.getXOMElement(), POSTAL_CODE_NAME, 0, 1);
        Util.requireBoundedChildCount(this.getXOMElement(), CountryCode.getName(this.getDDMSVersion()), 0, 1);
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (this.getStreets().isEmpty() && Util.isEmpty(this.getCity()) && Util.isEmpty(this.getState()) && Util.isEmpty(this.getProvince()) && Util.isEmpty(this.getPostalCode()) && this.getCountryCode() == null) {
            this.addWarning("A completely empty ddms:postalAddress element was found.");
        }
        super.validateWarnings();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.buildOutput(bl, string3 + STREET_NAME, this.getStreets()));
        stringBuffer.append(PostalAddress.buildOutput(bl, string3 + CITY_NAME, this.getCity()));
        stringBuffer.append(PostalAddress.buildOutput(bl, string3 + STATE_NAME, this.getState()));
        stringBuffer.append(PostalAddress.buildOutput(bl, string3 + PROVINCE_NAME, this.getProvince()));
        stringBuffer.append(PostalAddress.buildOutput(bl, string3 + POSTAL_CODE_NAME, this.getPostalCode()));
        if (this.getCountryCode() != null) {
            stringBuffer.append(this.getCountryCode().getOutput(bl, string3, ""));
        }
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.add(this.getCountryCode());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof PostalAddress)) {
            return false;
        }
        PostalAddress postalAddress = (PostalAddress)object;
        return Util.listEquals(this.getStreets(), postalAddress.getStreets()) && this.getCity().equals(postalAddress.getCity()) && this.getState().equals(postalAddress.getState()) && this.getProvince().equals(postalAddress.getProvince()) && this.getPostalCode().equals(postalAddress.getPostalCode());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getStreets().hashCode();
        n = 7 * n + this.getCity().hashCode();
        n = 7 * n + this.getState().hashCode();
        n = 7 * n + this.getProvince().hashCode();
        n = 7 * n + this.getPostalCode().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "postalAddress";
    }

    public List<String> getStreets() {
        return Collections.unmodifiableList(this._streets);
    }

    public String getCity() {
        return Util.getNonNullString(this._city);
    }

    public String getState() {
        return Util.getNonNullString(this._state);
    }

    public String getProvince() {
        return Util.getNonNullString(this._province);
    }

    public String getPostalCode() {
        return Util.getNonNullString(this._postalCode);
    }

    public CountryCode getCountryCode() {
        return this._countryCode;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 6887962646280796652L;
        private List<String> _streets;
        private String _city;
        private String _state;
        private String _province;
        private String _postalCode;
        private CountryCode.Builder _countryCode;

        public Builder() {
        }

        public Builder(PostalAddress postalAddress) {
            this.setStreets(postalAddress.getStreets());
            this.setCity(postalAddress.getCity());
            this.setState(postalAddress.getState());
            this.setProvince(postalAddress.getProvince());
            this.setPostalCode(postalAddress.getPostalCode());
            if (postalAddress.getCountryCode() != null) {
                this.setCountryCode(new CountryCode.Builder(postalAddress.getCountryCode()));
            }
        }

        @Override
        public PostalAddress commit() throws InvalidDDMSException {
            boolean bl;
            if (this.isEmpty()) {
                return null;
            }
            boolean bl2 = bl = !Util.isEmpty(this.getState()) && !Util.isEmpty(this.getProvince());
            if (bl) {
                throw new InvalidDDMSException("Only 1 of state or province can be used.");
            }
            boolean bl3 = !Util.isEmpty(this.getState());
            String string = bl3 ? this.getState() : this.getProvince();
            return new PostalAddress(this.getStreets(), this.getCity(), string, this.getPostalCode(), this.getCountryCode().commit(), bl3);
        }

        @Override
        public boolean isEmpty() {
            return Util.containsOnlyEmptyValues(this.getStreets()) && Util.isEmpty(this.getCity()) && Util.isEmpty(this.getState()) && Util.isEmpty(this.getProvince()) && Util.isEmpty(this.getPostalCode()) && this.getCountryCode().isEmpty();
        }

        public List<String> getStreets() {
            if (this._streets == null) {
                this._streets = new LazyList(String.class);
            }
            return this._streets;
        }

        public void setStreets(List<String> list) {
            this._streets = new LazyList(list, String.class);
        }

        public String getCity() {
            return this._city;
        }

        public void setCity(String string) {
            this._city = string;
        }

        public String getState() {
            return this._state;
        }

        public void setState(String string) {
            this._state = string;
        }

        public String getProvince() {
            return this._province;
        }

        public void setProvince(String string) {
            this._province = string;
        }

        public String getPostalCode() {
            return this._postalCode;
        }

        public void setPostalCode(String string) {
            this._postalCode = string;
        }

        public CountryCode.Builder getCountryCode() {
            if (this._countryCode == null) {
                this._countryCode = new CountryCode.Builder();
            }
            return this._countryCode;
        }

        public void setCountryCode(CountryCode.Builder builder) {
            this._countryCode = builder;
        }
    }
}

