/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractSimpleString;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import nu.xom.Element;

public final class NonStateActor
extends AbstractSimpleString {
    private static final String ORDER_NAME = "order";
    private static final String QUALIFIER_NAME = "qualifier";

    public NonStateActor(Element element) throws InvalidDDMSException {
        super(element, true);
    }

    public NonStateActor(String string, Integer n, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        this(string, n, null, securityAttributes);
    }

    public NonStateActor(String string, Integer n, String string2, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        super(NonStateActor.getName(DDMSVersion.getCurrentVersion()), string, securityAttributes, false);
        try {
            if (n != null) {
                Util.addDDMSAttribute(this.getXOMElement(), ORDER_NAME, n.toString());
            }
            if (!Util.isEmpty(string2)) {
                Util.addDDMSAttribute(this.getXOMElement(), QUALIFIER_NAME, string2);
            }
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), NonStateActor.getName(this.getDDMSVersion()));
        if (!Util.isEmpty(this.getQualifier())) {
            Util.requireDDMSValidURI(this.getQualifier());
        }
        this.requireVersion("4.0.1");
        this.validateWarnings();
    }

    @Override
    protected void validateWarnings() {
        if (Util.isEmpty(this.getValue())) {
            this.addWarning("A ddms:" + this.getName() + " element was found with no value.");
        }
        if (!Util.isEmpty(this.getQualifier())) {
            this.addDdms40Warning("ddms:qualifier attribute");
        }
        super.validateWarnings();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NonStateActor.buildOutput(bl, string3 + "value", this.getValue()));
        stringBuffer.append(NonStateActor.buildOutput(bl, string3 + ORDER_NAME, String.valueOf(this.getOrder())));
        stringBuffer.append(NonStateActor.buildOutput(bl, string3 + QUALIFIER_NAME, this.getQualifier()));
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof NonStateActor)) {
            return false;
        }
        NonStateActor nonStateActor = (NonStateActor)object;
        return this.getOrder().equals(nonStateActor.getOrder()) && this.getQualifier().equals(nonStateActor.getQualifier());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getOrder().hashCode();
        n = 7 * n + this.getQualifier().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "nonStateActor";
    }

    public Integer getOrder() {
        String string = this.getAttributeValue(ORDER_NAME);
        return Util.isEmpty(string) ? null : Integer.valueOf(string);
    }

    public String getQualifier() {
        return this.getAttributeValue(QUALIFIER_NAME);
    }

    public static class Builder
    extends AbstractSimpleString.Builder {
        private static final long serialVersionUID = 7750664735441105296L;
        private Integer _order;
        private String _qualifier;

        public Builder() {
        }

        public Builder(NonStateActor nonStateActor) {
            super(nonStateActor);
            this.setOrder(nonStateActor.getOrder());
            this.setQualifier(nonStateActor.getQualifier());
        }

        @Override
        public NonStateActor commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new NonStateActor(this.getValue(), this.getOrder(), this.getQualifier(), this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && this.getOrder() == null && Util.isEmpty(this.getQualifier());
        }

        public Integer getOrder() {
            return this._order;
        }

        public String getQualifier() {
            return this._qualifier;
        }

        public void setQualifier(String string) {
            this._qualifier = string;
        }

        public void setOrder(Integer n) {
            this._order = n;
        }
    }
}

