/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.ddms.summary.xlink.XLinkAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import nu.xom.Element;

public final class Link
extends AbstractBaseComponent {
    private XLinkAttributes _xlinkAttributes = null;
    private SecurityAttributes _securityAttributes = null;
    private static final String FIXED_TYPE = "locator";

    public Link(Element element) throws InvalidDDMSException {
        try {
            this._xlinkAttributes = new XLinkAttributes(element);
            this._securityAttributes = new SecurityAttributes(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public Link(XLinkAttributes xLinkAttributes) throws InvalidDDMSException {
        this(xLinkAttributes, null);
    }

    public Link(XLinkAttributes xLinkAttributes, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        try {
            Element element = Util.buildDDMSElement(Link.getName(DDMSVersion.getCurrentVersion()), null);
            this._xlinkAttributes = XLinkAttributes.getNonNullInstance(xLinkAttributes);
            this._xlinkAttributes.addTo(element);
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), Link.getName(this.getDDMSVersion()));
        Util.requireDDMSValue("type attribute", this.getXLinkAttributes().getType());
        Util.requireDDMSValue("href attribute", this.getXLinkAttributes().getHref());
        if (!this.getXLinkAttributes().getType().equals(FIXED_TYPE)) {
            throw new InvalidDDMSException("The type attribute must have a fixed value of \"locator\".");
        }
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (this.getXLinkAttributes() != null) {
            this.addWarnings(this.getXLinkAttributes().getValidationWarnings(), true);
        }
        super.validateWarnings();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getXLinkAttributes().getOutput(bl, string3));
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof Link)) {
            return false;
        }
        Link link = (Link)object;
        return this.getXLinkAttributes().equals(link.getXLinkAttributes());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getXLinkAttributes().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "link";
    }

    public XLinkAttributes getXLinkAttributes() {
        return this._xlinkAttributes;
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 4325950371570699184L;
        private XLinkAttributes.Builder _xlinkAttributes;
        private SecurityAttributes.Builder _securityAttributes;

        public Builder() {
        }

        public Builder(Link link) {
            this.setXLinkAttributes(new XLinkAttributes.Builder(link.getXLinkAttributes()));
            this.setSecurityAttributes(new SecurityAttributes.Builder(link.getSecurityAttributes()));
        }

        @Override
        public Link commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new Link(this.getXLinkAttributes().commit(), this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            return this.getXLinkAttributes().isEmpty() && this.getSecurityAttributes().isEmpty();
        }

        public XLinkAttributes.Builder getXLinkAttributes() {
            if (this._xlinkAttributes == null) {
                this._xlinkAttributes = new XLinkAttributes.Builder();
            }
            return this._xlinkAttributes;
        }

        public void setXLinkAttributes(XLinkAttributes.Builder builder) {
            this._xlinkAttributes = builder;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

