/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.extensible.ExtensibleAttributes;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import nu.xom.Element;

public final class Keyword
extends AbstractBaseComponent {
    private SecurityAttributes _securityAttributes = null;
    private ExtensibleAttributes _extensibleAttributes = null;
    private static final String VALUE_NAME = "value";

    public Keyword(Element element) throws InvalidDDMSException {
        try {
            this._securityAttributes = new SecurityAttributes(element);
            this._extensibleAttributes = new ExtensibleAttributes(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public Keyword(String string, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        this(string, securityAttributes, null);
    }

    public Keyword(String string, SecurityAttributes securityAttributes, ExtensibleAttributes extensibleAttributes) throws InvalidDDMSException {
        try {
            Element element = Util.buildDDMSElement(Keyword.getName(DDMSVersion.getCurrentVersion()), null);
            Util.addDDMSAttribute(element, VALUE_NAME, string);
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this._extensibleAttributes = ExtensibleAttributes.getNonNullInstance(extensibleAttributes);
            this._extensibleAttributes.addTo(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), Keyword.getName(this.getDDMSVersion()));
        Util.requireDDMSValue("value attribute", this.getValue());
        if (!this.getDDMSVersion().isAtLeast("4.0.1") && !this.getSecurityAttributes().isEmpty()) {
            throw new InvalidDDMSException("Security attributes cannot be applied to this component until DDMS 4.0.1 or later.");
        }
        if (!this.getDDMSVersion().isAtLeast("3.0") && !this.getExtensibleAttributes().isEmpty()) {
            throw new InvalidDDMSException("xs:anyAttribute cannot be applied to ddms:keyword until DDMS 3.0 or later.");
        }
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Keyword.buildOutput(bl, string3, this.getValue()));
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3 + "."));
        stringBuffer.append(this.getExtensibleAttributes().getOutput(bl, string3 + "."));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof Keyword)) {
            return false;
        }
        Keyword keyword = (Keyword)object;
        return this.getValue().equals(keyword.getValue()) && this.getExtensibleAttributes().equals(keyword.getExtensibleAttributes());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getValue().hashCode();
        n = 7 * n + this.getExtensibleAttributes().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "keyword";
    }

    public String getValue() {
        return this.getAttributeValue(VALUE_NAME);
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public ExtensibleAttributes getExtensibleAttributes() {
        return this._extensibleAttributes;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 5165722850252388155L;
        private String _value;
        private SecurityAttributes.Builder _securityAttributes;
        private ExtensibleAttributes.Builder _extensibleAttributes;

        public Builder() {
        }

        public Builder(Keyword keyword) {
            this.setValue(keyword.getValue());
            this.setSecurityAttributes(new SecurityAttributes.Builder(keyword.getSecurityAttributes()));
            this.setExtensibleAttributes(new ExtensibleAttributes.Builder(keyword.getExtensibleAttributes()));
        }

        @Override
        public Keyword commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new Keyword(this.getValue(), this.getSecurityAttributes().commit(), this.getExtensibleAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            return Util.isEmpty(this.getValue()) && this.getSecurityAttributes().isEmpty() && this.getExtensibleAttributes().isEmpty();
        }

        public String getValue() {
            return this._value;
        }

        public void setValue(String string) {
            this._value = string;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }

        public ExtensibleAttributes.Builder getExtensibleAttributes() {
            if (this._extensibleAttributes == null) {
                this._extensibleAttributes = new ExtensibleAttributes.Builder();
            }
            return this._extensibleAttributes;
        }

        public void setExtensibleAttributes(ExtensibleAttributes.Builder builder) {
            this._extensibleAttributes = builder;
        }
    }
}

