/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.extensible.ExtensibleAttributes;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import nu.xom.Element;

public final class Category
extends AbstractBaseComponent {
    private SecurityAttributes _securityAttributes = null;
    private ExtensibleAttributes _extensibleAttributes = null;
    private static final String QUALIFIER_NAME = "qualifier";
    private static final String CODE_NAME = "code";
    private static final String LABEL_NAME = "label";

    public Category(Element element) throws InvalidDDMSException {
        try {
            this._securityAttributes = new SecurityAttributes(element);
            this._extensibleAttributes = new ExtensibleAttributes(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public Category(String string, String string2, String string3, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        this(string, string2, string3, securityAttributes, null);
    }

    public Category(String string, String string2, String string3, SecurityAttributes securityAttributes, ExtensibleAttributes extensibleAttributes) throws InvalidDDMSException {
        try {
            Element element = Util.buildDDMSElement(Category.getName(DDMSVersion.getCurrentVersion()), null);
            Util.addDDMSAttribute(element, QUALIFIER_NAME, string);
            Util.addDDMSAttribute(element, CODE_NAME, string2);
            Util.addDDMSAttribute(element, LABEL_NAME, string3);
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this._extensibleAttributes = ExtensibleAttributes.getNonNullInstance(extensibleAttributes);
            this._extensibleAttributes.addTo(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), Category.getName(this.getDDMSVersion()));
        Util.requireDDMSValue("label attribute", this.getLabel());
        if (!Util.isEmpty(this.getQualifier())) {
            Util.requireDDMSValidURI(this.getQualifier());
        }
        if (!this.getDDMSVersion().isAtLeast("4.0.1") && !this.getSecurityAttributes().isEmpty()) {
            throw new InvalidDDMSException("Security attributes cannot be applied to this component until DDMS 4.0.1 or later.");
        }
        if (!this.getDDMSVersion().isAtLeast("3.0") && !this.getExtensibleAttributes().isEmpty()) {
            throw new InvalidDDMSException("xs:anyAttribute cannot be applied to ddms:category until DDMS 3.0 or later.");
        }
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Category.buildOutput(bl, string3 + QUALIFIER_NAME, this.getQualifier()));
        stringBuffer.append(Category.buildOutput(bl, string3 + CODE_NAME, this.getCode()));
        stringBuffer.append(Category.buildOutput(bl, string3 + LABEL_NAME, this.getLabel()));
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        stringBuffer.append(this.getExtensibleAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof Category)) {
            return false;
        }
        Category category = (Category)object;
        return this.getQualifier().equals(category.getQualifier()) && this.getCode().equals(category.getCode()) && this.getLabel().equals(category.getLabel()) && this.getExtensibleAttributes().equals(category.getExtensibleAttributes());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getQualifier().hashCode();
        n = 7 * n + this.getCode().hashCode();
        n = 7 * n + this.getLabel().hashCode();
        n = 7 * n + this.getExtensibleAttributes().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "category";
    }

    public String getQualifier() {
        return this.getAttributeValue(QUALIFIER_NAME);
    }

    public String getCode() {
        return this.getAttributeValue(CODE_NAME);
    }

    public String getLabel() {
        return this.getAttributeValue(LABEL_NAME);
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public ExtensibleAttributes getExtensibleAttributes() {
        return this._extensibleAttributes;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = -9012648230977148516L;
        private String _qualifier;
        private String _code;
        private String _label;
        private SecurityAttributes.Builder _securityAttributes;
        private ExtensibleAttributes.Builder _extensibleAttributes;

        public Builder() {
        }

        public Builder(Category category) {
            this.setQualifier(category.getQualifier());
            this.setCode(category.getCode());
            this.setLabel(category.getLabel());
            this.setSecurityAttributes(new SecurityAttributes.Builder(category.getSecurityAttributes()));
            this.setExtensibleAttributes(new ExtensibleAttributes.Builder(category.getExtensibleAttributes()));
        }

        @Override
        public Category commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new Category(this.getQualifier(), this.getCode(), this.getLabel(), this.getSecurityAttributes().commit(), this.getExtensibleAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            return Util.isEmpty(this.getQualifier()) && Util.isEmpty(this.getCode()) && Util.isEmpty(this.getLabel()) && this.getSecurityAttributes().isEmpty() && this.getExtensibleAttributes().isEmpty();
        }

        public String getQualifier() {
            return this._qualifier;
        }

        public void setQualifier(String string) {
            this._qualifier = string;
        }

        public String getCode() {
            return this._code;
        }

        public void setCode(String string) {
            this._code = string;
        }

        public String getLabel() {
            return this._label;
        }

        public void setLabel(String string) {
            this._label = string;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }

        public ExtensibleAttributes.Builder getExtensibleAttributes() {
            if (this._extensibleAttributes == null) {
                this._extensibleAttributes = new ExtensibleAttributes.Builder();
            }
            return this._extensibleAttributes;
        }

        public void setExtensibleAttributes(ExtensibleAttributes.Builder builder) {
            this._extensibleAttributes = builder;
        }
    }
}

