/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.summary.gml.Point;
import buri.ddmsence.ddms.summary.gml.Polygon;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public final class BoundingGeometry
extends AbstractBaseComponent {
    private List<Polygon> _polygons = null;
    private List<Point> _points = null;

    public BoundingGeometry(Element element) throws InvalidDDMSException {
        try {
            Util.requireDDMSValue("boundingGeometry element", element);
            this.setXOMElement(element, false);
            String string = this.getDDMSVersion().getGmlNamespace();
            this._polygons = new ArrayList<Polygon>();
            this._points = new ArrayList<Point>();
            Elements elements = element.getChildElements(Polygon.getName(this.getDDMSVersion()), string);
            for (int i = 0; i < elements.size(); ++i) {
                this._polygons.add(new Polygon(elements.get(i)));
            }
            Elements elements2 = element.getChildElements(Point.getName(this.getDDMSVersion()), string);
            for (int i = 0; i < elements2.size(); ++i) {
                this._points.add(new Point(elements2.get(i)));
            }
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public BoundingGeometry(List<Polygon> list, List<Point> list2) throws InvalidDDMSException {
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            if (list2 == null) {
                list2 = Collections.emptyList();
            }
            Element element = Util.buildDDMSElement(BoundingGeometry.getName(DDMSVersion.getCurrentVersion()), null);
            for (Polygon abstractBaseComponent : list) {
                element.appendChild((Node)abstractBaseComponent.getXOMElementCopy());
            }
            for (Point point : list2) {
                element.appendChild((Node)point.getXOMElementCopy());
            }
            this._polygons = list;
            this._points = list2;
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), BoundingGeometry.getName(this.getDDMSVersion()));
        if (this.getPolygons().size() + this.getPoints().size() == 0) {
            throw new InvalidDDMSException("At least 1 of Polygon or Point must be used.");
        }
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.buildOutput(bl, string3, this.getPolygons()));
        stringBuffer.append(this.buildOutput(bl, string3, this.getPoints()));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.addAll(this.getPoints());
        arrayList.addAll(this.getPolygons());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof BoundingGeometry;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "boundingGeometry";
    }

    public List<Polygon> getPolygons() {
        return Collections.unmodifiableList(this._polygons);
    }

    public List<Point> getPoints() {
        return Collections.unmodifiableList(this._points);
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = -5734267242408462644L;
        private List<Polygon.Builder> _polygons;
        private List<Point.Builder> _points;

        public Builder() {
        }

        public Builder(BoundingGeometry boundingGeometry) {
            for (Polygon abstractBaseComponent : boundingGeometry.getPolygons()) {
                this.getPolygons().add(new Polygon.Builder(abstractBaseComponent));
            }
            for (Point point : boundingGeometry.getPoints()) {
                this.getPoints().add(new Point.Builder(point));
            }
        }

        @Override
        public BoundingGeometry commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<Polygon> arrayList = new ArrayList<Polygon>();
            for (Polygon.Builder object : this.getPolygons()) {
                Polygon polygon = object.commit();
                if (polygon == null) continue;
                arrayList.add(polygon);
            }
            ArrayList arrayList2 = new ArrayList();
            for (Point.Builder builder : this.getPoints()) {
                Point point = builder.commit();
                if (point == null) continue;
                arrayList2.add(point);
            }
            return new BoundingGeometry(arrayList, arrayList2);
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (IBuilder iBuilder : this.getChildBuilders()) {
                bl = bl || !iBuilder.isEmpty();
            }
            return !bl;
        }

        private List<IBuilder> getChildBuilders() {
            ArrayList<IBuilder> arrayList = new ArrayList<IBuilder>();
            arrayList.addAll(this.getPolygons());
            arrayList.addAll(this.getPoints());
            return arrayList;
        }

        public List<Polygon.Builder> getPolygons() {
            if (this._polygons == null) {
                this._polygons = new LazyList(Polygon.Builder.class);
            }
            return this._polygons;
        }

        public List<Point.Builder> getPoints() {
            if (this._points == null) {
                this._points = new LazyList(Point.Builder.class);
            }
            return this._points;
        }
    }
}

