/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.summary;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import nu.xom.Element;
import nu.xom.Node;

public final class BoundingBox
extends AbstractBaseComponent {
    private Double _westBL = null;
    private Double _eastBL = null;
    private Double _southBL = null;
    private Double _northBL = null;

    public BoundingBox(Element element) throws InvalidDDMSException {
        try {
            Util.requireDDMSValue("boundingBox element", element);
            this.setXOMElement(element, false);
            this._westBL = BoundingBox.getChildTextAsDouble(element, this.getWestBLName());
            this._eastBL = BoundingBox.getChildTextAsDouble(element, this.getEastBLName());
            this._southBL = BoundingBox.getChildTextAsDouble(element, this.getSouthBLName());
            this._northBL = BoundingBox.getChildTextAsDouble(element, this.getNorthBLName());
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public BoundingBox(double d, double d2, double d3, double d4) throws InvalidDDMSException {
        try {
            Element element = Util.buildDDMSElement(BoundingBox.getName(DDMSVersion.getCurrentVersion()), null);
            this.setXOMElement(element, false);
            element.appendChild((Node)Util.buildDDMSElement(this.getWestBLName(), String.valueOf(d)));
            element.appendChild((Node)Util.buildDDMSElement(this.getEastBLName(), String.valueOf(d2)));
            element.appendChild((Node)Util.buildDDMSElement(this.getSouthBLName(), String.valueOf(d3)));
            element.appendChild((Node)Util.buildDDMSElement(this.getNorthBLName(), String.valueOf(d4)));
            this._westBL = d;
            this._eastBL = d2;
            this._southBL = d3;
            this._northBL = d4;
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), BoundingBox.getName(this.getDDMSVersion()));
        Util.requireDDMSValue("westbound longitude", this.getWestBL());
        Util.requireDDMSValue("eastbound longitude", this.getEastBL());
        Util.requireDDMSValue("southbound latitude", this.getSouthBL());
        Util.requireDDMSValue("northbound latitude", this.getNorthBL());
        Util.requireValidLongitude(this.getWestBL());
        Util.requireValidLongitude(this.getEastBL());
        Util.requireValidLatitude(this.getSouthBL());
        Util.requireValidLatitude(this.getNorthBL());
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BoundingBox.buildOutput(bl, string3 + this.getWestBLName(), String.valueOf(this.getWestBL())));
        stringBuffer.append(BoundingBox.buildOutput(bl, string3 + this.getEastBLName(), String.valueOf(this.getEastBL())));
        stringBuffer.append(BoundingBox.buildOutput(bl, string3 + this.getSouthBLName(), String.valueOf(this.getSouthBL())));
        stringBuffer.append(BoundingBox.buildOutput(bl, string3 + this.getNorthBLName(), String.valueOf(this.getNorthBL())));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof BoundingBox)) {
            return false;
        }
        BoundingBox boundingBox = (BoundingBox)object;
        return this.getWestBL().equals(boundingBox.getWestBL()) && this.getEastBL().equals(boundingBox.getEastBL()) && this.getSouthBL().equals(boundingBox.getSouthBL()) && this.getNorthBL().equals(boundingBox.getNorthBL());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getWestBL().hashCode();
        n = 7 * n + this.getEastBL().hashCode();
        n = 7 * n + this.getSouthBL().hashCode();
        n = 7 * n + this.getNorthBL().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "boundingBox";
    }

    private String getWestBLName() {
        return this.getDDMSVersion().isAtLeast("4.0.1") ? "westBL" : "WestBL";
    }

    private String getEastBLName() {
        return this.getDDMSVersion().isAtLeast("4.0.1") ? "eastBL" : "EastBL";
    }

    private String getSouthBLName() {
        return this.getDDMSVersion().isAtLeast("4.0.1") ? "southBL" : "SouthBL";
    }

    private String getNorthBLName() {
        return this.getDDMSVersion().isAtLeast("4.0.1") ? "northBL" : "NorthBL";
    }

    public Double getWestBL() {
        return this._westBL;
    }

    public Double getEastBL() {
        return this._eastBL;
    }

    public Double getSouthBL() {
        return this._southBL;
    }

    public Double getNorthBL() {
        return this._northBL;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = -2364407215439097065L;
        private Double _westBL;
        private Double _eastBL;
        private Double _southBL;
        private Double _northBL;

        public Builder() {
        }

        public Builder(BoundingBox boundingBox) {
            this.setWestBL(boundingBox.getWestBL());
            this.setEastBL(boundingBox.getEastBL());
            this.setSouthBL(boundingBox.getSouthBL());
            this.setNorthBL(boundingBox.getNorthBL());
        }

        @Override
        public BoundingBox commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            if (this.getWestBL() == null || this.getEastBL() == null || this.getSouthBL() == null || this.getNorthBL() == null) {
                throw new InvalidDDMSException("A ddms:boundingBox requires two latitude and two longitude values.");
            }
            return new BoundingBox(this.getWestBL(), this.getEastBL(), this.getSouthBL(), this.getNorthBL());
        }

        @Override
        public boolean isEmpty() {
            return this.getWestBL() == null && this.getEastBL() == null && this.getSouthBL() == null && this.getNorthBL() == null;
        }

        public Double getWestBL() {
            return this._westBL;
        }

        public void setWestBL(Double d) {
            this._westBL = d;
        }

        public Double getEastBL() {
            return this._eastBL;
        }

        public void setEastBL(Double d) {
            this._eastBL = d;
        }

        public Double getSouthBL() {
            return this._southBL;
        }

        public void setSouthBL(Double d) {
            this._southBL = d;
        }

        public Double getNorthBL() {
            return this._northBL;
        }

        public void setNorthBL(Double d) {
            this._northBL = d;
        }
    }
}

