/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.security.ntk;

import buri.ddmsence.AbstractAccessEntity;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.ddms.security.ntk.IndividualValue;
import buri.ddmsence.ddms.security.ntk.SystemName;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public final class Individual
extends AbstractAccessEntity {
    private List<IndividualValue> _individualValues = null;

    public Individual(Element element) throws InvalidDDMSException {
        super(element);
        try {
            Elements elements = element.getChildElements(IndividualValue.getName(this.getDDMSVersion()), this.getNamespace());
            this._individualValues = new ArrayList<IndividualValue>();
            for (int i = 0; i < elements.size(); ++i) {
                this._individualValues.add(new IndividualValue(elements.get(i)));
            }
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public Individual(SystemName systemName, List<IndividualValue> list, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        super(Individual.getName(DDMSVersion.getCurrentVersion()), systemName, securityAttributes);
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            for (IndividualValue individualValue : list) {
                this.getXOMElement().appendChild((Node)individualValue.getXOMElementCopy());
            }
            this._individualValues = list;
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireQName(this.getXOMElement(), this.getNamespace(), Individual.getName(this.getDDMSVersion()));
        if (this.getIndividualValues().isEmpty()) {
            throw new InvalidDDMSException("At least one individual value is required.");
        }
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, "individual", string2) + ".";
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getSystemName() != null) {
            stringBuffer.append(this.getSystemName().getOutput(bl, string3, ""));
        }
        stringBuffer.append(this.buildOutput(bl, string3, this.getIndividualValues()));
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        List<IDDMSComponent> list = super.getNestedComponents();
        list.addAll(this.getIndividualValues());
        return list;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof Individual;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "AccessIndividual";
    }

    public List<IndividualValue> getIndividualValues() {
        return Collections.unmodifiableList(this._individualValues);
    }

    public static class Builder
    extends AbstractAccessEntity.Builder {
        private static final long serialVersionUID = 7851044806424206976L;
        private List<IndividualValue.Builder> _individualValues;

        public Builder() {
        }

        public Builder(Individual individual) {
            super(individual);
            for (IndividualValue individualValue : individual.getIndividualValues()) {
                this.getIndividualValues().add(new IndividualValue.Builder(individualValue));
            }
        }

        @Override
        public Individual commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<IndividualValue> arrayList = new ArrayList<IndividualValue>();
            for (IBuilder iBuilder : this.getIndividualValues()) {
                IndividualValue individualValue = (IndividualValue)iBuilder.commit();
                if (individualValue == null) continue;
                arrayList.add(individualValue);
            }
            return new Individual(this.getSystemName().commit(), arrayList, this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (IBuilder iBuilder : this.getIndividualValues()) {
                bl = bl || !iBuilder.isEmpty();
            }
            return !bl && super.isEmpty();
        }

        public List<IndividualValue.Builder> getIndividualValues() {
            if (this._individualValues == null) {
                this._individualValues = new LazyList(IndividualValue.Builder.class);
            }
            return this._individualValues;
        }
    }
}

