/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.security.ntk;

import buri.ddmsence.AbstractAccessEntity;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.ddms.security.ntk.GroupValue;
import buri.ddmsence.ddms.security.ntk.SystemName;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public final class Group
extends AbstractAccessEntity {
    private List<GroupValue> _groupValues = null;

    public Group(Element element) throws InvalidDDMSException {
        super(element);
        try {
            Elements elements = element.getChildElements(GroupValue.getName(this.getDDMSVersion()), this.getNamespace());
            this._groupValues = new ArrayList<GroupValue>();
            for (int i = 0; i < elements.size(); ++i) {
                this._groupValues.add(new GroupValue(elements.get(i)));
            }
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public Group(SystemName systemName, List<GroupValue> list, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        super(Group.getName(DDMSVersion.getCurrentVersion()), systemName, securityAttributes);
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            for (GroupValue groupValue : list) {
                this.getXOMElement().appendChild((Node)groupValue.getXOMElementCopy());
            }
            this._groupValues = list;
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireQName(this.getXOMElement(), this.getNamespace(), Group.getName(this.getDDMSVersion()));
        if (this.getGroupValues().isEmpty()) {
            throw new InvalidDDMSException("At least one group value is required.");
        }
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, "group", string2) + ".";
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getSystemName() != null) {
            stringBuffer.append(this.getSystemName().getOutput(bl, string3, ""));
        }
        stringBuffer.append(this.buildOutput(bl, string3, this.getGroupValues()));
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        List<IDDMSComponent> list = super.getNestedComponents();
        list.addAll(this.getGroupValues());
        return list;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof Group;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "AccessGroup";
    }

    public List<GroupValue> getGroupValues() {
        return Collections.unmodifiableList(this._groupValues);
    }

    public static class Builder
    extends AbstractAccessEntity.Builder {
        private static final long serialVersionUID = 7851044806424206976L;
        private List<GroupValue.Builder> _groupValues;

        public Builder() {
        }

        public Builder(Group group) {
            super(group);
            for (GroupValue groupValue : group.getGroupValues()) {
                this.getGroupValues().add(new GroupValue.Builder(groupValue));
            }
        }

        @Override
        public Group commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<GroupValue> arrayList = new ArrayList<GroupValue>();
            for (IBuilder iBuilder : this.getGroupValues()) {
                GroupValue groupValue = (GroupValue)iBuilder.commit();
                if (groupValue == null) continue;
                arrayList.add(groupValue);
            }
            return new Group(this.getSystemName().commit(), arrayList, this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (IBuilder iBuilder : this.getGroupValues()) {
                bl = bl || !iBuilder.isEmpty();
            }
            return !bl && super.isEmpty();
        }

        public List<GroupValue.Builder> getGroupValues() {
            if (this._groupValues == null) {
                this._groupValues = new LazyList(GroupValue.Builder.class);
            }
            return this._groupValues;
        }
    }
}

