/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.security.ntk;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.ddms.security.ntk.Group;
import buri.ddmsence.ddms.security.ntk.Individual;
import buri.ddmsence.ddms.security.ntk.ProfileList;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public final class Access
extends AbstractBaseComponent {
    private List<Individual> _individuals = null;
    private List<Group> _groups = null;
    private ProfileList _profileList = null;
    private SecurityAttributes _securityAttributes = null;
    private static final String INDIVIDUAL_LIST_NAME = "AccessIndividualList";
    private static final String GROUP_LIST_NAME = "AccessGroupList";
    private static final String EXTERNAL_REFERENCE_NAME = "externalReference";

    public Access(Element element) throws InvalidDDMSException {
        try {
            Element element2;
            Elements elements;
            this.setXOMElement(element, false);
            this._individuals = new ArrayList<Individual>();
            Element element3 = element.getFirstChildElement(INDIVIDUAL_LIST_NAME, this.getNamespace());
            if (element3 != null) {
                elements = element3.getChildElements();
                for (int i = 0; i < elements.size(); ++i) {
                    this._individuals.add(new Individual(elements.get(i)));
                }
            }
            this._groups = new ArrayList<Group>();
            elements = element.getFirstChildElement(GROUP_LIST_NAME, this.getNamespace());
            if (elements != null) {
                Elements elements2 = elements.getChildElements();
                for (int i = 0; i < elements2.size(); ++i) {
                    this._groups.add(new Group(elements2.get(i)));
                }
            }
            if ((element2 = element.getFirstChildElement(ProfileList.getName(this.getDDMSVersion()), this.getNamespace())) != null) {
                this._profileList = new ProfileList(element2);
            }
            this._securityAttributes = new SecurityAttributes(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public Access(List<Individual> list, List<Group> list2, ProfileList profileList, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        this(list, list2, profileList, null, securityAttributes);
    }

    public Access(List<Individual> list, List<Group> list2, ProfileList profileList, Boolean bl, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        try {
            Element element;
            DDMSVersion dDMSVersion = DDMSVersion.getCurrentVersion();
            String string = PropertyReader.getPrefix("ntk");
            String string2 = dDMSVersion.getNtkNamespace();
            Element element2 = Util.buildElement(string, Access.getName(dDMSVersion), string2, null);
            this.setXOMElement(element2, false);
            if (list == null) {
                list = Collections.emptyList();
            }
            if (!list.isEmpty()) {
                element = Util.buildElement(string, INDIVIDUAL_LIST_NAME, string2, null);
                element2.appendChild((Node)element);
                for (Individual abstractAccessEntity : list) {
                    element.appendChild((Node)abstractAccessEntity.getXOMElementCopy());
                }
            }
            if (list2 == null) {
                list2 = Collections.emptyList();
            }
            if (!list2.isEmpty()) {
                element = Util.buildElement(string, GROUP_LIST_NAME, string2, null);
                element2.appendChild((Node)element);
                for (Group group : list2) {
                    element.appendChild((Node)group.getXOMElementCopy());
                }
            }
            if (profileList != null) {
                element2.appendChild((Node)profileList.getXOMElementCopy());
            }
            if (bl != null) {
                Util.addAttribute(element2, string, EXTERNAL_REFERENCE_NAME, string2, String.valueOf(bl));
            }
            this._individuals = list;
            this._groups = list2;
            this._profileList = profileList;
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element2);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireQName(this.getXOMElement(), this.getNamespace(), Access.getName(this.getDDMSVersion()));
        Util.requireDDMSValue("security attributes", this.getSecurityAttributes());
        this.getSecurityAttributes().requireClassification();
        this.requireVersion("4.0.1");
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (this.getIndividuals().isEmpty() && this.getGroups().isEmpty() && this.getProfileList() == null) {
            this.addWarning("An ntk:Access element was found with no individual, group, or profile information.");
        }
        if (this.isExternalReference() != null) {
            this.addDdms40Warning("ntk:externalReference attribute");
        }
        super.validateWarnings();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, "access", string2) + ".";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.buildOutput(bl, string3 + "individualList.", this.getIndividuals()));
        stringBuffer.append(this.buildOutput(bl, string3 + "groupList.", this.getGroups()));
        if (this.getProfileList() != null) {
            stringBuffer.append(this.getProfileList().getOutput(bl, string3, ""));
        }
        if (this.isExternalReference() != null) {
            stringBuffer.append(Access.buildOutput(bl, string3 + EXTERNAL_REFERENCE_NAME, String.valueOf(this.isExternalReference())));
        }
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.addAll(this.getIndividuals());
        arrayList.addAll(this.getGroups());
        arrayList.add(this.getProfileList());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof Access)) {
            return false;
        }
        Access access = (Access)object;
        return Util.nullEquals(this.isExternalReference(), access.isExternalReference());
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "Access";
    }

    public List<Individual> getIndividuals() {
        return Collections.unmodifiableList(this._individuals);
    }

    public List<Group> getGroups() {
        return Collections.unmodifiableList(this._groups);
    }

    public ProfileList getProfileList() {
        return this._profileList;
    }

    public Boolean isExternalReference() {
        String string = this.getAttributeValue(EXTERNAL_REFERENCE_NAME, this.getDDMSVersion().getNtkNamespace());
        if ("true".equals(string)) {
            return Boolean.TRUE;
        }
        if ("false".equals(string)) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 7851044806424206976L;
        private List<Individual.Builder> _individuals;
        private List<Group.Builder> _groups;
        private ProfileList.Builder _profileList;
        private Boolean _externalReference;
        private SecurityAttributes.Builder _securityAttributes;

        public Builder() {
        }

        public Builder(Access access) {
            for (Individual abstractAccessEntity : access.getIndividuals()) {
                this.getIndividuals().add(new Individual.Builder(abstractAccessEntity));
            }
            for (Group group : access.getGroups()) {
                this.getGroups().add(new Group.Builder(group));
            }
            if (access.getProfileList() != null) {
                this.setProfileList(new ProfileList.Builder(access.getProfileList()));
            }
            this.setExternalReference(access.isExternalReference());
            this.setSecurityAttributes(new SecurityAttributes.Builder(access.getSecurityAttributes()));
        }

        @Override
        public Access commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<Individual> arrayList = new ArrayList<Individual>();
            for (IBuilder object : this.getIndividuals()) {
                Individual individual = (Individual)object.commit();
                if (individual == null) continue;
                arrayList.add(individual);
            }
            ArrayList arrayList2 = new ArrayList();
            for (IBuilder iBuilder : this.getGroups()) {
                Group group = (Group)iBuilder.commit();
                if (group == null) continue;
                arrayList2.add(group);
            }
            return new Access(arrayList, arrayList2, this.getProfileList().commit(), this.getExternalReference(), this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (IBuilder iBuilder : this.getIndividuals()) {
                bl = bl || !iBuilder.isEmpty();
            }
            for (IBuilder iBuilder : this.getGroups()) {
                bl = bl || !iBuilder.isEmpty();
            }
            return !bl && this.getProfileList().isEmpty() && this.getExternalReference() == null && this.getSecurityAttributes().isEmpty();
        }

        public List<Individual.Builder> getIndividuals() {
            if (this._individuals == null) {
                this._individuals = new LazyList(Individual.Builder.class);
            }
            return this._individuals;
        }

        public List<Group.Builder> getGroups() {
            if (this._groups == null) {
                this._groups = new LazyList(Group.Builder.class);
            }
            return this._groups;
        }

        public ProfileList.Builder getProfileList() {
            if (this._profileList == null) {
                this._profileList = new ProfileList.Builder();
            }
            return this._profileList;
        }

        public void setProfileList(ProfileList.Builder builder) {
            this._profileList = builder;
        }

        public Boolean getExternalReference() {
            return this._externalReference;
        }

        public void setExternalReference(Boolean bl) {
            this._externalReference = bl;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

