/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.security.ism;

import buri.ddmsence.AbstractAttributeGroup;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.Resource;
import buri.ddmsence.ddms.security.ism.ISMVocabulary;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import nu.xom.Element;

public final class SecurityAttributes
extends AbstractAttributeGroup {
    private List<String> _atomicEnergyMarkings = null;
    private String _classification = null;
    private String _classificationReason = null;
    private String _classifiedBy = null;
    private String _compilationReason = null;
    private XMLGregorianCalendar _dateOfExemptedSource = null;
    private XMLGregorianCalendar _declassDate = null;
    private String _declassEvent = null;
    private String _declassException = null;
    private Boolean _declassManualReview = null;
    private String _derivativelyClassifiedBy = null;
    private String _derivedFrom = null;
    private List<String> _displayOnlyTo = null;
    private List<String> _disseminationControls = null;
    private List<String> _FGIsourceOpen = null;
    private List<String> _FGIsourceProtected = null;
    private List<String> _nonICmarkings = null;
    private List<String> _nonUSControls = null;
    private List<String> _ownerProducers = null;
    private List<String> _releasableTo = null;
    private List<String> _SARIdentifier = null;
    private List<String> _SCIcontrols = null;
    private String _typeOfExemptedSource = null;
    public static final String ATOMIC_ENERGY_MARKINGS_NAME = "atomicEnergyMarkings";
    public static final String CLASSIFICATION_NAME = "classification";
    public static final String CLASSIFICATION_REASON_NAME = "classificationReason";
    public static final String CLASSIFIED_BY_NAME = "classifiedBy";
    public static final String COMPILATION_REASON_NAME = "compilationReason";
    public static final String DATE_OF_EXEMPTED_SOURCE_NAME = "dateOfExemptedSource";
    public static final String DECLASS_DATE_NAME = "declassDate";
    public static final String DECLASS_EVENT_NAME = "declassEvent";
    public static final String DECLASS_EXCEPTION_NAME = "declassException";
    public static final String DECLASS_MANUAL_REVIEW_NAME = "declassManualReview";
    public static final String DERIVATIVELY_CLASSIFIED_BY_NAME = "derivativelyClassifiedBy";
    public static final String DERIVED_FROM_NAME = "derivedFrom";
    public static final String DISPLAY_ONLY_TO_NAME = "displayOnlyTo";
    public static final String DISSEMINATION_CONTROLS_NAME = "disseminationControls";
    public static final String FGI_SOURCE_OPEN_NAME = "FGIsourceOpen";
    public static final String FGI_SOURCE_PROTECTED_NAME = "FGIsourceProtected";
    public static final String NON_IC_MARKINGS_NAME = "nonICmarkings";
    public static final String NON_US_CONTROLS_NAME = "nonUSControls";
    public static final String OWNER_PRODUCER_NAME = "ownerProducer";
    public static final String RELEASABLE_TO_NAME = "releasableTo";
    public static final String SAR_IDENTIFIER_NAME = "SARIdentifier";
    public static final String SCI_CONTROLS_NAME = "SCIcontrols";
    public static final String TYPE_OF_EXEMPTED_SOURCE_NAME = "typeOfExemptedSource";
    private static final Set<String> ALL_NAMES = new HashSet<String>();
    public static final Set<String> NON_EXTENSIBLE_NAMES;

    public static SecurityAttributes getNonNullInstance(SecurityAttributes securityAttributes) throws InvalidDDMSException {
        return securityAttributes == null ? new SecurityAttributes(null, null, null) : securityAttributes;
    }

    public SecurityAttributes(Element element) throws InvalidDDMSException {
        super(element.getNamespaceURI());
        String string;
        String string2 = this.getDDMSVersion().getIsmNamespace();
        this._atomicEnergyMarkings = Util.getXsListAsList(element.getAttributeValue(ATOMIC_ENERGY_MARKINGS_NAME, string2));
        this._classification = element.getAttributeValue(CLASSIFICATION_NAME, string2);
        this._classificationReason = element.getAttributeValue(CLASSIFICATION_REASON_NAME, string2);
        this._classifiedBy = element.getAttributeValue(CLASSIFIED_BY_NAME, string2);
        this._compilationReason = element.getAttributeValue(COMPILATION_REASON_NAME, string2);
        String string3 = element.getAttributeValue(DATE_OF_EXEMPTED_SOURCE_NAME, string2);
        if (!Util.isEmpty(string3)) {
            this._dateOfExemptedSource = SecurityAttributes.getFactory().newXMLGregorianCalendar(string3);
        }
        if (!Util.isEmpty(string = element.getAttributeValue(DECLASS_DATE_NAME, string2))) {
            this._declassDate = SecurityAttributes.getFactory().newXMLGregorianCalendar(string);
        }
        this._declassEvent = element.getAttributeValue(DECLASS_EVENT_NAME, string2);
        this._declassException = element.getAttributeValue(DECLASS_EXCEPTION_NAME, string2);
        String string4 = element.getAttributeValue(DECLASS_MANUAL_REVIEW_NAME, string2);
        if (!Util.isEmpty(string4)) {
            this._declassManualReview = Boolean.valueOf(string4);
        }
        this._derivativelyClassifiedBy = element.getAttributeValue(DERIVATIVELY_CLASSIFIED_BY_NAME, string2);
        this._derivedFrom = element.getAttributeValue(DERIVED_FROM_NAME, string2);
        this._displayOnlyTo = Util.getXsListAsList(element.getAttributeValue(DISPLAY_ONLY_TO_NAME, string2));
        this._disseminationControls = Util.getXsListAsList(element.getAttributeValue(DISSEMINATION_CONTROLS_NAME, string2));
        this._FGIsourceOpen = Util.getXsListAsList(element.getAttributeValue(FGI_SOURCE_OPEN_NAME, string2));
        this._FGIsourceProtected = Util.getXsListAsList(element.getAttributeValue(FGI_SOURCE_PROTECTED_NAME, string2));
        this._nonICmarkings = Util.getXsListAsList(element.getAttributeValue(NON_IC_MARKINGS_NAME, string2));
        this._nonUSControls = Util.getXsListAsList(element.getAttributeValue(NON_US_CONTROLS_NAME, string2));
        this._ownerProducers = Util.getXsListAsList(element.getAttributeValue(OWNER_PRODUCER_NAME, string2));
        this._releasableTo = Util.getXsListAsList(element.getAttributeValue(RELEASABLE_TO_NAME, string2));
        this._SARIdentifier = Util.getXsListAsList(element.getAttributeValue(SAR_IDENTIFIER_NAME, string2));
        this._SCIcontrols = Util.getXsListAsList(element.getAttributeValue(SCI_CONTROLS_NAME, string2));
        this._typeOfExemptedSource = element.getAttributeValue(TYPE_OF_EXEMPTED_SOURCE_NAME, string2);
        this.validate();
    }

    public SecurityAttributes(String string, List<String> list, Map<String, String> map) throws InvalidDDMSException {
        super(DDMSVersion.getCurrentVersion().getNamespace());
        String string2;
        if (list == null) {
            list = Collections.emptyList();
        }
        if (map == null) {
            map = Collections.emptyMap();
        }
        this._atomicEnergyMarkings = Util.getXsListAsList(map.get(ATOMIC_ENERGY_MARKINGS_NAME));
        this._classification = string;
        this._classificationReason = map.get(CLASSIFICATION_REASON_NAME);
        this._classifiedBy = map.get(CLASSIFIED_BY_NAME);
        this._compilationReason = map.get(COMPILATION_REASON_NAME);
        String string3 = map.get(DATE_OF_EXEMPTED_SOURCE_NAME);
        if (!Util.isEmpty(string3)) {
            try {
                this._dateOfExemptedSource = SecurityAttributes.getFactory().newXMLGregorianCalendar(string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidDDMSException("The ISM:dateOfExemptedSource attribute is not in a valid date format.");
            }
        }
        if (!Util.isEmpty(string2 = map.get(DECLASS_DATE_NAME))) {
            try {
                this._declassDate = SecurityAttributes.getFactory().newXMLGregorianCalendar(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidDDMSException("The ISM:declassDate attribute is not in a valid date format.");
            }
        }
        this._declassEvent = map.get(DECLASS_EVENT_NAME);
        this._declassException = map.get(DECLASS_EXCEPTION_NAME);
        String string4 = map.get(DECLASS_MANUAL_REVIEW_NAME);
        if (!Util.isEmpty(string4)) {
            this._declassManualReview = Boolean.valueOf(string4);
        }
        this._derivativelyClassifiedBy = map.get(DERIVATIVELY_CLASSIFIED_BY_NAME);
        this._derivedFrom = map.get(DERIVED_FROM_NAME);
        this._displayOnlyTo = Util.getXsListAsList(map.get(DISPLAY_ONLY_TO_NAME));
        this._disseminationControls = Util.getXsListAsList(map.get(DISSEMINATION_CONTROLS_NAME));
        this._FGIsourceOpen = Util.getXsListAsList(map.get(FGI_SOURCE_OPEN_NAME));
        this._FGIsourceProtected = Util.getXsListAsList(map.get(FGI_SOURCE_PROTECTED_NAME));
        this._nonICmarkings = Util.getXsListAsList(map.get(NON_IC_MARKINGS_NAME));
        this._nonUSControls = Util.getXsListAsList(map.get(NON_US_CONTROLS_NAME));
        this._ownerProducers = list;
        this._releasableTo = Util.getXsListAsList(map.get(RELEASABLE_TO_NAME));
        this._SARIdentifier = Util.getXsListAsList(map.get(SAR_IDENTIFIER_NAME));
        this._SCIcontrols = Util.getXsListAsList(map.get(SCI_CONTROLS_NAME));
        this._typeOfExemptedSource = map.get(TYPE_OF_EXEMPTED_SOURCE_NAME);
        this.validate();
    }

    public void addTo(Element element) throws InvalidDDMSException {
        DDMSVersion dDMSVersion = DDMSVersion.getVersionForNamespace(element.getNamespaceURI());
        this.validateSameVersion(dDMSVersion);
        String string = dDMSVersion.getIsmNamespace();
        String string2 = PropertyReader.getPrefix("ism");
        Util.addAttribute(element, string2, ATOMIC_ENERGY_MARKINGS_NAME, string, Util.getXsList(this.getAtomicEnergyMarkings()));
        Util.addAttribute(element, string2, CLASSIFICATION_NAME, string, this.getClassification());
        Util.addAttribute(element, string2, CLASSIFICATION_REASON_NAME, string, this.getClassificationReason());
        Util.addAttribute(element, string2, CLASSIFIED_BY_NAME, string, this.getClassifiedBy());
        Util.addAttribute(element, string2, COMPILATION_REASON_NAME, string, this.getCompilationReason());
        if (this.getDateOfExemptedSource() != null) {
            Util.addAttribute(element, string2, DATE_OF_EXEMPTED_SOURCE_NAME, string, this.getDateOfExemptedSource().toXMLFormat());
        }
        if (this.getDeclassDate() != null) {
            Util.addAttribute(element, string2, DECLASS_DATE_NAME, string, this.getDeclassDate().toXMLFormat());
        }
        Util.addAttribute(element, string2, DECLASS_EVENT_NAME, string, this.getDeclassEvent());
        Util.addAttribute(element, string2, DECLASS_EXCEPTION_NAME, string, this.getDeclassException());
        if (this.getDeclassManualReview() != null) {
            Util.addAttribute(element, string2, DECLASS_MANUAL_REVIEW_NAME, string, this.getDeclassManualReview().toString());
        }
        Util.addAttribute(element, string2, DERIVATIVELY_CLASSIFIED_BY_NAME, string, this.getDerivativelyClassifiedBy());
        Util.addAttribute(element, string2, DERIVED_FROM_NAME, string, this.getDerivedFrom());
        Util.addAttribute(element, string2, DISPLAY_ONLY_TO_NAME, string, Util.getXsList(this.getDisplayOnlyTo()));
        Util.addAttribute(element, string2, DISSEMINATION_CONTROLS_NAME, string, Util.getXsList(this.getDisseminationControls()));
        Util.addAttribute(element, string2, FGI_SOURCE_OPEN_NAME, string, Util.getXsList(this.getFGIsourceOpen()));
        Util.addAttribute(element, string2, FGI_SOURCE_PROTECTED_NAME, string, Util.getXsList(this.getFGIsourceProtected()));
        Util.addAttribute(element, string2, NON_IC_MARKINGS_NAME, string, Util.getXsList(this.getNonICmarkings()));
        Util.addAttribute(element, string2, NON_US_CONTROLS_NAME, string, Util.getXsList(this.getNonUSControls()));
        Util.addAttribute(element, string2, OWNER_PRODUCER_NAME, string, Util.getXsList(this.getOwnerProducers()));
        Util.addAttribute(element, string2, RELEASABLE_TO_NAME, string, Util.getXsList(this.getReleasableTo()));
        Util.addAttribute(element, string2, SAR_IDENTIFIER_NAME, string, Util.getXsList(this.getSARIdentifier()));
        Util.addAttribute(element, string2, SCI_CONTROLS_NAME, string, Util.getXsList(this.getSCIcontrols()));
        Util.addAttribute(element, string2, TYPE_OF_EXEMPTED_SOURCE_NAME, string, this.getTypeOfExemptedSource());
    }

    public boolean isEmpty() {
        return this.getAtomicEnergyMarkings().isEmpty() && Util.isEmpty(this.getClassification()) && Util.isEmpty(this.getClassificationReason()) && Util.isEmpty(this.getClassifiedBy()) && Util.isEmpty(this.getCompilationReason()) && this.getDateOfExemptedSource() == null && this.getDeclassDate() == null && Util.isEmpty(this.getDeclassEvent()) && Util.isEmpty(this.getDeclassException()) && this.getDeclassManualReview() == null && Util.isEmpty(this.getDerivativelyClassifiedBy()) && Util.isEmpty(this.getDerivedFrom()) && this.getDisplayOnlyTo().isEmpty() && this.getDisseminationControls().isEmpty() && this.getFGIsourceOpen().isEmpty() && this.getFGIsourceProtected().isEmpty() && this.getNonICmarkings().isEmpty() && this.getNonUSControls().isEmpty() && this.getOwnerProducers().isEmpty() && this.getReleasableTo().isEmpty() && this.getSARIdentifier().isEmpty() && this.getSCIcontrols().isEmpty() && Util.isEmpty(this.getTypeOfExemptedSource());
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        DDMSVersion dDMSVersion = this.getDDMSVersion();
        boolean bl = "2.0".equals(dDMSVersion.getVersion());
        if (!dDMSVersion.isAtLeast("3.1") && !this.getAtomicEnergyMarkings().isEmpty()) {
            throw new InvalidDDMSException("The atomicEnergyMarkings attribute cannot be used until DDMS 3.1 or later.");
        }
        for (String string : this.getAtomicEnergyMarkings()) {
            ISMVocabulary.validateEnumeration("CVEnumISMAtomicEnergyMarkings.xml", string);
        }
        if (!(Util.isEmpty(this.getClassification()) || !dDMSVersion.isAtLeast("3.0") && ISMVocabulary.usingOldClassification(this.getClassification()))) {
            ISMVocabulary.validateEnumeration("CVEnumISMClassificationAll.xml", this.getClassification());
        }
        if (!dDMSVersion.isAtLeast("3.0") && !Util.isEmpty(this.getCompilationReason())) {
            throw new InvalidDDMSException("The compilationReason attribute cannot be used until DDMS 3.0 or later.");
        }
        if (dDMSVersion.isAtLeast("3.1") && this.getDateOfExemptedSource() != null) {
            throw new InvalidDDMSException("The dateOfExemptedSource attribute can only be used in DDMS 2.0 or 3.0.");
        }
        if (this.getDateOfExemptedSource() != null && !this.getDateOfExemptedSource().getXMLSchemaType().equals(DatatypeConstants.DATE)) {
            throw new InvalidDDMSException("The dateOfExemptedSource attribute must be in the xs:date format (YYYY-MM-DD).");
        }
        if (this.getDeclassDate() != null && !this.getDeclassDate().getXMLSchemaType().equals(DatatypeConstants.DATE)) {
            throw new InvalidDDMSException("The declassDate must be in the xs:date format (YYYY-MM-DD).");
        }
        if (!Util.isEmpty(this.getDeclassException())) {
            if (bl) {
                for (String string : Util.getXsListAsList(this.getDeclassException())) {
                    ISMVocabulary.validateEnumeration("CVEnumISM25X.xml", string);
                }
            } else {
                ISMVocabulary.validateEnumeration("CVEnumISM25X.xml", this.getDeclassException());
            }
        }
        if (!bl && this.getDeclassManualReview() != null) {
            throw new InvalidDDMSException("The declassManualReview attribute can only be used in DDMS 2.0.");
        }
        if (!dDMSVersion.isAtLeast("3.1") && !this.getDisplayOnlyTo().isEmpty()) {
            throw new InvalidDDMSException("The displayOnlyTo attribute cannot be used until DDMS 3.1 or later.");
        }
        for (String string : this.getDisplayOnlyTo()) {
            ISMVocabulary.validateEnumeration("CVEnumISMRelTo.xml", string);
        }
        for (String string : this.getDisseminationControls()) {
            ISMVocabulary.validateEnumeration("CVEnumISMDissem.xml", string);
        }
        for (String string : this.getFGIsourceOpen()) {
            ISMVocabulary.validateEnumeration("CVEnumISMFGIOpen.xml", string);
        }
        for (String string : this.getFGIsourceProtected()) {
            ISMVocabulary.validateEnumeration("CVEnumISMFGIProtected.xml", string);
        }
        for (String string : this.getNonICmarkings()) {
            ISMVocabulary.validateEnumeration("CVEnumISMNonIC.xml", string);
        }
        if (!dDMSVersion.isAtLeast("3.1") && !this.getNonUSControls().isEmpty()) {
            throw new InvalidDDMSException("The nonUSControls attribute cannot be used until DDMS 3.1 or later.");
        }
        for (String string : this.getNonUSControls()) {
            ISMVocabulary.validateEnumeration("CVEnumISMNonUSControls.xml", string);
        }
        for (String string : this.getOwnerProducers()) {
            ISMVocabulary.validateEnumeration("CVEnumISMOwnerProducer.xml", string);
        }
        for (String string : this.getReleasableTo()) {
            ISMVocabulary.validateEnumeration("CVEnumISMRelTo.xml", string);
        }
        for (String string : this.getSARIdentifier()) {
            ISMVocabulary.validateEnumeration("CVEnumISMSAR.xml", string);
        }
        for (String string : this.getSCIcontrols()) {
            ISMVocabulary.validateEnumeration("CVEnumISMSCIControls.xml", string);
        }
        if (!Util.isEmpty(this.getTypeOfExemptedSource())) {
            if (bl) {
                for (String string : Util.getXsListAsList(this.getTypeOfExemptedSource())) {
                    ISMVocabulary.validateEnumeration("CVEnumISMSourceMarked.xml", string);
                }
            } else if ("3.0".equals(dDMSVersion.getVersion())) {
                ISMVocabulary.validateEnumeration("CVEnumISMSourceMarked.xml", this.getTypeOfExemptedSource());
            } else {
                throw new InvalidDDMSException("The typeOfExemptedSource attribute can only be used in DDMS 2.0 or 3.0.");
            }
        }
        super.validate();
    }

    public void requireClassification() throws InvalidDDMSException {
        Util.requireDDMSValue(CLASSIFICATION_NAME, this.getClassification());
        if (this.getOwnerProducers().size() == 0) {
            throw new InvalidDDMSException("At least 1 ownerProducer must be set.");
        }
    }

    @Override
    public String getOutput(boolean bl, String string) {
        String string2 = Util.getNonNullString(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Resource.buildOutput(bl, string2 + ATOMIC_ENERGY_MARKINGS_NAME, Util.getXsList(this.getAtomicEnergyMarkings())));
        stringBuffer.append(Resource.buildOutput(bl, string2 + CLASSIFICATION_NAME, this.getClassification()));
        stringBuffer.append(Resource.buildOutput(bl, string2 + CLASSIFICATION_REASON_NAME, this.getClassificationReason()));
        stringBuffer.append(Resource.buildOutput(bl, string2 + CLASSIFIED_BY_NAME, this.getClassifiedBy()));
        stringBuffer.append(Resource.buildOutput(bl, string2 + COMPILATION_REASON_NAME, this.getCompilationReason()));
        if (this.getDateOfExemptedSource() != null) {
            stringBuffer.append(Resource.buildOutput(bl, string2 + DATE_OF_EXEMPTED_SOURCE_NAME, this.getDateOfExemptedSource().toXMLFormat()));
        }
        if (this.getDeclassDate() != null) {
            stringBuffer.append(Resource.buildOutput(bl, string2 + DECLASS_DATE_NAME, this.getDeclassDate().toXMLFormat()));
        }
        stringBuffer.append(Resource.buildOutput(bl, string2 + DECLASS_EVENT_NAME, this.getDeclassEvent()));
        stringBuffer.append(Resource.buildOutput(bl, string2 + DECLASS_EXCEPTION_NAME, this.getDeclassException()));
        if (this.getDeclassManualReview() != null) {
            stringBuffer.append(Resource.buildOutput(bl, string2 + DECLASS_MANUAL_REVIEW_NAME, this.getDeclassManualReview().toString()));
        }
        stringBuffer.append(Resource.buildOutput(bl, string2 + DERIVATIVELY_CLASSIFIED_BY_NAME, this.getDerivativelyClassifiedBy()));
        stringBuffer.append(Resource.buildOutput(bl, string2 + DERIVED_FROM_NAME, this.getDerivedFrom()));
        stringBuffer.append(Resource.buildOutput(bl, string2 + DISPLAY_ONLY_TO_NAME, Util.getXsList(this.getDisplayOnlyTo())));
        stringBuffer.append(Resource.buildOutput(bl, string2 + DISSEMINATION_CONTROLS_NAME, Util.getXsList(this.getDisseminationControls())));
        stringBuffer.append(Resource.buildOutput(bl, string2 + FGI_SOURCE_OPEN_NAME, Util.getXsList(this.getFGIsourceOpen())));
        stringBuffer.append(Resource.buildOutput(bl, string2 + FGI_SOURCE_PROTECTED_NAME, Util.getXsList(this.getFGIsourceProtected())));
        stringBuffer.append(Resource.buildOutput(bl, string2 + NON_IC_MARKINGS_NAME, Util.getXsList(this.getNonICmarkings())));
        stringBuffer.append(Resource.buildOutput(bl, string2 + NON_US_CONTROLS_NAME, Util.getXsList(this.getNonUSControls())));
        stringBuffer.append(Resource.buildOutput(bl, string2 + OWNER_PRODUCER_NAME, Util.getXsList(this.getOwnerProducers())));
        stringBuffer.append(Resource.buildOutput(bl, string2 + RELEASABLE_TO_NAME, Util.getXsList(this.getReleasableTo())));
        stringBuffer.append(Resource.buildOutput(bl, string2 + SAR_IDENTIFIER_NAME, Util.getXsList(this.getSARIdentifier())));
        stringBuffer.append(Resource.buildOutput(bl, string2 + SCI_CONTROLS_NAME, Util.getXsList(this.getSCIcontrols())));
        stringBuffer.append(Resource.buildOutput(bl, string2 + TYPE_OF_EXEMPTED_SOURCE_NAME, this.getTypeOfExemptedSource()));
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SecurityAttributes)) {
            return false;
        }
        SecurityAttributes securityAttributes = (SecurityAttributes)object;
        return Util.listEquals(this.getAtomicEnergyMarkings(), securityAttributes.getAtomicEnergyMarkings()) && this.getClassification().equals(securityAttributes.getClassification()) && this.getClassificationReason().equals(securityAttributes.getClassificationReason()) && this.getClassifiedBy().equals(securityAttributes.getClassifiedBy()) && this.getCompilationReason().equals(securityAttributes.getCompilationReason()) && Util.nullEquals(this.getDateOfExemptedSource(), securityAttributes.getDateOfExemptedSource()) && Util.nullEquals(this.getDeclassDate(), securityAttributes.getDeclassDate()) && this.getDeclassEvent().equals(securityAttributes.getDeclassEvent()) && this.getDeclassException().equals(securityAttributes.getDeclassException()) && Util.nullEquals(this.getDeclassManualReview(), securityAttributes.getDeclassManualReview()) && this.getDerivativelyClassifiedBy().equals(securityAttributes.getDerivativelyClassifiedBy()) && this.getDerivedFrom().equals(securityAttributes.getDerivedFrom()) && Util.listEquals(this.getDisplayOnlyTo(), securityAttributes.getDisplayOnlyTo()) && Util.listEquals(this.getDisseminationControls(), securityAttributes.getDisseminationControls()) && Util.listEquals(this.getFGIsourceOpen(), securityAttributes.getFGIsourceOpen()) && Util.listEquals(this.getFGIsourceProtected(), securityAttributes.getFGIsourceProtected()) && Util.listEquals(this.getNonICmarkings(), securityAttributes.getNonICmarkings()) && Util.listEquals(this.getNonUSControls(), securityAttributes.getNonUSControls()) && Util.listEquals(this.getOwnerProducers(), securityAttributes.getOwnerProducers()) && Util.listEquals(this.getReleasableTo(), securityAttributes.getReleasableTo()) && Util.listEquals(this.getSARIdentifier(), securityAttributes.getSARIdentifier()) && Util.listEquals(this.getSCIcontrols(), securityAttributes.getSCIcontrols()) && this.getTypeOfExemptedSource().equals(securityAttributes.getTypeOfExemptedSource());
    }

    public int hashCode() {
        int n = 0;
        n = 7 * n + this.getAtomicEnergyMarkings().hashCode();
        n = 7 * n + this.getClassification().hashCode();
        n = 7 * n + this.getClassificationReason().hashCode();
        n = 7 * n + this.getClassifiedBy().hashCode();
        n = 7 * n + this.getCompilationReason().hashCode();
        if (this.getDateOfExemptedSource() != null) {
            n = 7 * n + this.getDateOfExemptedSource().hashCode();
        }
        if (this.getDeclassDate() != null) {
            n = 7 * n + this.getDeclassDate().hashCode();
        }
        n = 7 * n + this.getDeclassEvent().hashCode();
        n = 7 * n + this.getDeclassException().hashCode();
        if (this.getDeclassManualReview() != null) {
            n = 7 * n + this.getDeclassManualReview().hashCode();
        }
        n = 7 * n + this.getDerivativelyClassifiedBy().hashCode();
        n = 7 * n + this.getDerivedFrom().hashCode();
        n = 7 * n + this.getDisplayOnlyTo().hashCode();
        n = 7 * n + this.getDisseminationControls().hashCode();
        n = 7 * n + this.getFGIsourceOpen().hashCode();
        n = 7 * n + this.getFGIsourceProtected().hashCode();
        n = 7 * n + this.getNonICmarkings().hashCode();
        n = 7 * n + this.getNonUSControls().hashCode();
        n = 7 * n + this.getOwnerProducers().hashCode();
        n = 7 * n + this.getReleasableTo().hashCode();
        n = 7 * n + this.getSARIdentifier().hashCode();
        n = 7 * n + this.getSCIcontrols().hashCode();
        n = 7 * n + this.getTypeOfExemptedSource().hashCode();
        return n;
    }

    public List<String> getAtomicEnergyMarkings() {
        return Collections.unmodifiableList(this._atomicEnergyMarkings);
    }

    public String getClassification() {
        return Util.getNonNullString(this._classification);
    }

    public String getClassificationReason() {
        return Util.getNonNullString(this._classificationReason);
    }

    public String getClassifiedBy() {
        return Util.getNonNullString(this._classifiedBy);
    }

    public String getCompilationReason() {
        return Util.getNonNullString(this._compilationReason);
    }

    public XMLGregorianCalendar getDateOfExemptedSource() {
        return this._dateOfExemptedSource == null ? null : SecurityAttributes.getFactory().newXMLGregorianCalendar(this._dateOfExemptedSource.toXMLFormat());
    }

    public XMLGregorianCalendar getDeclassDate() {
        return this._declassDate == null ? null : SecurityAttributes.getFactory().newXMLGregorianCalendar(this._declassDate.toXMLFormat());
    }

    public String getDeclassEvent() {
        return Util.getNonNullString(this._declassEvent);
    }

    public String getDeclassException() {
        return Util.getNonNullString(this._declassException);
    }

    public Boolean getDeclassManualReview() {
        return this._declassManualReview;
    }

    public String getDerivativelyClassifiedBy() {
        return Util.getNonNullString(this._derivativelyClassifiedBy);
    }

    public String getDerivedFrom() {
        return Util.getNonNullString(this._derivedFrom);
    }

    public List<String> getDisplayOnlyTo() {
        return Collections.unmodifiableList(this._displayOnlyTo);
    }

    public List<String> getDisseminationControls() {
        return Collections.unmodifiableList(this._disseminationControls);
    }

    public List<String> getFGIsourceOpen() {
        return Collections.unmodifiableList(this._FGIsourceOpen);
    }

    public List<String> getFGIsourceProtected() {
        return Collections.unmodifiableList(this._FGIsourceProtected);
    }

    public List<String> getNonICmarkings() {
        return Collections.unmodifiableList(this._nonICmarkings);
    }

    public List<String> getNonUSControls() {
        return Collections.unmodifiableList(this._nonUSControls);
    }

    public List<String> getOwnerProducers() {
        return Collections.unmodifiableList(this._ownerProducers);
    }

    public List<String> getReleasableTo() {
        return Collections.unmodifiableList(this._releasableTo);
    }

    public List<String> getSARIdentifier() {
        return Collections.unmodifiableList(this._SARIdentifier);
    }

    public List<String> getSCIcontrols() {
        return Collections.unmodifiableList(this._SCIcontrols);
    }

    public String getTypeOfExemptedSource() {
        return Util.getNonNullString(this._typeOfExemptedSource);
    }

    private static DatatypeFactory getFactory() {
        return Util.getDataTypeFactory();
    }

    static {
        ALL_NAMES.add(ATOMIC_ENERGY_MARKINGS_NAME);
        ALL_NAMES.add(CLASSIFICATION_NAME);
        ALL_NAMES.add(CLASSIFICATION_REASON_NAME);
        ALL_NAMES.add(CLASSIFIED_BY_NAME);
        ALL_NAMES.add(COMPILATION_REASON_NAME);
        ALL_NAMES.add(DATE_OF_EXEMPTED_SOURCE_NAME);
        ALL_NAMES.add(DECLASS_DATE_NAME);
        ALL_NAMES.add(DECLASS_EVENT_NAME);
        ALL_NAMES.add(DECLASS_EXCEPTION_NAME);
        ALL_NAMES.add(DECLASS_MANUAL_REVIEW_NAME);
        ALL_NAMES.add(DERIVATIVELY_CLASSIFIED_BY_NAME);
        ALL_NAMES.add(DERIVED_FROM_NAME);
        ALL_NAMES.add(DISPLAY_ONLY_TO_NAME);
        ALL_NAMES.add(DISSEMINATION_CONTROLS_NAME);
        ALL_NAMES.add(FGI_SOURCE_OPEN_NAME);
        ALL_NAMES.add(FGI_SOURCE_PROTECTED_NAME);
        ALL_NAMES.add(NON_IC_MARKINGS_NAME);
        ALL_NAMES.add(NON_US_CONTROLS_NAME);
        ALL_NAMES.add(OWNER_PRODUCER_NAME);
        ALL_NAMES.add(RELEASABLE_TO_NAME);
        ALL_NAMES.add(SAR_IDENTIFIER_NAME);
        ALL_NAMES.add(SCI_CONTROLS_NAME);
        ALL_NAMES.add(TYPE_OF_EXEMPTED_SOURCE_NAME);
        NON_EXTENSIBLE_NAMES = Collections.unmodifiableSet(ALL_NAMES);
    }

    public static class Builder
    implements Serializable {
        private static final long serialVersionUID = 279072341662308051L;
        private Map<String, String> _stringAttributes = new HashMap<String, String>();
        private Map<String, List<String>> _listAttributes = new HashMap<String, List<String>>();
        private Boolean _declassManualReview = null;

        public Builder() {
        }

        public Builder(SecurityAttributes securityAttributes) {
            this.setAtomicEnergyMarkings(securityAttributes.getAtomicEnergyMarkings());
            this.setClassification(securityAttributes.getClassification());
            this.setClassificationReason(securityAttributes.getClassificationReason());
            this.setClassifiedBy(securityAttributes.getClassifiedBy());
            this.setCompilationReason(securityAttributes.getCompilationReason());
            if (securityAttributes.getDateOfExemptedSource() != null) {
                this.setDateOfExemptedSource(securityAttributes.getDateOfExemptedSource().toXMLFormat());
            }
            if (securityAttributes.getDeclassDate() != null) {
                this.setDeclassDate(securityAttributes.getDeclassDate().toXMLFormat());
            }
            this.setDeclassEvent(securityAttributes.getDeclassEvent());
            this.setDeclassException(securityAttributes.getDeclassException());
            if (securityAttributes.getDeclassManualReview() != null) {
                this.setDeclassManualReview(securityAttributes.getDeclassManualReview());
            }
            this.setDerivativelyClassifiedBy(securityAttributes.getDerivativelyClassifiedBy());
            this.setDerivedFrom(securityAttributes.getDerivedFrom());
            this.setDisplayOnlyTo(securityAttributes.getDisplayOnlyTo());
            this.setDisseminationControls(securityAttributes.getDisseminationControls());
            this.setFGIsourceOpen(securityAttributes.getFGIsourceOpen());
            this.setFGIsourceProtected(securityAttributes.getFGIsourceProtected());
            this.setNonICmarkings(securityAttributes.getNonICmarkings());
            this.setNonUSControls(securityAttributes.getNonUSControls());
            this.setOwnerProducers(securityAttributes.getOwnerProducers());
            this.setReleasableTo(securityAttributes.getReleasableTo());
            this.setSARIdentifier(securityAttributes.getSARIdentifier());
            this.setSCIcontrols(securityAttributes.getSCIcontrols());
            this.setTypeOfExemptedSource(securityAttributes.getTypeOfExemptedSource());
        }

        public SecurityAttributes commit() throws InvalidDDMSException {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(SecurityAttributes.ATOMIC_ENERGY_MARKINGS_NAME, Util.getXsList(this.getAtomicEnergyMarkings()));
            hashMap.put(SecurityAttributes.CLASSIFICATION_REASON_NAME, this.getClassificationReason());
            hashMap.put(SecurityAttributes.CLASSIFIED_BY_NAME, this.getClassifiedBy());
            hashMap.put(SecurityAttributes.COMPILATION_REASON_NAME, this.getCompilationReason());
            hashMap.put(SecurityAttributes.DATE_OF_EXEMPTED_SOURCE_NAME, this.getDateOfExemptedSource());
            hashMap.put(SecurityAttributes.DECLASS_DATE_NAME, this.getDeclassDate());
            hashMap.put(SecurityAttributes.DECLASS_EVENT_NAME, this.getDeclassEvent());
            hashMap.put(SecurityAttributes.DECLASS_EXCEPTION_NAME, this.getDeclassException());
            if (this.getDeclassManualReview() != null) {
                hashMap.put(SecurityAttributes.DECLASS_MANUAL_REVIEW_NAME, this.getDeclassManualReview().toString());
            }
            hashMap.put(SecurityAttributes.DERIVATIVELY_CLASSIFIED_BY_NAME, this.getDerivativelyClassifiedBy());
            hashMap.put(SecurityAttributes.DERIVED_FROM_NAME, this.getDerivedFrom());
            hashMap.put(SecurityAttributes.DISPLAY_ONLY_TO_NAME, Util.getXsList(this.getDisplayOnlyTo()));
            hashMap.put(SecurityAttributes.DISSEMINATION_CONTROLS_NAME, Util.getXsList(this.getDisseminationControls()));
            hashMap.put(SecurityAttributes.FGI_SOURCE_OPEN_NAME, Util.getXsList(this.getFGIsourceOpen()));
            hashMap.put(SecurityAttributes.FGI_SOURCE_PROTECTED_NAME, Util.getXsList(this.getFGIsourceProtected()));
            hashMap.put(SecurityAttributes.NON_IC_MARKINGS_NAME, Util.getXsList(this.getNonICmarkings()));
            hashMap.put(SecurityAttributes.NON_US_CONTROLS_NAME, Util.getXsList(this.getNonUSControls()));
            hashMap.put(SecurityAttributes.RELEASABLE_TO_NAME, Util.getXsList(this.getReleasableTo()));
            hashMap.put(SecurityAttributes.SAR_IDENTIFIER_NAME, Util.getXsList(this.getSARIdentifier()));
            hashMap.put(SecurityAttributes.SCI_CONTROLS_NAME, Util.getXsList(this.getSCIcontrols()));
            hashMap.put(SecurityAttributes.TYPE_OF_EXEMPTED_SOURCE_NAME, this.getTypeOfExemptedSource());
            return new SecurityAttributes(this.getClassification(), this.getOwnerProducers(), hashMap);
        }

        public boolean isEmpty() {
            boolean bl = true;
            for (String object : this.getStringAttributes().values()) {
                bl = bl && Util.isEmpty(object);
            }
            for (List list : this.getListAttributes().values()) {
                bl = bl && Util.containsOnlyEmptyValues(list);
            }
            return bl && this.getDeclassManualReview() == null;
        }

        public List<String> getAtomicEnergyMarkings() {
            return this.getListAttribute(SecurityAttributes.ATOMIC_ENERGY_MARKINGS_NAME);
        }

        public void setAtomicEnergyMarkings(List<String> list) {
            this.setListAttribute(SecurityAttributes.ATOMIC_ENERGY_MARKINGS_NAME, list);
        }

        public String getClassification() {
            return this.getStringAttributes().get(SecurityAttributes.CLASSIFICATION_NAME);
        }

        public void setClassification(String string) {
            this.getStringAttributes().put(SecurityAttributes.CLASSIFICATION_NAME, string);
        }

        public String getClassificationReason() {
            return this.getStringAttributes().get(SecurityAttributes.CLASSIFICATION_REASON_NAME);
        }

        public void setClassificationReason(String string) {
            this.getStringAttributes().put(SecurityAttributes.CLASSIFICATION_REASON_NAME, string);
        }

        public String getClassifiedBy() {
            return this.getStringAttributes().get(SecurityAttributes.CLASSIFIED_BY_NAME);
        }

        public void setClassifiedBy(String string) {
            this.getStringAttributes().put(SecurityAttributes.CLASSIFIED_BY_NAME, string);
        }

        public String getCompilationReason() {
            return this.getStringAttributes().get(SecurityAttributes.COMPILATION_REASON_NAME);
        }

        public void setCompilationReason(String string) {
            this.getStringAttributes().put(SecurityAttributes.COMPILATION_REASON_NAME, string);
        }

        public String getDateOfExemptedSource() {
            return this.getStringAttributes().get(SecurityAttributes.DATE_OF_EXEMPTED_SOURCE_NAME);
        }

        public void setDateOfExemptedSource(String string) {
            this.getStringAttributes().put(SecurityAttributes.DATE_OF_EXEMPTED_SOURCE_NAME, string);
        }

        public String getDeclassDate() {
            return this.getStringAttributes().get(SecurityAttributes.DECLASS_DATE_NAME);
        }

        public void setDeclassDate(String string) {
            this.getStringAttributes().put(SecurityAttributes.DECLASS_DATE_NAME, string);
        }

        public String getDeclassEvent() {
            return this.getStringAttributes().get(SecurityAttributes.DECLASS_EVENT_NAME);
        }

        public void setDeclassEvent(String string) {
            this.getStringAttributes().put(SecurityAttributes.DECLASS_EVENT_NAME, string);
        }

        public String getDeclassException() {
            return this.getStringAttributes().get(SecurityAttributes.DECLASS_EXCEPTION_NAME);
        }

        public void setDeclassException(String string) {
            this.getStringAttributes().put(SecurityAttributes.DECLASS_EXCEPTION_NAME, string);
        }

        public Boolean getDeclassManualReview() {
            return this._declassManualReview;
        }

        public void setDeclassManualReview(Boolean bl) {
            this._declassManualReview = bl;
        }

        public String getDerivativelyClassifiedBy() {
            return this.getStringAttributes().get(SecurityAttributes.DERIVATIVELY_CLASSIFIED_BY_NAME);
        }

        public void setDerivativelyClassifiedBy(String string) {
            this.getStringAttributes().put(SecurityAttributes.DERIVATIVELY_CLASSIFIED_BY_NAME, string);
        }

        public String getDerivedFrom() {
            return this.getStringAttributes().get(SecurityAttributes.DERIVED_FROM_NAME);
        }

        public void setDerivedFrom(String string) {
            this.getStringAttributes().put(SecurityAttributes.DERIVED_FROM_NAME, string);
        }

        public List<String> getDisplayOnlyTo() {
            return this.getListAttribute(SecurityAttributes.DISPLAY_ONLY_TO_NAME);
        }

        public void setDisplayOnlyTo(List<String> list) {
            this.setListAttribute(SecurityAttributes.DISPLAY_ONLY_TO_NAME, list);
        }

        public List<String> getDisseminationControls() {
            return this.getListAttribute(SecurityAttributes.DISSEMINATION_CONTROLS_NAME);
        }

        public void setDisseminationControls(List<String> list) {
            this.setListAttribute(SecurityAttributes.DISSEMINATION_CONTROLS_NAME, list);
        }

        public List<String> getFGIsourceOpen() {
            return this.getListAttribute(SecurityAttributes.FGI_SOURCE_OPEN_NAME);
        }

        public void setFGIsourceOpen(List<String> list) {
            this.setListAttribute(SecurityAttributes.FGI_SOURCE_OPEN_NAME, list);
        }

        public List<String> getFGIsourceProtected() {
            return this.getListAttribute(SecurityAttributes.FGI_SOURCE_PROTECTED_NAME);
        }

        public void setFGIsourceProtected(List<String> list) {
            this.setListAttribute(SecurityAttributes.FGI_SOURCE_PROTECTED_NAME, list);
        }

        public List<String> getNonICmarkings() {
            return this.getListAttribute(SecurityAttributes.NON_IC_MARKINGS_NAME);
        }

        public void setNonICmarkings(List<String> list) {
            this.setListAttribute(SecurityAttributes.NON_IC_MARKINGS_NAME, list);
        }

        public List<String> getNonUSControls() {
            return this.getListAttribute(SecurityAttributes.NON_US_CONTROLS_NAME);
        }

        public void setNonUSControls(List<String> list) {
            this.setListAttribute(SecurityAttributes.NON_US_CONTROLS_NAME, list);
        }

        public List<String> getOwnerProducers() {
            return this.getListAttribute(SecurityAttributes.OWNER_PRODUCER_NAME);
        }

        public void setOwnerProducers(List<String> list) {
            this.setListAttribute(SecurityAttributes.OWNER_PRODUCER_NAME, list);
        }

        public List<String> getReleasableTo() {
            return this.getListAttribute(SecurityAttributes.RELEASABLE_TO_NAME);
        }

        public void setReleasableTo(List<String> list) {
            this.setListAttribute(SecurityAttributes.RELEASABLE_TO_NAME, list);
        }

        public List<String> getSARIdentifier() {
            return this.getListAttribute(SecurityAttributes.SAR_IDENTIFIER_NAME);
        }

        public void setSARIdentifier(List<String> list) {
            this.setListAttribute(SecurityAttributes.SAR_IDENTIFIER_NAME, list);
        }

        public List<String> getSCIcontrols() {
            return this.getListAttribute(SecurityAttributes.SCI_CONTROLS_NAME);
        }

        public void setSCIcontrols(List<String> list) {
            this.setListAttribute(SecurityAttributes.SCI_CONTROLS_NAME, list);
        }

        public String getTypeOfExemptedSource() {
            return this.getStringAttributes().get(SecurityAttributes.TYPE_OF_EXEMPTED_SOURCE_NAME);
        }

        public void setTypeOfExemptedSource(String string) {
            this.getStringAttributes().put(SecurityAttributes.TYPE_OF_EXEMPTED_SOURCE_NAME, string);
        }

        private List<String> getListAttribute(String string) {
            if (this.getListAttributes().get(string) == null) {
                this.getListAttributes().put(string, new LazyList(String.class));
            }
            return this.getListAttributes().get(string);
        }

        private void setListAttribute(String string, List<String> list) {
            this.getListAttributes().put(string, new LazyList(list, String.class));
        }

        private Map<String, List<String>> getListAttributes() {
            return this._listAttributes;
        }

        private Map<String, String> getStringAttributes() {
            return this._stringAttributes;
        }
    }
}

