/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.security.ism;

import buri.ddmsence.AbstractSimpleString;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.ISMVocabulary;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;

public final class NoticeText
extends AbstractSimpleString {
    private List<String> _pocTypes = null;
    private static final String POC_TYPE_NAME = "pocType";

    public NoticeText(Element element) throws InvalidDDMSException {
        super(element, false);
        try {
            String string = element.getAttributeValue(POC_TYPE_NAME, this.getDDMSVersion().getIsmNamespace());
            this._pocTypes = Util.getXsListAsList(string);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public NoticeText(String string, List<String> list, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        super(PropertyReader.getPrefix("ism"), DDMSVersion.getCurrentVersion().getIsmNamespace(), NoticeText.getName(DDMSVersion.getCurrentVersion()), string, securityAttributes, false);
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            if (!list.isEmpty()) {
                Util.addAttribute(this.getXOMElement(), PropertyReader.getPrefix("ism"), POC_TYPE_NAME, DDMSVersion.getCurrentVersion().getIsmNamespace(), Util.getXsList(list));
            }
            this._pocTypes = list;
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireQName(this.getXOMElement(), this.getDDMSVersion().getIsmNamespace(), NoticeText.getName(this.getDDMSVersion()));
        this.requireVersion("4.0.1");
        if (this.getDDMSVersion().isAtLeast("4.0.1")) {
            for (String string : this.getPocTypes()) {
                ISMVocabulary.validateEnumeration("CVEnumISMPocType.xml", string);
            }
        }
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (Util.isEmpty(this.getValue())) {
            this.addWarning("An ISM:" + this.getName() + " element was found with no value.");
        }
        super.validateWarnings();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, "noticeText", string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NoticeText.buildOutput(bl, string3, this.getValue()));
        stringBuffer.append(NoticeText.buildOutput(bl, string3 + "." + POC_TYPE_NAME, Util.getXsList(this.getPocTypes())));
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3 + "."));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof NoticeText)) {
            return false;
        }
        NoticeText noticeText = (NoticeText)object;
        return Util.listEquals(this.getPocTypes(), noticeText.getPocTypes());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getPocTypes().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "NoticeText";
    }

    public List<String> getPocTypes() {
        return this._pocTypes;
    }

    public static class Builder
    extends AbstractSimpleString.Builder {
        private static final long serialVersionUID = 7750664735441105296L;
        private List<String> _pocTypes;

        public Builder() {
        }

        public Builder(NoticeText noticeText) {
            super(noticeText);
            this.setPocTypes(noticeText.getPocTypes());
        }

        @Override
        public NoticeText commit() throws InvalidDDMSException {
            return this.isEmpty() && this.getPocTypes().isEmpty() ? null : new NoticeText(this.getValue(), this.getPocTypes(), this.getSecurityAttributes().commit());
        }

        public List<String> getPocTypes() {
            if (this._pocTypes == null) {
                this._pocTypes = new LazyList(String.class);
            }
            return this._pocTypes;
        }

        public void setPocTypes(List<String> list) {
            this._pocTypes = list;
        }
    }
}

