/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.security.ism;

import buri.ddmsence.AbstractAttributeGroup;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.Resource;
import buri.ddmsence.ddms.security.ism.ISMVocabulary;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import nu.xom.Element;

public final class NoticeAttributes
extends AbstractAttributeGroup {
    private String _noticeType = null;
    private String _noticeReason = null;
    private XMLGregorianCalendar _noticeDate = null;
    private String _unregisteredNoticeType = null;
    private Boolean _externalNotice = null;
    public static final String NOTICE_TYPE_NAME = "noticeType";
    public static final String NOTICE_REASON_NAME = "noticeReason";
    public static final String NOTICE_DATE_NAME = "noticeDate";
    public static final String UNREGISTERED_NOTICE_TYPE_NAME = "unregisteredNoticeType";
    public static final String EXTERNAL_NOTICE_NAME = "externalNotice";
    public static final int MAX_LENGTH = 2048;
    private static final Set<String> ALL_NAMES = new HashSet<String>();
    public static final Set<String> NON_EXTENSIBLE_NAMES;

    public static NoticeAttributes getNonNullInstance(NoticeAttributes noticeAttributes) throws InvalidDDMSException {
        return noticeAttributes == null ? new NoticeAttributes(null, null, null, null) : noticeAttributes;
    }

    public NoticeAttributes(Element element) throws InvalidDDMSException {
        super(element.getNamespaceURI());
        String string;
        String string2 = this.getDDMSVersion().getIsmNamespace();
        this._noticeType = element.getAttributeValue(NOTICE_TYPE_NAME, string2);
        this._noticeReason = element.getAttributeValue(NOTICE_REASON_NAME, string2);
        this._unregisteredNoticeType = element.getAttributeValue(UNREGISTERED_NOTICE_TYPE_NAME, string2);
        String string3 = element.getAttributeValue(NOTICE_DATE_NAME, string2);
        if (!Util.isEmpty(string3)) {
            this._noticeDate = NoticeAttributes.getFactory().newXMLGregorianCalendar(string3);
        }
        if (!Util.isEmpty(string = element.getAttributeValue(EXTERNAL_NOTICE_NAME, string2))) {
            this._externalNotice = Boolean.valueOf(string);
        }
        this.validate();
    }

    public NoticeAttributes(String string, String string2, String string3, String string4) throws InvalidDDMSException {
        this(string, string2, string3, string4, null);
    }

    public NoticeAttributes(String string, String string2, String string3, String string4, Boolean bl) throws InvalidDDMSException {
        super(DDMSVersion.getCurrentVersion().getNamespace());
        this._noticeType = string;
        this._noticeReason = string2;
        this._unregisteredNoticeType = string4;
        if (!Util.isEmpty(string3)) {
            try {
                this._noticeDate = NoticeAttributes.getFactory().newXMLGregorianCalendar(string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidDDMSException("The ISM:noticeDate attribute is not in a valid date format.");
            }
        }
        this._externalNotice = bl;
        this.validate();
    }

    public void addTo(Element element) throws InvalidDDMSException {
        DDMSVersion dDMSVersion = DDMSVersion.getVersionForNamespace(element.getNamespaceURI());
        this.validateSameVersion(dDMSVersion);
        String string = dDMSVersion.getIsmNamespace();
        String string2 = PropertyReader.getPrefix("ism");
        Util.addAttribute(element, string2, NOTICE_TYPE_NAME, string, this.getNoticeType());
        Util.addAttribute(element, string2, NOTICE_REASON_NAME, string, this.getNoticeReason());
        if (this.getNoticeDate() != null) {
            Util.addAttribute(element, string2, NOTICE_DATE_NAME, string, this.getNoticeDate().toXMLFormat());
        }
        Util.addAttribute(element, string2, UNREGISTERED_NOTICE_TYPE_NAME, string, this.getUnregisteredNoticeType());
        if (this.isExternalReference() != null) {
            Util.addAttribute(element, string2, EXTERNAL_NOTICE_NAME, string, String.valueOf(this.isExternalReference()));
        }
    }

    public boolean isEmpty() {
        return Util.isEmpty(this.getNoticeType()) && Util.isEmpty(this.getNoticeReason()) && Util.isEmpty(this.getUnregisteredNoticeType()) && this.getNoticeDate() == null && this.isExternalReference() == null;
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        DDMSVersion dDMSVersion = this.getDDMSVersion();
        if (dDMSVersion.isAtLeast("4.0.1") && !Util.isEmpty(this.getNoticeType())) {
            ISMVocabulary.validateEnumeration("CVEnumISMNotice.xml", this.getNoticeType());
        }
        if (!Util.isEmpty(this.getNoticeReason()) && this.getNoticeReason().length() > 2048) {
            throw new InvalidDDMSException("The noticeReason attribute must be shorter than 2048 characters.");
        }
        if (!Util.isEmpty(this.getUnregisteredNoticeType()) && this.getUnregisteredNoticeType().length() > 2048) {
            throw new InvalidDDMSException("The unregisteredNoticeType attribute must be shorter than 2048 characters.");
        }
        if (this.getNoticeDate() != null && !this.getNoticeDate().getXMLSchemaType().equals(DatatypeConstants.DATE)) {
            throw new InvalidDDMSException("The noticeDate attribute must be in the xs:date format (YYYY-MM-DD).");
        }
        if (!dDMSVersion.isAtLeast("4.0.1") && !this.isEmpty()) {
            throw new InvalidDDMSException("Notice attributes cannot be used until DDMS 4.0.1 or later.");
        }
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string) {
        String string2 = Util.getNonNullString(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Resource.buildOutput(bl, string2 + NOTICE_TYPE_NAME, this.getNoticeType()));
        stringBuffer.append(Resource.buildOutput(bl, string2 + NOTICE_REASON_NAME, this.getNoticeReason()));
        if (this.getNoticeDate() != null) {
            stringBuffer.append(Resource.buildOutput(bl, string2 + NOTICE_DATE_NAME, this.getNoticeDate().toXMLFormat()));
        }
        stringBuffer.append(Resource.buildOutput(bl, string2 + UNREGISTERED_NOTICE_TYPE_NAME, this.getUnregisteredNoticeType()));
        if (this.isExternalReference() != null) {
            stringBuffer.append(Resource.buildOutput(bl, string2 + EXTERNAL_NOTICE_NAME, String.valueOf(this.isExternalReference())));
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof NoticeAttributes)) {
            return false;
        }
        NoticeAttributes noticeAttributes = (NoticeAttributes)object;
        return this.getNoticeType().equals(noticeAttributes.getNoticeType()) && this.getNoticeReason().equals(noticeAttributes.getNoticeReason()) && this.getUnregisteredNoticeType().equals(noticeAttributes.getUnregisteredNoticeType()) && Util.nullEquals(this.getNoticeDate(), noticeAttributes.getNoticeDate()) && Util.nullEquals(this.isExternalReference(), noticeAttributes.isExternalReference());
    }

    public int hashCode() {
        int n = 0;
        n = 7 * n + this.getNoticeType().hashCode();
        n = 7 * n + this.getNoticeReason().hashCode();
        n = 7 * n + this.getUnregisteredNoticeType().hashCode();
        if (this.getNoticeDate() != null) {
            n = 7 * n + this.getNoticeDate().hashCode();
        }
        if (this.isExternalReference() != null) {
            n = 7 * n + this.isExternalReference().hashCode();
        }
        return n;
    }

    public String getNoticeType() {
        return Util.getNonNullString(this._noticeType);
    }

    public String getNoticeReason() {
        return Util.getNonNullString(this._noticeReason);
    }

    public String getUnregisteredNoticeType() {
        return Util.getNonNullString(this._unregisteredNoticeType);
    }

    public Boolean isExternalReference() {
        return this._externalNotice;
    }

    public XMLGregorianCalendar getNoticeDate() {
        return this._noticeDate == null ? null : NoticeAttributes.getFactory().newXMLGregorianCalendar(this._noticeDate.toXMLFormat());
    }

    private static DatatypeFactory getFactory() {
        return Util.getDataTypeFactory();
    }

    static {
        ALL_NAMES.add(NOTICE_TYPE_NAME);
        ALL_NAMES.add(NOTICE_REASON_NAME);
        ALL_NAMES.add(NOTICE_DATE_NAME);
        ALL_NAMES.add(UNREGISTERED_NOTICE_TYPE_NAME);
        ALL_NAMES.add(EXTERNAL_NOTICE_NAME);
        NON_EXTENSIBLE_NAMES = Collections.unmodifiableSet(ALL_NAMES);
    }

    public static class Builder
    implements Serializable {
        private static final long serialVersionUID = 279072341662308051L;
        private Map<String, String> _stringAttributes = new HashMap<String, String>();
        private Boolean _externalNotice;

        public Builder() {
        }

        public Builder(NoticeAttributes noticeAttributes) {
            this.setNoticeType(noticeAttributes.getNoticeType());
            this.setNoticeReason(noticeAttributes.getNoticeReason());
            if (noticeAttributes.getNoticeDate() != null) {
                this.setNoticeDate(noticeAttributes.getNoticeDate().toXMLFormat());
            }
            this.setUnregisteredNoticeType(noticeAttributes.getUnregisteredNoticeType());
            this.setExternalNotice(noticeAttributes.isExternalReference());
        }

        public NoticeAttributes commit() throws InvalidDDMSException {
            return new NoticeAttributes(this.getNoticeType(), this.getNoticeReason(), this.getNoticeDate(), this.getUnregisteredNoticeType(), this.getExternalNotice());
        }

        public boolean isEmpty() {
            boolean bl = true;
            for (String string : this.getStringAttributes().values()) {
                bl = bl && Util.isEmpty(string);
            }
            return bl && this.getExternalNotice() == null;
        }

        public String getNoticeType() {
            return this.getStringAttributes().get(NoticeAttributes.NOTICE_TYPE_NAME);
        }

        public void setNoticeType(String string) {
            this.getStringAttributes().put(NoticeAttributes.NOTICE_TYPE_NAME, string);
        }

        public String getNoticeReason() {
            return this.getStringAttributes().get(NoticeAttributes.NOTICE_REASON_NAME);
        }

        public void setNoticeReason(String string) {
            this.getStringAttributes().put(NoticeAttributes.NOTICE_REASON_NAME, string);
        }

        public String getNoticeDate() {
            return this.getStringAttributes().get(NoticeAttributes.NOTICE_DATE_NAME);
        }

        public void setNoticeDate(String string) {
            this.getStringAttributes().put(NoticeAttributes.NOTICE_DATE_NAME, string);
        }

        public String getUnregisteredNoticeType() {
            return this.getStringAttributes().get(NoticeAttributes.UNREGISTERED_NOTICE_TYPE_NAME);
        }

        public void setUnregisteredNoticeType(String string) {
            this.getStringAttributes().put(NoticeAttributes.UNREGISTERED_NOTICE_TYPE_NAME, string);
        }

        public Boolean getExternalNotice() {
            return this._externalNotice;
        }

        public void setExternalNotice(Boolean bl) {
            this._externalNotice = bl;
        }

        private Map<String, String> getStringAttributes() {
            return this._stringAttributes;
        }
    }
}

