/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.security.ism;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.NoticeAttributes;
import buri.ddmsence.ddms.security.ism.NoticeText;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.LazyList;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;

public final class Notice
extends AbstractBaseComponent {
    private List<NoticeText> _noticeTexts = null;
    private SecurityAttributes _securityAttributes = null;
    private NoticeAttributes _noticeAttributes = null;

    public Notice(Element element) throws InvalidDDMSException {
        try {
            this.setXOMElement(element, false);
            this._noticeTexts = new ArrayList<NoticeText>();
            Elements elements = element.getChildElements(NoticeText.getName(this.getDDMSVersion()), this.getDDMSVersion().getIsmNamespace());
            for (int i = 0; i < elements.size(); ++i) {
                this._noticeTexts.add(new NoticeText(elements.get(i)));
            }
            this._noticeAttributes = new NoticeAttributes(element);
            this._securityAttributes = new SecurityAttributes(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public Notice(List<NoticeText> list, SecurityAttributes securityAttributes, NoticeAttributes noticeAttributes) throws InvalidDDMSException {
        try {
            if (list == null) {
                list = Collections.emptyList();
            }
            DDMSVersion dDMSVersion = DDMSVersion.getCurrentVersion();
            Element element = Util.buildElement(PropertyReader.getPrefix("ism"), Notice.getName(dDMSVersion), dDMSVersion.getIsmNamespace(), null);
            for (NoticeText noticeText : list) {
                element.appendChild((Node)noticeText.getXOMElementCopy());
            }
            this._noticeTexts = list;
            this._noticeAttributes = NoticeAttributes.getNonNullInstance(noticeAttributes);
            this._noticeAttributes.addTo(element);
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireQName(this.getXOMElement(), this.getDDMSVersion().getIsmNamespace(), Notice.getName(this.getDDMSVersion()));
        if (this.getNoticeTexts().isEmpty()) {
            throw new InvalidDDMSException("At least one ISM:NoticeText must exist within an ISM:Notice element.");
        }
        this.requireVersion("4.0.1");
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (!this.getNoticeAttributes().isEmpty()) {
            this.addWarnings(this.getNoticeAttributes().getValidationWarnings(), true);
            if (this.getNoticeAttributes().isExternalReference() != null) {
                this.addDdms40Warning("ISM:externalNotice attribute");
            }
        }
        super.validateWarnings();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, "notice", string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.buildOutput(bl, string3, this.getNoticeTexts()));
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        stringBuffer.append(this.getNoticeAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.addAll(this.getNoticeTexts());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof Notice)) {
            return false;
        }
        Notice notice = (Notice)object;
        return this.getNoticeAttributes().equals(notice.getNoticeAttributes());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getNoticeAttributes().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "Notice";
    }

    public List<NoticeText> getNoticeTexts() {
        return Collections.unmodifiableList(this._noticeTexts);
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public NoticeAttributes getNoticeAttributes() {
        return this._noticeAttributes;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 7750664735441105296L;
        private List<NoticeText.Builder> _noticeTexts;
        private SecurityAttributes.Builder _securityAttributes = null;
        private NoticeAttributes.Builder _noticeAttributes = null;

        public Builder() {
        }

        public Builder(Notice notice) {
            for (NoticeText noticeText : notice.getNoticeTexts()) {
                this.getNoticeTexts().add(new NoticeText.Builder(noticeText));
            }
            this.setSecurityAttributes(new SecurityAttributes.Builder(notice.getSecurityAttributes()));
            this.setNoticeAttributes(new NoticeAttributes.Builder(notice.getNoticeAttributes()));
        }

        @Override
        public Notice commit() throws InvalidDDMSException {
            if (this.isEmpty()) {
                return null;
            }
            ArrayList<NoticeText> arrayList = new ArrayList<NoticeText>();
            for (IBuilder iBuilder : this.getNoticeTexts()) {
                NoticeText noticeText = (NoticeText)iBuilder.commit();
                if (noticeText == null) continue;
                arrayList.add(noticeText);
            }
            return new Notice(arrayList, this.getSecurityAttributes().commit(), this.getNoticeAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            boolean bl = false;
            for (IBuilder iBuilder : this.getNoticeTexts()) {
                bl = bl || !iBuilder.isEmpty();
            }
            return !bl && this.getSecurityAttributes().isEmpty() && this.getNoticeAttributes().isEmpty();
        }

        public List<NoticeText.Builder> getNoticeTexts() {
            if (this._noticeTexts == null) {
                this._noticeTexts = new LazyList(NoticeText.Builder.class);
            }
            return this._noticeTexts;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }

        public NoticeAttributes.Builder getNoticeAttributes() {
            if (this._noticeAttributes == null) {
                this._noticeAttributes = new NoticeAttributes.Builder();
            }
            return this._noticeAttributes;
        }

        public void setNoticeAttributes(NoticeAttributes.Builder builder) {
            this._noticeAttributes = builder;
        }
    }
}

