/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.security.ism;

import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.PropertyReader;
import buri.ddmsence.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ISMVocabulary {
    public static final String CVE_DECLASS_EXCEPTION = "CVEnumISM25X.xml";
    public static final String CVE_ATOMIC_ENERGY_MARKINGS = "CVEnumISMAtomicEnergyMarkings.xml";
    public static final String CVE_ALL_CLASSIFICATIONS = "CVEnumISMClassificationAll.xml";
    public static final String CVE_US_CLASSIFICATIONS = "CVEnumISMClassificationUS.xml";
    public static final String CVE_COMPLIES_WITH = "CVEnumISMCompliesWith.xml";
    public static final String CVE_DISPLAY_ONLY_TO = "CVEnumISMRelTo.xml";
    public static final String CVE_DISSEMINATION_CONTROLS = "CVEnumISMDissem.xml";
    public static final String CVE_FGI_SOURCE_OPEN = "CVEnumISMFGIOpen.xml";
    public static final String CVE_FGI_SOURCE_PROTECTED = "CVEnumISMFGIProtected.xml";
    public static final String CVE_NON_IC_MARKINGS = "CVEnumISMNonIC.xml";
    public static final String CVE_NON_US_CONTROLS = "CVEnumISMNonUSControls.xml";
    public static final String CVE_NOTICE_TYPE = "CVEnumISMNotice.xml";
    public static final String CVE_OWNER_PRODUCERS = "CVEnumISMOwnerProducer.xml";
    public static final String CVE_POC_TYPE = "CVEnumISMPocType.xml";
    public static final String CVE_RELEASABLE_TO = "CVEnumISMRelTo.xml";
    public static final String CVE_SAR_IDENTIFIER = "CVEnumISMSAR.xml";
    public static final String CVE_SCI_CONTROLS = "CVEnumISMSCIControls.xml";
    public static final String CVE_TYPE_EXEMPTED_SOURCE = "CVEnumISMSourceMarked.xml";
    private static Set<String> COMMON_NETWORK_TYPES = new HashSet<String>();
    private static final List<String> ALL_ENUMS;
    private static final Map<String, Map<String, Set<String>>> LOCATION_TO_ENUM_TOKENS;
    private static final Map<String, Map<String, Set<String>>> LOCATION_TO_ENUM_PATTERNS;
    private static final String ENUMERATION_NAME = "Enumeration";
    private static final String TERM_NAME = "Term";
    private static final String VALUE_NAME = "Value";
    private static final String REG_EXP_NAME = "regularExpression";
    private static String _lastEnumLocation;
    private static DDMSVersion _ddmsVersion;

    private ISMVocabulary() {
    }

    public static synchronized void setDDMSVersion(DDMSVersion dDMSVersion) {
        _ddmsVersion = dDMSVersion;
    }

    private static synchronized void updateEnumLocation() {
        String string = PropertyReader.getProperty(ISMVocabulary.getDDMSVersion().getVersion() + ".ism.cveLocation");
        if (ISMVocabulary.getLastEnumLocation() == null || !ISMVocabulary.getLastEnumLocation().equals(string)) {
            _lastEnumLocation = string;
            if (LOCATION_TO_ENUM_TOKENS.get(ISMVocabulary.getLastEnumLocation()) == null) {
                try {
                    LOCATION_TO_ENUM_TOKENS.put(ISMVocabulary.getLastEnumLocation(), new HashMap());
                    LOCATION_TO_ENUM_PATTERNS.put(ISMVocabulary.getLastEnumLocation(), new HashMap());
                    XMLReader xMLReader = XMLReaderFactory.createXMLReader(PropertyReader.getProperty("xml.reader.class"));
                    Builder builder = new Builder(xMLReader, false);
                    for (String string2 : ALL_ENUMS) {
                        try {
                            ISMVocabulary.loadEnumeration(string, builder, string2);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (SAXException sAXException) {
                    throw new RuntimeException("Could not load controlled vocabularies: " + sAXException.getMessage());
                }
            }
        }
    }

    private static void loadEnumeration(String string, Builder builder, String string2) throws ParsingException, IOException {
        InputStream inputStream = new ISMVocabulary().getClass().getResourceAsStream(string + string2);
        Document document = builder.build(inputStream);
        TreeSet<String> treeSet = new TreeSet<String>();
        HashSet<String> hashSet = new HashSet<String>();
        String string3 = PropertyReader.getProperty(ISMVocabulary.getDDMSVersion().getVersion() + ".ism.cve.xmlNamespace");
        Element element = document.getRootElement().getFirstChildElement(ENUMERATION_NAME, string3);
        Elements elements = element.getChildElements(TERM_NAME, string3);
        for (int i = 0; i < elements.size(); ++i) {
            Element element2 = elements.get(i).getFirstChildElement(VALUE_NAME, string3);
            boolean bl = Boolean.valueOf(element2.getAttributeValue(REG_EXP_NAME));
            if (element2 == null) continue;
            if (bl) {
                hashSet.add(element2.getValue());
                continue;
            }
            treeSet.add(element2.getValue());
        }
        LOCATION_TO_ENUM_TOKENS.get(ISMVocabulary.getLastEnumLocation()).put(string2, treeSet);
        LOCATION_TO_ENUM_PATTERNS.get(ISMVocabulary.getLastEnumLocation()).put(string2, hashSet);
    }

    public static Set<String> getEnumerationTokens(String string) {
        ISMVocabulary.updateEnumLocation();
        Set<String> set = LOCATION_TO_ENUM_TOKENS.get(ISMVocabulary.getLastEnumLocation()).get(string);
        if (set == null) {
            throw new IllegalArgumentException("No controlled vocabulary could be found for this key: " + string);
        }
        return Collections.unmodifiableSet(set);
    }

    private static Set<String> getEnumerationPatterns(String string) {
        ISMVocabulary.updateEnumLocation();
        Set<String> set = LOCATION_TO_ENUM_PATTERNS.get(ISMVocabulary.getLastEnumLocation()).get(string);
        return Collections.unmodifiableSet(set);
    }

    public static void validateEnumeration(String string, String string2) throws InvalidDDMSException {
        ISMVocabulary.setDDMSVersion(ISMVocabulary.getDDMSVersion());
        if (!ISMVocabulary.enumContains(string, string2)) {
            String string3 = ISMVocabulary.getInvalidMessage(string, string2);
            throw new InvalidDDMSException(string3);
        }
    }

    protected static boolean enumContains(String string, String string2) {
        Util.requireValue("key", string);
        boolean bl = ISMVocabulary.getEnumerationTokens(string).contains(string2);
        if (!bl) {
            for (String string3 : ISMVocabulary.getEnumerationPatterns(string)) {
                Pattern pattern = Pattern.compile(string3);
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.matches()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static boolean usingOldClassification(String string) {
        return "NS-S".equals(string) || "NS-A".equals(string);
    }

    public static String getInvalidMessage(String string, String string2) {
        return string2 + " is not a valid enumeration token for this attribute, as specified in " + string + ".";
    }

    public static void requireValidNetwork(String string) throws InvalidDDMSException {
        if (!COMMON_NETWORK_TYPES.contains(string)) {
            throw new InvalidDDMSException("The network attribute must be one of " + COMMON_NETWORK_TYPES);
        }
    }

    private static String getLastEnumLocation() {
        return _lastEnumLocation;
    }

    private static DDMSVersion getDDMSVersion() {
        return _ddmsVersion;
    }

    static {
        COMMON_NETWORK_TYPES.add("NIPRNet");
        COMMON_NETWORK_TYPES.add("SIPRNet");
        COMMON_NETWORK_TYPES.add("JWICS");
        COMMON_NETWORK_TYPES.add("ADSN");
        COMMON_NETWORK_TYPES.add("StoneGhost");
        COMMON_NETWORK_TYPES.add("LOCE");
        COMMON_NETWORK_TYPES.add("CRONOS");
        COMMON_NETWORK_TYPES.add("other");
        ALL_ENUMS = new ArrayList<String>();
        ALL_ENUMS.add(CVE_DECLASS_EXCEPTION);
        ALL_ENUMS.add(CVE_ATOMIC_ENERGY_MARKINGS);
        ALL_ENUMS.add(CVE_ALL_CLASSIFICATIONS);
        ALL_ENUMS.add(CVE_US_CLASSIFICATIONS);
        ALL_ENUMS.add(CVE_COMPLIES_WITH);
        ALL_ENUMS.add(CVE_DISSEMINATION_CONTROLS);
        ALL_ENUMS.add("CVEnumISMRelTo.xml");
        ALL_ENUMS.add(CVE_FGI_SOURCE_OPEN);
        ALL_ENUMS.add(CVE_FGI_SOURCE_PROTECTED);
        ALL_ENUMS.add(CVE_NON_IC_MARKINGS);
        ALL_ENUMS.add(CVE_NON_US_CONTROLS);
        ALL_ENUMS.add(CVE_NOTICE_TYPE);
        ALL_ENUMS.add(CVE_OWNER_PRODUCERS);
        ALL_ENUMS.add(CVE_POC_TYPE);
        ALL_ENUMS.add("CVEnumISMRelTo.xml");
        ALL_ENUMS.add(CVE_SAR_IDENTIFIER);
        ALL_ENUMS.add(CVE_SCI_CONTROLS);
        ALL_ENUMS.add(CVE_TYPE_EXEMPTED_SOURCE);
        LOCATION_TO_ENUM_TOKENS = new HashMap<String, Map<String, Set<String>>>();
        LOCATION_TO_ENUM_PATTERNS = new HashMap<String, Map<String, Set<String>>>();
        _lastEnumLocation = null;
        ISMVocabulary.setDDMSVersion(DDMSVersion.getCurrentVersion());
    }
}

