/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.resource;

import buri.ddmsence.AbstractQualifierValue;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import nu.xom.Element;

public final class Type
extends AbstractQualifierValue {
    private SecurityAttributes _securityAttributes = null;

    public Type(Element element) throws InvalidDDMSException {
        try {
            this._securityAttributes = new SecurityAttributes(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public Type(String string, String string2, String string3, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        super(Type.getName(DDMSVersion.getCurrentVersion()), string2, string3, false);
        try {
            Element element = this.getXOMElement();
            if (!Util.isEmpty(string)) {
                element.appendChild(string);
            }
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), Type.getName(this.getDDMSVersion()));
        if (!Util.isEmpty(this.getValue())) {
            Util.requireDDMSValue("qualifier attribute", this.getQualifier());
        }
        if (!this.getDDMSVersion().isAtLeast("4.0.1") && !Util.isEmpty(this.getDescription())) {
            throw new InvalidDDMSException("This component cannot contain description child text until DDMS 4.0.1 or later.");
        }
        if (!this.getDDMSVersion().isAtLeast("4.0.1") && !this.getSecurityAttributes().isEmpty()) {
            throw new InvalidDDMSException("Security attributes cannot be applied to this component until DDMS 4.0.1 or later.");
        }
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (!Util.isEmpty(this.getQualifier()) && Util.isEmpty(this.getValue())) {
            this.addWarning("A qualifier has been set without an accompanying value attribute.");
        }
        if (Util.isEmpty(this.getQualifier()) && Util.isEmpty(this.getValue())) {
            this.addWarning("Neither a qualifier nor a value was set on this type.");
        }
        super.validateWarnings();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Type.buildOutput(bl, string3 + "description", this.getDescription()));
        stringBuffer.append(Type.buildOutput(bl, string3 + "qualifier", this.getQualifier()));
        stringBuffer.append(Type.buildOutput(bl, string3 + "value", this.getValue()));
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof Type)) {
            return false;
        }
        Type type = (Type)object;
        return this.getDescription().equals(type.getDescription());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getDescription().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "type";
    }

    public String getDescription() {
        return this.getXOMElement().getValue();
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public static class Builder
    extends AbstractQualifierValue.Builder {
        private static final long serialVersionUID = 4388694130954618393L;
        private String _description;
        private SecurityAttributes.Builder _securityAttributes;

        public Builder() {
        }

        public Builder(Type type) {
            super(type);
            this.setDescription(type.getDescription());
            this.setSecurityAttributes(new SecurityAttributes.Builder(type.getSecurityAttributes()));
        }

        @Override
        public Type commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new Type(this.getDescription(), this.getQualifier(), this.getValue(), this.getSecurityAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && Util.isEmpty(this.getDescription()) && this.getSecurityAttributes().isEmpty();
        }

        public String getDescription() {
            return this._description;
        }

        public void setDescription(String string) {
            this._description = string;
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }
    }
}

