/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.resource;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.ISMVocabulary;
import buri.ddmsence.ddms.summary.xlink.XLinkAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import nu.xom.Element;

public final class TaskID
extends AbstractBaseComponent {
    private XLinkAttributes _xlinkAttributes = null;
    private static final String FIXED_TYPE = "simple";
    public static final String NO_PREFIX = "";
    public static final String NO_NAMESPACE = "";
    private static final String NETWORK_NAME = "network";
    private static final String OTHER_NETWORK_NAME = "otherNetwork";
    private static final String TASKING_SYSTEM_NAME = "taskingSystem";

    public TaskID(Element element) throws InvalidDDMSException {
        try {
            this._xlinkAttributes = new XLinkAttributes(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public TaskID(String string, String string2, String string3, String string4, XLinkAttributes xLinkAttributes) throws InvalidDDMSException {
        try {
            Element element = Util.buildDDMSElement(TaskID.getName(DDMSVersion.getCurrentVersion()), string);
            Util.addDDMSAttribute(element, TASKING_SYSTEM_NAME, string2);
            Util.addAttribute(element, "", NETWORK_NAME, "", string3);
            Util.addAttribute(element, "", OTHER_NETWORK_NAME, "", string4);
            this._xlinkAttributes = XLinkAttributes.getNonNullInstance(xLinkAttributes);
            this._xlinkAttributes.addTo(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), TaskID.getName(this.getDDMSVersion()));
        Util.requireDDMSValue("value", this.getValue());
        if (!Util.isEmpty(this.getXLinkAttributes().getType()) && !this.getXLinkAttributes().getType().equals(FIXED_TYPE)) {
            throw new InvalidDDMSException("The type attribute must have a fixed value of \"simple\".");
        }
        if (!Util.isEmpty(this.getNetwork())) {
            ISMVocabulary.requireValidNetwork(this.getNetwork());
        }
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (this.getXLinkAttributes() != null) {
            this.addWarnings(this.getXLinkAttributes().getValidationWarnings(), true);
        }
        super.validateWarnings();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TaskID.buildOutput(bl, string3, this.getValue()));
        stringBuffer.append(TaskID.buildOutput(bl, string3 + "." + TASKING_SYSTEM_NAME, this.getTaskingSystem()));
        stringBuffer.append(TaskID.buildOutput(bl, string3 + "." + NETWORK_NAME, this.getNetwork()));
        stringBuffer.append(TaskID.buildOutput(bl, string3 + "." + OTHER_NETWORK_NAME, this.getOtherNetwork()));
        stringBuffer.append(this.getXLinkAttributes().getOutput(bl, string3 + "."));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof TaskID)) {
            return false;
        }
        TaskID taskID = (TaskID)object;
        return this.getValue().equals(taskID.getValue()) && this.getTaskingSystem().equals(taskID.getTaskingSystem()) && this.getNetwork().equals(taskID.getNetwork()) && this.getOtherNetwork().equals(taskID.getOtherNetwork()) && this.getXLinkAttributes().equals(taskID.getXLinkAttributes());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getValue().hashCode();
        n = 7 * n + this.getTaskingSystem().hashCode();
        n = 7 * n + this.getNetwork().hashCode();
        n = 7 * n + this.getOtherNetwork().hashCode();
        n = 7 * n + this.getXLinkAttributes().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "taskID";
    }

    public String getValue() {
        return this.getXOMElement().getValue();
    }

    public String getTaskingSystem() {
        return this.getAttributeValue(TASKING_SYSTEM_NAME);
    }

    public String getNetwork() {
        return this.getAttributeValue(NETWORK_NAME, "");
    }

    public String getOtherNetwork() {
        return this.getAttributeValue(OTHER_NETWORK_NAME, "");
    }

    public XLinkAttributes getXLinkAttributes() {
        return this._xlinkAttributes;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 4325950371570699184L;
        private String _value;
        private String _taskingSystem;
        private String _network;
        private String _otherNetwork;
        private XLinkAttributes.Builder _xlinkAttributes;

        public Builder() {
        }

        public Builder(TaskID taskID) {
            this.setValue(taskID.getValue());
            this.setTaskingSystem(taskID.getTaskingSystem());
            this.setNetwork(taskID.getNetwork());
            this.setOtherNetwork(taskID.getOtherNetwork());
            this.setXLinkAttributes(new XLinkAttributes.Builder(taskID.getXLinkAttributes()));
        }

        @Override
        public TaskID commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new TaskID(this.getValue(), this.getTaskingSystem(), this.getNetwork(), this.getOtherNetwork(), this.getXLinkAttributes().commit());
        }

        @Override
        public boolean isEmpty() {
            return Util.isEmpty(this.getValue()) && Util.isEmpty(this.getTaskingSystem()) && Util.isEmpty(this.getNetwork()) && Util.isEmpty(this.getOtherNetwork()) && this.getXLinkAttributes().isEmpty();
        }

        public String getValue() {
            return this._value;
        }

        public void setValue(String string) {
            this._value = string;
        }

        public String getTaskingSystem() {
            return this._taskingSystem;
        }

        public void setTaskingSystem(String string) {
            this._taskingSystem = string;
        }

        public String getNetwork() {
            return this._network;
        }

        public void setNetwork(String string) {
            this._network = string;
        }

        public String getOtherNetwork() {
            return this._otherNetwork;
        }

        public void setOtherNetwork(String string) {
            this._otherNetwork = string;
        }

        public XLinkAttributes.Builder getXLinkAttributes() {
            if (this._xlinkAttributes == null) {
                this._xlinkAttributes = new XLinkAttributes.Builder();
            }
            return this._xlinkAttributes;
        }

        public void setXLinkAttributes(XLinkAttributes.Builder builder) {
            this._xlinkAttributes = builder;
        }
    }
}

