/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.resource;

import buri.ddmsence.AbstractSimpleString;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import nu.xom.Element;

public final class Subtitle
extends AbstractSimpleString {
    public Subtitle(Element element) throws InvalidDDMSException {
        super(element, true);
    }

    public Subtitle(String string, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        super(Subtitle.getName(DDMSVersion.getCurrentVersion()), string, securityAttributes, true);
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), Subtitle.getName(this.getDDMSVersion()));
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (Util.isEmpty(this.getValue())) {
            this.addWarning("A ddms:subtitle element was found with no subtitle value.");
        }
        super.validateWarnings();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Subtitle.buildOutput(bl, string3, this.getValue()));
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3 + "."));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof Subtitle;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "subtitle";
    }

    public static class Builder
    extends AbstractSimpleString.Builder {
        private static final long serialVersionUID = -4292523556431396882L;

        public Builder() {
        }

        public Builder(Subtitle subtitle) {
            super(subtitle);
        }

        @Override
        public Subtitle commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new Subtitle(this.getValue(), this.getSecurityAttributes().commit());
        }
    }
}

