/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.resource;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.resource.ApplicationSoftware;
import buri.ddmsence.ddms.resource.RecordKeeper;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;

public final class RecordsManagementInfo
extends AbstractBaseComponent {
    private RecordKeeper _recordKeeper = null;
    private ApplicationSoftware _applicationSoftware = null;
    private static final String VITAL_RECORD_INDICATOR_NAME = "vitalRecordIndicator";

    public RecordsManagementInfo(Element element) throws InvalidDDMSException {
        try {
            Element element2;
            this.setXOMElement(element, false);
            Element element3 = element.getFirstChildElement(RecordKeeper.getName(this.getDDMSVersion()), this.getNamespace());
            if (element3 != null) {
                this._recordKeeper = new RecordKeeper(element3);
            }
            if ((element2 = element.getFirstChildElement(ApplicationSoftware.getName(this.getDDMSVersion()), this.getNamespace())) != null) {
                this._applicationSoftware = new ApplicationSoftware(element2);
            }
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public RecordsManagementInfo(RecordKeeper recordKeeper, ApplicationSoftware applicationSoftware, Boolean bl) throws InvalidDDMSException {
        try {
            Element element = Util.buildDDMSElement(RecordsManagementInfo.getName(DDMSVersion.getCurrentVersion()), null);
            this.setXOMElement(element, false);
            if (recordKeeper != null) {
                element.appendChild((Node)recordKeeper.getXOMElementCopy());
            }
            if (applicationSoftware != null) {
                element.appendChild((Node)applicationSoftware.getXOMElementCopy());
            }
            Util.addDDMSAttribute(element, VITAL_RECORD_INDICATOR_NAME, String.valueOf(bl));
            this._recordKeeper = recordKeeper;
            this._applicationSoftware = applicationSoftware;
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), RecordsManagementInfo.getName(this.getDDMSVersion()));
        Util.requireBoundedChildCount(this.getXOMElement(), RecordKeeper.getName(this.getDDMSVersion()), 0, 1);
        Util.requireBoundedChildCount(this.getXOMElement(), ApplicationSoftware.getName(this.getDDMSVersion()), 0, 1);
        this.requireVersion("4.0.1");
        super.validate();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getRecordKeeper() != null) {
            stringBuffer.append(this.getRecordKeeper().getOutput(bl, string3, ""));
        }
        if (this.getApplicationSoftware() != null) {
            stringBuffer.append(this.getApplicationSoftware().getOutput(bl, string3, ""));
        }
        stringBuffer.append(RecordsManagementInfo.buildOutput(bl, string3 + VITAL_RECORD_INDICATOR_NAME, String.valueOf(this.getVitalRecordIndicator())));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.add(this.getRecordKeeper());
        arrayList.add(this.getApplicationSoftware());
        return arrayList;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof RecordsManagementInfo)) {
            return false;
        }
        RecordsManagementInfo recordsManagementInfo = (RecordsManagementInfo)object;
        return this.getVitalRecordIndicator().equals(recordsManagementInfo.getVitalRecordIndicator());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getVitalRecordIndicator().hashCode();
        return n;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "recordsManagementInfo";
    }

    public RecordKeeper getRecordKeeper() {
        return this._recordKeeper;
    }

    public ApplicationSoftware getApplicationSoftware() {
        return this._applicationSoftware;
    }

    public Boolean getVitalRecordIndicator() {
        String string = this.getAttributeValue(VITAL_RECORD_INDICATOR_NAME, this.getNamespace());
        if ("true".equals(string)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = 7851044806424206976L;
        private RecordKeeper.Builder _recordKeeper;
        private ApplicationSoftware.Builder _applicationSoftware;
        private Boolean _vitalRecordIndicator;

        public Builder() {
        }

        public Builder(RecordsManagementInfo recordsManagementInfo) {
            if (recordsManagementInfo.getRecordKeeper() != null) {
                this.setRecordKeeper(new RecordKeeper.Builder(recordsManagementInfo.getRecordKeeper()));
            }
            if (recordsManagementInfo.getApplicationSoftware() != null) {
                this.setApplicationSoftware(new ApplicationSoftware.Builder(recordsManagementInfo.getApplicationSoftware()));
            }
            this.setVitalRecordIndicator(recordsManagementInfo.getVitalRecordIndicator());
        }

        @Override
        public RecordsManagementInfo commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new RecordsManagementInfo(this.getRecordKeeper().commit(), this.getApplicationSoftware().commit(), this.getVitalRecordIndicator());
        }

        @Override
        public boolean isEmpty() {
            return this.getRecordKeeper().isEmpty() && this.getApplicationSoftware().isEmpty() && this.getVitalRecordIndicator() == null;
        }

        public RecordKeeper.Builder getRecordKeeper() {
            if (this._recordKeeper == null) {
                this._recordKeeper = new RecordKeeper.Builder();
            }
            return this._recordKeeper;
        }

        public void setRecordKeeper(RecordKeeper.Builder builder) {
            this._recordKeeper = builder;
        }

        public ApplicationSoftware.Builder getApplicationSoftware() {
            if (this._applicationSoftware == null) {
                this._applicationSoftware = new ApplicationSoftware.Builder();
            }
            return this._applicationSoftware;
        }

        public void setApplicationSoftware(ApplicationSoftware.Builder builder) {
            this._applicationSoftware = builder;
        }

        public Boolean getVitalRecordIndicator() {
            return this._vitalRecordIndicator;
        }

        public void setVitalRecordIndicator(Boolean bl) {
            this._vitalRecordIndicator = bl;
        }
    }
}

