/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms.format;

import buri.ddmsence.AbstractQualifierValue;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import nu.xom.Element;

public final class Extent
extends AbstractQualifierValue {
    public Extent(Element element) throws InvalidDDMSException {
        super(element);
    }

    public Extent(String string, String string2) throws InvalidDDMSException {
        super(Extent.getName(DDMSVersion.getCurrentVersion()), string, string2, true);
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSQName(this.getXOMElement(), Extent.getName(this.getDDMSVersion()));
        if (!Util.isEmpty(this.getValue())) {
            Util.requireDDMSValue("qualifier attribute", this.getQualifier());
        }
        if (!Util.isEmpty(this.getQualifier())) {
            Util.requireDDMSValidURI(this.getQualifier());
        }
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (!Util.isEmpty(this.getQualifier()) && Util.isEmpty(this.getValue())) {
            this.addWarning("A qualifier has been set without an accompanying value attribute.");
        }
        if (Util.isEmpty(this.getQualifier()) && Util.isEmpty(this.getValue())) {
            this.addWarning("A completely empty ddms:extent element was found.");
        }
        super.validateWarnings();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Extent.buildOutput(bl, string3 + "qualifier", this.getQualifier()));
        stringBuffer.append(Extent.buildOutput(bl, string3 + "value", this.getValue()));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof Extent;
    }

    public static String getName(DDMSVersion dDMSVersion) {
        Util.requireValue("version", dDMSVersion);
        return "extent";
    }

    public static class Builder
    extends AbstractQualifierValue.Builder {
        private static final long serialVersionUID = -5658005476173591056L;

        public Builder() {
        }

        public Builder(Extent extent) {
            super(extent);
        }

        @Override
        public Extent commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new Extent(this.getQualifier(), this.getValue());
        }

        @Override
        public boolean isEmpty() {
            return Util.isEmpty(this.getQualifier()) && Util.isEmpty(this.getValue());
        }
    }
}

