/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence.ddms;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import nu.xom.Element;
import nu.xom.Node;

public final class ApproximableDate
extends AbstractBaseComponent {
    private static final String DESCRIPTION_NAME = "description";
    private static final String APPROXIMABLE_DATE_NAME = "approximableDate";
    private static final String APPROXIMATION_NAME = "approximation";
    private static final String SEARCHABLE_DATE_NAME = "searchableDate";
    private static final String START_NAME = "start";
    private static final String END_NAME = "end";
    private static Set<String> APPROXIMATION_TYPES = new HashSet<String>();
    private static Set<String> NAME_TYPES;

    public ApproximableDate(Element element) throws InvalidDDMSException {
        super.setXOMElement(element, true);
    }

    public ApproximableDate(String string, String string2, String string3, String string4, String string5, String string6) throws InvalidDDMSException {
        try {
            Element element;
            Element element2 = Util.buildDDMSElement(string, null);
            this.setXOMElement(element2, false);
            if (!Util.isEmpty(string2)) {
                Util.addDDMSChildElement(this.getXOMElement(), DESCRIPTION_NAME, string2);
            }
            if (!Util.isEmpty(string3) || Util.isEmpty(string4)) {
                element = Util.buildDDMSElement(APPROXIMABLE_DATE_NAME, string3);
                Util.addDDMSAttribute(element, APPROXIMATION_NAME, string4);
                this.getXOMElement().appendChild((Node)element);
            }
            if (!Util.isEmpty(string5) || Util.isEmpty(string6)) {
                element = Util.buildDDMSElement(SEARCHABLE_DATE_NAME, null);
                Util.addDDMSChildElement(element, START_NAME, string5);
                Util.addDDMSChildElement(element, END_NAME, string6);
                this.getXOMElement().appendChild((Node)element);
            }
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    public static void validateApproximation(String string) throws InvalidDDMSException {
        Util.requireDDMSValue(APPROXIMATION_NAME, string);
        if (!APPROXIMATION_TYPES.contains(string)) {
            throw new InvalidDDMSException("The approximation must be one of " + APPROXIMATION_TYPES);
        }
    }

    public static void validateElementName(String string) throws InvalidDDMSException {
        Util.requireDDMSValue("name", string);
        if (!NAME_TYPES.contains(string)) {
            throw new InvalidDDMSException("The element name must be one of " + NAME_TYPES);
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        ApproximableDate.validateElementName(this.getName());
        if (!Util.isEmpty(this.getApproximableDateString())) {
            Util.requireDDMSDateFormat(this.getApproximableDateString(), this.getNamespace());
        }
        if (!Util.isEmpty(this.getApproximation())) {
            ApproximableDate.validateApproximation(this.getApproximation());
        }
        if (!Util.isEmpty(this.getSearchableStartString())) {
            Util.requireDDMSDateFormat(this.getSearchableStartString(), this.getNamespace());
        }
        if (!Util.isEmpty(this.getSearchableEndString())) {
            Util.requireDDMSDateFormat(this.getSearchableEndString(), this.getNamespace());
        }
        this.requireVersion("4.1");
        super.validate();
    }

    @Override
    protected void validateWarnings() {
        if (Util.isEmpty(this.getDescription()) && Util.isEmpty(this.getApproximableDateString()) && Util.isEmpty(this.getApproximation()) && Util.isEmpty(this.getSearchableStartString()) && Util.isEmpty(this.getSearchableEndString())) {
            this.addWarning("A completely empty " + this.getQualifiedName() + " element was found.");
        }
        if (this.getChild(DESCRIPTION_NAME) != null && Util.isEmpty(this.getDescription())) {
            this.addWarning("A completely empty ddms:description element was found.");
        }
        super.validateWarnings();
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ApproximableDate.buildOutput(bl, string3 + "." + DESCRIPTION_NAME, this.getDescription()));
        stringBuffer.append(ApproximableDate.buildOutput(bl, string3 + "." + APPROXIMABLE_DATE_NAME, this.getApproximableDateString()));
        stringBuffer.append(ApproximableDate.buildOutput(bl, string3 + "." + APPROXIMABLE_DATE_NAME + "." + APPROXIMATION_NAME, this.getApproximation()));
        stringBuffer.append(ApproximableDate.buildOutput(bl, string3 + "." + SEARCHABLE_DATE_NAME + "." + START_NAME, this.getSearchableStartString()));
        stringBuffer.append(ApproximableDate.buildOutput(bl, string3 + "." + SEARCHABLE_DATE_NAME + "." + END_NAME, this.getSearchableEndString()));
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof ApproximableDate)) {
            return false;
        }
        ApproximableDate approximableDate = (ApproximableDate)object;
        return this.getDescription().equals(approximableDate.getDescription()) && this.getApproximableDateString().equals(approximableDate.getApproximableDateString()) && this.getApproximation().equals(approximableDate.getApproximation()) && this.getSearchableStartString().equals(approximableDate.getSearchableStartString()) && this.getSearchableEndString().equals(approximableDate.getSearchableEndString());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 7 * n + this.getDescription().hashCode();
        n = 7 * n + this.getApproximableDateString().hashCode();
        n = 7 * n + this.getApproximation().hashCode();
        n = 7 * n + this.getSearchableStartString().hashCode();
        n = 7 * n + this.getSearchableEndString().hashCode();
        return n;
    }

    public String getDescription() {
        Element element = this.getChild(DESCRIPTION_NAME);
        return element == null ? "" : Util.getNonNullString(element.getValue());
    }

    public String getApproximableDateString() {
        Element element = this.getChild(APPROXIMABLE_DATE_NAME);
        return element == null ? "" : Util.getNonNullString(element.getValue());
    }

    public String getApproximation() {
        String string = null;
        Element element = this.getChild(APPROXIMABLE_DATE_NAME);
        if (element != null) {
            string = element.getAttributeValue(APPROXIMATION_NAME, this.getNamespace());
        }
        return Util.getNonNullString(string);
    }

    public String getSearchableStartString() {
        Element element;
        String string = "";
        Element element2 = this.getChild(SEARCHABLE_DATE_NAME);
        if (element2 != null && (element = element2.getFirstChildElement(START_NAME, this.getNamespace())) != null) {
            string = Util.getNonNullString(element.getValue());
        }
        return string;
    }

    public String getSearchableEndString() {
        Element element;
        String string = "";
        Element element2 = this.getChild(SEARCHABLE_DATE_NAME);
        if (element2 != null && (element = element2.getFirstChildElement(END_NAME, this.getNamespace())) != null) {
            string = Util.getNonNullString(element.getValue());
        }
        return string;
    }

    static {
        APPROXIMATION_TYPES.add("1st qtr");
        APPROXIMATION_TYPES.add("2nd qtr");
        APPROXIMATION_TYPES.add("3rd qtr");
        APPROXIMATION_TYPES.add("4th qtr");
        APPROXIMATION_TYPES.add("circa");
        APPROXIMATION_TYPES.add("early");
        APPROXIMATION_TYPES.add("mid");
        APPROXIMATION_TYPES.add("late");
        NAME_TYPES = new HashSet<String>();
        NAME_TYPES.add("acquiredOn");
        NAME_TYPES.add("approximableStart");
        NAME_TYPES.add("approximableEnd");
    }

    public static class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = -7348511606867959470L;
        private String _name;
        private String _description;
        private String _approximableDate;
        private String _approximation;
        private String _searchableStart;
        private String _searchableEnd;

        public Builder() {
        }

        public Builder(ApproximableDate approximableDate) {
            this.setName(approximableDate.getName());
            this.setDescription(approximableDate.getDescription());
            this.setApproximableDate(approximableDate.getApproximableDateString());
            this.setApproximation(approximableDate.getApproximation());
            this.setSearchableStart(approximableDate.getSearchableStartString());
            this.setSearchableEnd(approximableDate.getSearchableEndString());
        }

        @Override
        public ApproximableDate commit() throws InvalidDDMSException {
            return this.isEmpty() ? null : new ApproximableDate(this.getName(), this.getDescription(), this.getApproximableDate(), this.getApproximation(), this.getSearchableStart(), this.getSearchableEnd());
        }

        @Override
        public boolean isEmpty() {
            return Util.isEmpty(this.getDescription()) && Util.isEmpty(this.getApproximableDate()) && Util.isEmpty(this.getApproximation()) && Util.isEmpty(this.getSearchableStart()) && Util.isEmpty(this.getSearchableEnd());
        }

        public String getName() {
            return this._name;
        }

        public void setName(String string) {
            this._name = string;
        }

        public String getDescription() {
            return this._description;
        }

        public void setDescription(String string) {
            this._description = string;
        }

        public String getApproximableDate() {
            return this._approximableDate;
        }

        public void setApproximableDate(String string) {
            this._approximableDate = string;
        }

        public String getApproximation() {
            return this._approximation;
        }

        public void setApproximation(String string) {
            this._approximation = string;
        }

        public String getSearchableStart() {
            return this._searchableStart;
        }

        public void setSearchableStart(String string) {
            this._searchableStart = string;
        }

        public String getSearchableEnd() {
            return this._searchableEnd;
        }

        public void setSearchableEnd(String string) {
            this._searchableEnd = string;
        }
    }
}

