/*
 * Decompiled with CFR 0.152.
 */
package buri.ddmsence;

import buri.ddmsence.AbstractBaseComponent;
import buri.ddmsence.ddms.IBuilder;
import buri.ddmsence.ddms.IDDMSComponent;
import buri.ddmsence.ddms.IRoleEntity;
import buri.ddmsence.ddms.InvalidDDMSException;
import buri.ddmsence.ddms.resource.Organization;
import buri.ddmsence.ddms.resource.Person;
import buri.ddmsence.ddms.security.ism.SecurityAttributes;
import buri.ddmsence.util.DDMSVersion;
import buri.ddmsence.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;

public abstract class AbstractTaskingRole
extends AbstractBaseComponent {
    private IRoleEntity _entity = null;
    private SecurityAttributes _securityAttributes = null;

    protected AbstractTaskingRole(Element element) throws InvalidDDMSException {
        try {
            this.setXOMElement(element, false);
            if (element.getChildElements().size() > 0) {
                Element element2 = element.getChildElements().get(0);
                String string = element2.getLocalName();
                if (Organization.getName(this.getDDMSVersion()).equals(string)) {
                    this._entity = new Organization(element2);
                }
                if (Person.getName(this.getDDMSVersion()).equals(string)) {
                    this._entity = new Person(element2);
                }
            }
            this._securityAttributes = new SecurityAttributes(element);
            this.validate();
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    protected AbstractTaskingRole(String string, IRoleEntity iRoleEntity, SecurityAttributes securityAttributes) throws InvalidDDMSException {
        try {
            Util.requireDDMSValue("entity", iRoleEntity);
            Element element = Util.buildDDMSElement(string, null);
            element.appendChild((Node)iRoleEntity.getXOMElementCopy());
            this._entity = iRoleEntity;
            this._securityAttributes = SecurityAttributes.getNonNullInstance(securityAttributes);
            this._securityAttributes.addTo(element);
            this.setXOMElement(element, true);
        }
        catch (InvalidDDMSException invalidDDMSException) {
            invalidDDMSException.setLocator(this.getQualifiedName());
            throw invalidDDMSException;
        }
    }

    @Override
    protected void validate() throws InvalidDDMSException {
        Util.requireDDMSValue("entity", this.getEntity());
        if (!(this.getEntity() instanceof Organization) && !(this.getEntity() instanceof Person)) {
            throw new InvalidDDMSException("The entity must be a person or an organization.");
        }
        Util.requireBoundedChildCount(this.getXOMElement(), Organization.getName(this.getDDMSVersion()), 0, 1);
        Util.requireBoundedChildCount(this.getXOMElement(), Person.getName(this.getDDMSVersion()), 0, 1);
        Util.requireDDMSValue("security attributes", this.getSecurityAttributes());
        this.getSecurityAttributes().requireClassification();
        this.requireVersion("4.0.1");
        super.validate();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof AbstractTaskingRole;
    }

    @Override
    public String getOutput(boolean bl, String string, String string2) {
        String string3 = this.buildPrefix(string, this.getName(), string2 + ".");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(((AbstractBaseComponent)((Object)this.getEntity())).getOutput(bl, string3, ""));
        stringBuffer.append(this.getSecurityAttributes().getOutput(bl, string3));
        return stringBuffer.toString();
    }

    @Override
    protected List<IDDMSComponent> getNestedComponents() {
        ArrayList<IDDMSComponent> arrayList = new ArrayList<IDDMSComponent>();
        arrayList.add(this.getEntity());
        return arrayList;
    }

    public IRoleEntity getEntity() {
        return this._entity;
    }

    @Override
    public SecurityAttributes getSecurityAttributes() {
        return this._securityAttributes;
    }

    public static abstract class Builder
    implements IBuilder,
    Serializable {
        private static final long serialVersionUID = -1694935853087559491L;
        private String _entityType;
        private Organization.Builder _organization;
        private Person.Builder _person;
        private SecurityAttributes.Builder _securityAttributes;

        protected Builder() {
        }

        protected Builder(AbstractTaskingRole abstractTaskingRole) {
            DDMSVersion dDMSVersion = abstractTaskingRole.getDDMSVersion();
            this.setEntityType(abstractTaskingRole.getEntity().getName());
            if (Organization.getName(dDMSVersion).equals(this.getEntityType())) {
                this.setOrganization(new Organization.Builder((Organization)abstractTaskingRole.getEntity()));
            }
            if (Person.getName(dDMSVersion).equals(this.getEntityType())) {
                this.setPerson(new Person.Builder((Person)abstractTaskingRole.getEntity()));
            }
            this.setSecurityAttributes(new SecurityAttributes.Builder(abstractTaskingRole.getSecurityAttributes()));
        }

        protected IRoleEntity commitSelectedEntity() throws InvalidDDMSException {
            DDMSVersion dDMSVersion = DDMSVersion.getCurrentVersion();
            if (Organization.getName(dDMSVersion).equals(this.getEntityType())) {
                return this.getOrganization().commit();
            }
            return this.getPerson().commit();
        }

        @Override
        public boolean isEmpty() {
            return this.getOrganization().isEmpty() && this.getPerson().isEmpty() && this.getSecurityAttributes().isEmpty();
        }

        public SecurityAttributes.Builder getSecurityAttributes() {
            if (this._securityAttributes == null) {
                this._securityAttributes = new SecurityAttributes.Builder();
            }
            return this._securityAttributes;
        }

        public void setSecurityAttributes(SecurityAttributes.Builder builder) {
            this._securityAttributes = builder;
        }

        public String getEntityType() {
            return this._entityType;
        }

        public void setEntityType(String string) {
            this._entityType = string;
        }

        public Organization.Builder getOrganization() {
            if (this._organization == null) {
                this._organization = new Organization.Builder();
            }
            return this._organization;
        }

        public void setOrganization(Organization.Builder builder) {
            this._organization = builder;
        }

        public Person.Builder getPerson() {
            if (this._person == null) {
                this._person = new Person.Builder();
            }
            return this._person;
        }

        public void setPerson(Person.Builder builder) {
            this._person = builder;
        }
    }
}

